/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create;

import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.AllKeys;
import com.simibubi.create.AllParticleTypes;
import com.simibubi.create.AllStitchedTextures;
import com.simibubi.create.content.contraptions.base.KineticTileEntityRenderer;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionRenderDispatcher;
import com.simibubi.create.content.contraptions.relays.encased.CasingConnectivity;
import com.simibubi.create.content.curiosities.armor.CopperBacktankArmorLayer;
import com.simibubi.create.content.curiosities.bell.SoulPulseEffectHandler;
import com.simibubi.create.content.curiosities.weapons.PotatoCannonRenderHandler;
import com.simibubi.create.content.curiosities.zapper.ZapperRenderHandler;
import com.simibubi.create.content.schematics.ClientSchematicLoader;
import com.simibubi.create.content.schematics.client.SchematicAndQuillHandler;
import com.simibubi.create.content.schematics.client.SchematicHandler;
import com.simibubi.create.events.ClientEvents;
import com.simibubi.create.foundation.ResourceReloadHandler;
import com.simibubi.create.foundation.block.render.CustomBlockModels;
import com.simibubi.create.foundation.block.render.SpriteShifter;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.gui.UIRenderHelper;
import com.simibubi.create.foundation.item.render.CustomItemModels;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModel;
import com.simibubi.create.foundation.item.render.CustomRenderedItems;
import com.simibubi.create.foundation.ponder.content.PonderIndex;
import com.simibubi.create.foundation.ponder.elements.WorldSectionElement;
import com.simibubi.create.foundation.render.AllMaterialSpecs;
import com.simibubi.create.foundation.render.CreateContexts;
import com.simibubi.create.foundation.render.SuperByteBufferCache;
import com.simibubi.create.foundation.utility.ghost.GhostBlocks;
import com.simibubi.create.foundation.utility.outliner.Outliner;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.settings.GraphicsFanciness;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.Item;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

public class CreateClient {
    public static final ClientSchematicLoader SCHEMATIC_SENDER = new ClientSchematicLoader();
    public static final SchematicHandler SCHEMATIC_HANDLER = new SchematicHandler();
    public static final SchematicAndQuillHandler SCHEMATIC_AND_QUILL_HANDLER = new SchematicAndQuillHandler();
    public static final SuperByteBufferCache BUFFER_CACHE = new SuperByteBufferCache();
    public static final Outliner OUTLINER = new Outliner();
    public static final GhostBlocks GHOST_BLOCKS = new GhostBlocks();
    public static final Screen EMPTY_SCREEN = new Screen((ITextComponent)new StringTextComponent("")){};
    public static final ZapperRenderHandler ZAPPER_RENDER_HANDLER = new ZapperRenderHandler();
    public static final PotatoCannonRenderHandler POTATO_CANNON_RENDER_HANDLER = new PotatoCannonRenderHandler();
    public static final SoulPulseEffectHandler SOUL_PULSE_EFFECT_HANDLER = new SoulPulseEffectHandler();
    private static CustomBlockModels customBlockModels;
    private static CustomItemModels customItemModels;
    private static CustomRenderedItems customRenderedItems;
    private static CasingConnectivity casingConnectivity;

    public static void addClientListeners(IEventBus forgeEventBus, IEventBus modEventBus) {
        modEventBus.addListener(CreateClient::clientInit);
        modEventBus.addListener(CreateClient::onTextureStitch);
        modEventBus.addListener(CreateClient::onModelRegistry);
        modEventBus.addListener(CreateClient::onModelBake);
        modEventBus.addListener(AllParticleTypes::registerFactories);
        modEventBus.addListener(ClientEvents::loadCompleted);
        modEventBus.addListener(CreateContexts::flwInit);
        modEventBus.addListener(AllMaterialSpecs::flwInit);
        modEventBus.addListener(ContraptionRenderDispatcher::gatherContext);
        ZAPPER_RENDER_HANDLER.register(forgeEventBus);
        POTATO_CANNON_RENDER_HANDLER.register(forgeEventBus);
    }

    public static void clientInit(FMLClientSetupEvent event) {
        BUFFER_CACHE.registerCompartment(KineticTileEntityRenderer.KINETIC_TILE);
        BUFFER_CACHE.registerCompartment(ContraptionRenderDispatcher.CONTRAPTION, 20L);
        BUFFER_CACHE.registerCompartment(WorldSectionElement.DOC_WORLD_SECTION, 20L);
        AllKeys.register();
        AllBlockPartials.clientInit();
        AllStitchedTextures.init();
        PonderIndex.register();
        PonderIndex.registerTags();
        UIRenderHelper.init();
        event.enqueueWork(() -> {
            IResourceManager resourceManager = Minecraft.func_71410_x().func_195551_G();
            if (resourceManager instanceof IReloadableResourceManager) {
                ((IReloadableResourceManager)resourceManager).func_219534_a((IFutureReloadListener)new ResourceReloadHandler());
            }
            CreateClient.registerLayerRenderers(Minecraft.func_71410_x().func_175598_ae());
        });
    }

    public static void onTextureStitch(TextureStitchEvent.Pre event) {
        if (!event.getMap().func_229223_g_().equals((Object)PlayerContainer.field_226615_c_)) {
            return;
        }
        SpriteShifter.getAllTargetSprites().forEach(arg_0 -> ((TextureStitchEvent.Pre)event).addSprite(arg_0));
    }

    public static void onModelRegistry(ModelRegistryEvent event) {
        CreateClient.getCustomRenderedItems().foreach((item, modelFunc) -> ((CustomRenderedItemModel)((Object)((Object)modelFunc.apply(null)))).getModelLocations().forEach(ModelLoader::addSpecialModel));
    }

    public static void onModelBake(ModelBakeEvent event) {
        Map modelRegistry = event.getModelRegistry();
        CreateClient.getCustomBlockModels().foreach((block, modelFunc) -> CreateClient.swapModels((Map<ResourceLocation, IBakedModel>)modelRegistry, CreateClient.getAllBlockStateModelLocations(block), modelFunc));
        CreateClient.getCustomItemModels().foreach((item, modelFunc) -> CreateClient.swapModels((Map<ResourceLocation, IBakedModel>)modelRegistry, CreateClient.getItemModelLocation(item), modelFunc));
        CreateClient.getCustomRenderedItems().foreach((item, modelFunc) -> CreateClient.swapModels((Map<ResourceLocation, IBakedModel>)modelRegistry, CreateClient.getItemModelLocation(item), (IBakedModel m) -> ((CustomRenderedItemModel)((Object)((Object)((Object)modelFunc.apply(m))))).loadPartials(event)));
    }

    protected static ModelResourceLocation getItemModelLocation(Item item) {
        return new ModelResourceLocation(item.getRegistryName(), "inventory");
    }

    protected static List<ModelResourceLocation> getAllBlockStateModelLocations(Block block) {
        ArrayList<ModelResourceLocation> models = new ArrayList<ModelResourceLocation>();
        block.func_176194_O().func_177619_a().forEach(state -> models.add(CreateClient.getBlockModelLocation(block, BlockModelShapes.func_209552_a((Map)state.func_206871_b()))));
        return models;
    }

    protected static ModelResourceLocation getBlockModelLocation(Block block, String suffix) {
        return new ModelResourceLocation(block.getRegistryName(), suffix);
    }

    protected static <T extends IBakedModel> void swapModels(Map<ResourceLocation, IBakedModel> modelRegistry, List<ModelResourceLocation> locations, Function<IBakedModel, T> factory) {
        locations.forEach(location -> CreateClient.swapModels(modelRegistry, location, factory));
    }

    protected static <T extends IBakedModel> void swapModels(Map<ResourceLocation, IBakedModel> modelRegistry, ModelResourceLocation location, Function<IBakedModel, T> factory) {
        modelRegistry.put((ResourceLocation)location, (IBakedModel)factory.apply(modelRegistry.get(location)));
    }

    protected static void registerLayerRenderers(EntityRendererManager renderManager) {
        CopperBacktankArmorLayer.registerOnAll(renderManager);
    }

    public static CustomItemModels getCustomItemModels() {
        if (customItemModels == null) {
            customItemModels = new CustomItemModels();
        }
        return customItemModels;
    }

    public static CustomRenderedItems getCustomRenderedItems() {
        if (customRenderedItems == null) {
            customRenderedItems = new CustomRenderedItems();
        }
        return customRenderedItems;
    }

    public static CustomBlockModels getCustomBlockModels() {
        if (customBlockModels == null) {
            customBlockModels = new CustomBlockModels();
        }
        return customBlockModels;
    }

    public static CasingConnectivity getCasingConnectivity() {
        if (casingConnectivity == null) {
            casingConnectivity = new CasingConnectivity();
        }
        return casingConnectivity;
    }

    public static void invalidateRenderers() {
        BUFFER_CACHE.invalidate();
        ContraptionRenderDispatcher.reset();
    }

    public static void checkGraphicsFanciness() {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g == null) {
            return;
        }
        if (mc.field_71474_y.field_238330_f_ != GraphicsFanciness.FABULOUS) {
            return;
        }
        if (((Boolean)AllConfigs.CLIENT.ignoreFabulousWarning.get()).booleanValue()) {
            return;
        }
        IFormattableTextComponent text = TextComponentUtils.func_240647_a_((ITextComponent)new StringTextComponent("WARN")).func_240699_a_(TextFormatting.GOLD).func_230529_a_((ITextComponent)new StringTextComponent(" Some of Create's visual features will not be available while Fabulous graphics are enabled!")).func_240700_a_(style -> style.func_240715_a_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/create dismissFabulousWarning")).func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new StringTextComponent("Click here to disable this warning"))));
        mc.field_71456_v.func_238450_a_(ChatType.CHAT, (ITextComponent)text, mc.field_71439_g.func_110124_au());
    }
}

