/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.jei;

import com.google.common.base.Predicates;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.compat.jei.BlueprintTransferHandler;
import com.simibubi.create.compat.jei.GhostIngredientHandler;
import com.simibubi.create.compat.jei.SlotMover;
import com.simibubi.create.compat.jei.category.BlockCuttingCategory;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.compat.jei.category.CrushingCategory;
import com.simibubi.create.compat.jei.category.DeployingCategory;
import com.simibubi.create.compat.jei.category.FanBlastingCategory;
import com.simibubi.create.compat.jei.category.FanSmokingCategory;
import com.simibubi.create.compat.jei.category.FanWashingCategory;
import com.simibubi.create.compat.jei.category.ItemDrainCategory;
import com.simibubi.create.compat.jei.category.MechanicalCraftingCategory;
import com.simibubi.create.compat.jei.category.MillingCategory;
import com.simibubi.create.compat.jei.category.MixingCategory;
import com.simibubi.create.compat.jei.category.MysteriousItemConversionCategory;
import com.simibubi.create.compat.jei.category.PackingCategory;
import com.simibubi.create.compat.jei.category.PolishingCategory;
import com.simibubi.create.compat.jei.category.PressingCategory;
import com.simibubi.create.compat.jei.category.ProcessingViaFanCategory;
import com.simibubi.create.compat.jei.category.SawingCategory;
import com.simibubi.create.compat.jei.category.SequencedAssemblyCategory;
import com.simibubi.create.compat.jei.category.SpoutCategory;
import com.simibubi.create.content.contraptions.components.deployer.DeployerApplicationRecipe;
import com.simibubi.create.content.contraptions.components.press.MechanicalPressTileEntity;
import com.simibubi.create.content.contraptions.components.saw.SawTileEntity;
import com.simibubi.create.content.contraptions.fluids.recipe.PotionMixingRecipeManager;
import com.simibubi.create.content.contraptions.processing.BasinRecipe;
import com.simibubi.create.content.curiosities.tools.BlueprintScreen;
import com.simibubi.create.content.logistics.block.inventories.AdjustableCrateScreen;
import com.simibubi.create.content.logistics.item.LinkedControllerScreen;
import com.simibubi.create.content.logistics.item.filter.AbstractFilterScreen;
import com.simibubi.create.content.logistics.item.filter.AttributeFilterScreen;
import com.simibubi.create.content.logistics.item.filter.FilterScreen;
import com.simibubi.create.content.schematics.block.SchematicTableScreen;
import com.simibubi.create.content.schematics.block.SchematicannonScreen;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.config.CRecipes;
import com.simibubi.create.foundation.config.ConfigBase;
import com.simibubi.create.foundation.utility.recipe.IRecipeTypeInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.ModList;

@JeiPlugin
public class CreateJEI
implements IModPlugin {
    private static final ResourceLocation ID = new ResourceLocation("create", "jei_plugin");
    public IIngredientManager ingredientManager;
    private final List<CreateRecipeCategory<?>> allCategories = new ArrayList();
    private final CreateRecipeCategory<?> milling = this.register("milling", MillingCategory::new).recipes(AllRecipeTypes.MILLING).catalyst(AllBlocks.MILLSTONE::get).build();
    private final CreateRecipeCategory<?> crushing = this.register("crushing", CrushingCategory::new).recipes(AllRecipeTypes.CRUSHING).recipesExcluding(AllRecipeTypes.MILLING::getType, AllRecipeTypes.CRUSHING::getType).catalyst(AllBlocks.CRUSHING_WHEEL::get).build();
    private final CreateRecipeCategory<?> pressing = this.register("pressing", PressingCategory::new).recipes(AllRecipeTypes.PRESSING).catalyst(AllBlocks.MECHANICAL_PRESS::get).build();
    private final CreateRecipeCategory<?> washing = this.register("fan_washing", FanWashingCategory::new).recipes(AllRecipeTypes.SPLASHING).catalystStack(ProcessingViaFanCategory.getFan("fan_washing")).build();
    private final CreateRecipeCategory<?> smoking = this.register("fan_smoking", FanSmokingCategory::new).recipes(() -> IRecipeType.field_222152_d).catalystStack(ProcessingViaFanCategory.getFan("fan_smoking")).build();
    private final CreateRecipeCategory<?> blasting = this.register("fan_blasting", FanBlastingCategory::new).recipesExcluding(() -> IRecipeType.field_222150_b, () -> IRecipeType.field_222151_c).recipes(() -> IRecipeType.field_222151_c).removeRecipes(() -> IRecipeType.field_222152_d).catalystStack(ProcessingViaFanCategory.getFan("fan_blasting")).build();
    private final CreateRecipeCategory<?> mixing = this.register("mixing", MixingCategory::standard).recipes(AllRecipeTypes.MIXING::getType).catalyst(AllBlocks.MECHANICAL_MIXER::get).catalyst(AllBlocks.BASIN::get).build();
    private final CreateRecipeCategory<?> seqAssembly = this.register("sequenced_assembly", SequencedAssemblyCategory::new).recipes(AllRecipeTypes.SEQUENCED_ASSEMBLY::getType).build();
    private final CreateRecipeCategory<?> autoShapeless = this.register("automatic_shapeless", MixingCategory::autoShapeless).recipes(r -> r.func_199559_b() == IRecipeSerializer.field_222158_b && r.func_192400_c().size() > 1 && !MechanicalPressTileEntity.canCompress(r), BasinRecipe::convertShapeless).catalyst(AllBlocks.MECHANICAL_MIXER::get).catalyst(AllBlocks.BASIN::get).enableWhen(c -> c.allowShapelessInMixer).build();
    private final CreateRecipeCategory<?> brewing = this.register("automatic_brewing", MixingCategory::autoBrewing).recipeList(PotionMixingRecipeManager::getAllBrewingRecipes).catalyst(AllBlocks.MECHANICAL_MIXER::get).catalyst(AllBlocks.BASIN::get).build();
    private final CreateRecipeCategory<?> sawing = this.register("sawing", SawingCategory::new).recipes(AllRecipeTypes.CUTTING).catalyst(AllBlocks.MECHANICAL_SAW::get).build();
    private final CreateRecipeCategory<?> blockCutting = this.register("block_cutting", () -> new BlockCuttingCategory(Items.field_221812_dp)).recipeList(() -> BlockCuttingCategory.CondensedBlockCuttingRecipe.condenseRecipes(CreateJEI.findRecipesByType(IRecipeType.field_222154_f))).catalyst(AllBlocks.MECHANICAL_SAW::get).enableWhen(c -> c.allowStonecuttingOnSaw).build();
    private final CreateRecipeCategory<?> woodCutting = this.register("wood_cutting", () -> new BlockCuttingCategory(Items.field_221673_bY)).recipeList(() -> BlockCuttingCategory.CondensedBlockCuttingRecipe.condenseRecipes(CreateJEI.findRecipesByType((IRecipeType)SawTileEntity.woodcuttingRecipeType.func_179281_c()))).catalyst(AllBlocks.MECHANICAL_SAW::get).enableWhenBool(c -> (Boolean)c.allowWoodcuttingOnSaw.get() != false && ModList.get().isLoaded("druidcraft")).build();
    private final CreateRecipeCategory<?> packing = this.register("packing", PackingCategory::standard).recipes(AllRecipeTypes.COMPACTING).catalyst(AllBlocks.MECHANICAL_PRESS::get).catalyst(AllBlocks.BASIN::get).build();
    private final CreateRecipeCategory<?> autoSquare = this.register("automatic_packing", PackingCategory::autoSquare).recipes(r -> r instanceof ICraftingRecipe && MechanicalPressTileEntity.canCompress(r), BasinRecipe::convertShapeless).catalyst(AllBlocks.MECHANICAL_PRESS::get).catalyst(AllBlocks.BASIN::get).enableWhen(c -> c.allowShapedSquareInPress).build();
    private final CreateRecipeCategory<?> polishing = this.register("sandpaper_polishing", PolishingCategory::new).recipes(AllRecipeTypes.SANDPAPER_POLISHING).catalyst(AllItems.SAND_PAPER::get).catalyst(AllItems.RED_SAND_PAPER::get).build();
    private final CreateRecipeCategory<?> deploying = this.register("deploying", DeployingCategory::new).recipeList(() -> DeployerApplicationRecipe.convert(CreateJEI.findRecipesByType(AllRecipeTypes.SANDPAPER_POLISHING.getType()))).recipes(AllRecipeTypes.DEPLOYING).catalyst(AllBlocks.DEPLOYER::get).catalyst(AllBlocks.DEPOT::get).catalyst(AllItems.BELT_CONNECTOR::get).build();
    private final CreateRecipeCategory<?> mysteryConversion = this.register("mystery_conversion", MysteriousItemConversionCategory::new).recipeList(MysteriousItemConversionCategory::getRecipes).build();
    private final CreateRecipeCategory<?> spoutFilling = this.register("spout_filling", SpoutCategory::new).recipes(AllRecipeTypes.FILLING).recipeList(() -> SpoutCategory.getRecipes(this.ingredientManager)).catalyst(AllBlocks.SPOUT::get).build();
    private final CreateRecipeCategory<?> draining = this.register("draining", ItemDrainCategory::new).recipeList(() -> ItemDrainCategory.getRecipes(this.ingredientManager)).recipes(AllRecipeTypes.EMPTYING).catalyst(AllBlocks.ITEM_DRAIN::get).build();
    private final CreateRecipeCategory<?> autoShaped = this.register("automatic_shaped", MechanicalCraftingCategory::new).recipes(r -> r.func_199559_b() == IRecipeSerializer.field_222158_b && r.func_192400_c().size() == 1).recipes(r -> r.func_222127_g() == IRecipeType.field_222149_a && r.func_222127_g() != AllRecipeTypes.MECHANICAL_CRAFTING.getType() && r instanceof ShapedRecipe).catalyst(AllBlocks.MECHANICAL_CRAFTER::get).enableWhen(c -> c.allowRegularCraftingInCrafter).build();
    private final CreateRecipeCategory<?> mechanicalCrafting = this.register("mechanical_crafting", MechanicalCraftingCategory::new).recipes(AllRecipeTypes.MECHANICAL_CRAFTING).catalyst(AllBlocks.MECHANICAL_CRAFTER::get).build();

    private <T extends IRecipe<?>> CategoryBuilder<T> register(String name, Supplier<CreateRecipeCategory<T>> supplier) {
        return new CategoryBuilder<T>(name, supplier);
    }

    @Nonnull
    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new BlueprintTransferHandler(), VanillaRecipeCategoryUid.CRAFTING);
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        this.allCategories.forEach(xva$0 -> registration.addRecipeCategories(new IRecipeCategory[]{xva$0}));
    }

    public void registerRecipes(IRecipeRegistration registration) {
        this.ingredientManager = registration.getIngredientManager();
        this.allCategories.forEach(c -> c.recipes.forEach(s -> registration.addRecipes((Collection)s.get(), c.getUid())));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        this.allCategories.forEach(c -> c.recipeCatalysts.forEach(s -> registration.addRecipeCatalyst(s.get(), new ResourceLocation[]{c.getUid()})));
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        SlotMover slotMover = new SlotMover();
        registration.addGuiContainerHandler(SchematicTableScreen.class, (IGuiContainerHandler)slotMover);
        registration.addGuiContainerHandler(SchematicannonScreen.class, (IGuiContainerHandler)slotMover);
        registration.addGuiContainerHandler(AdjustableCrateScreen.class, (IGuiContainerHandler)slotMover);
        registration.addGuiContainerHandler(FilterScreen.class, (IGuiContainerHandler)slotMover);
        registration.addGuiContainerHandler(AttributeFilterScreen.class, (IGuiContainerHandler)slotMover);
        registration.addGuiContainerHandler(BlueprintScreen.class, (IGuiContainerHandler)slotMover);
        registration.addGuiContainerHandler(LinkedControllerScreen.class, (IGuiContainerHandler)slotMover);
        registration.addGhostIngredientHandler(AbstractFilterScreen.class, new GhostIngredientHandler());
        registration.addGhostIngredientHandler(BlueprintScreen.class, new GhostIngredientHandler());
    }

    public static List<IRecipe<?>> findRecipes(Predicate<IRecipe<?>> predicate) {
        return Minecraft.func_71410_x().field_71441_e.func_199532_z().func_199510_b().stream().filter(predicate).collect(Collectors.toList());
    }

    public static List<IRecipe<?>> findRecipesByType(IRecipeType<?> type) {
        return CreateJEI.findRecipes(recipe -> recipe.func_222127_g() == type);
    }

    public static List<IRecipe<?>> findRecipesByTypeExcluding(IRecipeType<?> type, IRecipeType<?> excludingType) {
        List<IRecipe<?>> byType = CreateJEI.findRecipesByType(type);
        CreateJEI.removeRecipesByType(byType, excludingType);
        return byType;
    }

    public static List<IRecipe<?>> findRecipesByTypeExcluding(IRecipeType<?> type, IRecipeType<?> ... excludingTypes) {
        List<IRecipe<?>> byType = CreateJEI.findRecipesByType(type);
        for (IRecipeType<?> excludingType : excludingTypes) {
            CreateJEI.removeRecipesByType(byType, excludingType);
        }
        return byType;
    }

    public static void removeRecipesByType(List<IRecipe<?>> recipes, IRecipeType<?> type) {
        List<IRecipe<?>> byType = CreateJEI.findRecipesByType(type);
        recipes.removeIf(recipe -> {
            for (IRecipe r : byType) {
                if (!CreateJEI.doInputsMatch(recipe, r)) continue;
                return true;
            }
            return false;
        });
    }

    public static boolean doInputsMatch(IRecipe<?> recipe1, IRecipe<?> recipe2) {
        ItemStack[] matchingStacks = ((Ingredient)recipe1.func_192400_c().get(0)).func_193365_a();
        if (matchingStacks.length == 0) {
            return true;
        }
        return ((Ingredient)recipe2.func_192400_c().get(0)).test(matchingStacks[0]);
    }

    private class CategoryBuilder<T extends IRecipe<?>> {
        private CreateRecipeCategory<T> category;
        private List<Consumer<List<IRecipe<?>>>> recipeListConsumers = new ArrayList();
        private Predicate<CRecipes> pred;

        public CategoryBuilder(String name, Supplier<CreateRecipeCategory<T>> category) {
            this.category = category.get();
            this.category.setCategoryId(name);
            this.pred = Predicates.alwaysTrue();
        }

        public CategoryBuilder<T> recipes(IRecipeTypeInfo recipeTypeEntry) {
            return this.recipes(recipeTypeEntry::getType);
        }

        public CategoryBuilder<T> recipes(Supplier<IRecipeType<? extends T>> recipeType) {
            return this.recipes((IRecipe<?> r) -> r.func_222127_g() == recipeType.get());
        }

        public CategoryBuilder<T> recipes(ResourceLocation serializer) {
            return this.recipes((IRecipe<?> r) -> r.func_199559_b().getRegistryName().equals((Object)serializer));
        }

        public CategoryBuilder<T> recipes(Predicate<IRecipe<?>> pred) {
            return this.recipeList(() -> CreateJEI.findRecipes(pred));
        }

        public CategoryBuilder<T> recipes(Predicate<IRecipe<?>> pred, Function<IRecipe<?>, T> converter) {
            return this.recipeList(() -> CreateJEI.findRecipes(pred), converter);
        }

        public CategoryBuilder<T> recipeList(Supplier<List<? extends IRecipe<?>>> list) {
            return this.recipeList(list, null);
        }

        public CategoryBuilder<T> recipeList(Supplier<List<? extends IRecipe<?>>> list, Function<IRecipe<?>, T> converter) {
            this.recipeListConsumers.add(recipes -> {
                List toAdd = (List)list.get();
                if (converter != null) {
                    toAdd = toAdd.stream().map(converter).collect(Collectors.toList());
                }
                recipes.addAll(toAdd);
            });
            return this;
        }

        public CategoryBuilder<T> recipesExcluding(Supplier<IRecipeType<? extends T>> recipeType, Supplier<IRecipeType<? extends T>> excluded) {
            this.recipeListConsumers.add(recipes -> recipes.addAll(CreateJEI.findRecipesByTypeExcluding((IRecipeType)recipeType.get(), (IRecipeType)excluded.get())));
            return this;
        }

        public CategoryBuilder<T> removeRecipes(Supplier<IRecipeType<? extends T>> recipeType) {
            this.recipeListConsumers.add(recipes -> CreateJEI.removeRecipesByType(recipes, (IRecipeType)recipeType.get()));
            return this;
        }

        public CategoryBuilder<T> catalyst(Supplier<IItemProvider> supplier) {
            return this.catalystStack(() -> new ItemStack((IItemProvider)((IItemProvider)supplier.get()).func_199767_j()));
        }

        public CategoryBuilder<T> catalystStack(Supplier<ItemStack> supplier) {
            this.category.recipeCatalysts.add(supplier);
            return this;
        }

        public CategoryBuilder<T> enableWhen(Function<CRecipes, ConfigBase.ConfigBool> configValue) {
            this.pred = c -> (Boolean)((ConfigBase.ConfigBool)configValue.apply((CRecipes)c)).get();
            return this;
        }

        public CategoryBuilder<T> enableWhenBool(Function<CRecipes, Boolean> configValue) {
            this.pred = configValue::apply;
            return this;
        }

        public CreateRecipeCategory<T> build() {
            if (this.pred.test(AllConfigs.SERVER.recipes)) {
                this.category.recipes.add(() -> {
                    ArrayList recipes = new ArrayList();
                    for (Consumer<List<IRecipe<?>>> consumer : this.recipeListConsumers) {
                        consumer.accept(recipes);
                    }
                    return recipes;
                });
            }
            CreateJEI.this.allCategories.add(this.category);
            return this.category;
        }
    }
}

