/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.flywheel.engine;

import com.jozufozu.flywheel.core.PartialModel;
import com.simibubi.create.content.contraptions.wrench.IWrenchable;
import com.simibubi.create.foundation.utility.Iterate;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class EngineBlock
extends HorizontalBlock
implements IWrenchable {
    protected EngineBlock(AbstractBlock.Properties builder) {
        super(builder);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return this.isValidPosition(state, (IBlockReader)worldIn, pos, (Direction)state.func_177229_b((Property)field_185512_D));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Override
    public ActionResultType onWrenched(BlockState state, ItemUseContext context) {
        return ActionResultType.FAIL;
    }

    public abstract TileEntity createTileEntity(BlockState var1, IBlockReader var2);

    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction facing = context.func_196000_l();
        return (BlockState)this.func_176223_P().func_206870_a((Property)field_185512_D, (Comparable)(facing.func_176740_k().func_200128_b() ? context.func_195992_f().func_176734_d() : facing));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder.func_206894_a(new Property[]{field_185512_D}));
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (worldIn.field_72995_K) {
            return;
        }
        if (fromPos.equals((Object)EngineBlock.getBaseBlockPos(state, pos)) && !this.func_196260_a(state, (IWorldReader)worldIn, pos)) {
            worldIn.func_175655_b(pos, true);
            return;
        }
    }

    private boolean isValidPosition(BlockState state, IBlockReader world, BlockPos pos, Direction facing) {
        BlockPos baseBlockPos = EngineBlock.getBaseBlockPos(state, pos);
        if (!this.isValidBaseBlock(world.func_180495_p(baseBlockPos), world, pos)) {
            return false;
        }
        for (Direction otherFacing : Iterate.horizontalDirections) {
            BlockPos otherPos;
            BlockState otherState;
            if (otherFacing == facing || !((otherState = world.func_180495_p(otherPos = baseBlockPos.func_177972_a(otherFacing))).func_177230_c() instanceof EngineBlock) || !EngineBlock.getBaseBlockPos(otherState, otherPos).equals((Object)baseBlockPos)) continue;
            return false;
        }
        return true;
    }

    public static BlockPos getBaseBlockPos(BlockState state, BlockPos pos) {
        return pos.func_177972_a(((Direction)state.func_177229_b((Property)field_185512_D)).func_176734_d());
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public abstract PartialModel getFrameModel();

    protected abstract boolean isValidBaseBlock(BlockState var1, IBlockReader var2, BlockPos var3);
}

