/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.mounted;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.components.structureMovement.AssemblyException;
import com.simibubi.create.content.contraptions.components.structureMovement.IDisplayAssemblyExceptions;
import com.simibubi.create.content.contraptions.components.structureMovement.OrientedContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.mounted.CartAssemblerBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.mounted.MountedContraption;
import com.simibubi.create.content.contraptions.components.structureMovement.train.CouplingHandler;
import com.simibubi.create.content.contraptions.components.structureMovement.train.capability.CapabilityMinecartController;
import com.simibubi.create.content.contraptions.components.structureMovement.train.capability.MinecartController;
import com.simibubi.create.content.contraptions.components.tracks.ControllerRailBlock;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.CenteredSideValueBoxTransform;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.INamedIconOptions;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.item.minecart.FurnaceMinecartEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.RailShape;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class CartAssemblerTileEntity
extends SmartTileEntity
implements IDisplayAssemblyExceptions {
    private static final int assemblyCooldown = 8;
    protected ScrollOptionBehaviour<CartMovementMode> movementMode;
    private int ticksSinceMinecartUpdate = 8;
    protected AssemblyException lastException;
    protected AbstractMinecartEntity cartToAssemble;

    public CartAssemblerTileEntity(TileEntityType<? extends CartAssemblerTileEntity> type) {
        super(type);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.ticksSinceMinecartUpdate < 8) {
            ++this.ticksSinceMinecartUpdate;
        }
        this.tryAssemble(this.cartToAssemble);
        this.cartToAssemble = null;
    }

    public void tryAssemble(AbstractMinecartEntity cart) {
        if (cart == null) {
            return;
        }
        if (!this.isMinecartUpdateValid()) {
            return;
        }
        this.resetTicksSinceMinecartUpdate();
        BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (!AllBlocks.CART_ASSEMBLER.has(state)) {
            return;
        }
        CartAssemblerBlock block = (CartAssemblerBlock)state.func_177230_c();
        CartAssemblerBlock.CartAssemblerAction action = CartAssemblerBlock.getActionForCart(state, cart);
        if (action.shouldAssemble()) {
            this.assemble(this.field_145850_b, this.field_174879_c, cart);
        }
        if (action.shouldDisassemble()) {
            this.disassemble(this.field_145850_b, this.field_174879_c, cart);
        }
        if (action == CartAssemblerBlock.CartAssemblerAction.ASSEMBLE_ACCELERATE && cart.func_213322_ci().func_72433_c() > 0.0078125) {
            Direction facing = cart.func_184172_bi();
            RailShape railShape = (RailShape)state.func_177229_b(CartAssemblerBlock.RAIL_SHAPE);
            for (Direction d : Iterate.directionsInAxis(railShape == RailShape.EAST_WEST ? Direction.Axis.X : Direction.Axis.Z)) {
                if (!this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(d)).func_215686_e((IBlockReader)this.field_145850_b, this.field_174879_c.func_177972_a(d))) continue;
                facing = d.func_176734_d();
            }
            float speed = block.getRailMaxSpeed(state, this.field_145850_b, this.field_174879_c, cart);
            cart.func_213293_j((double)((float)facing.func_82601_c() * speed), (double)((float)facing.func_96559_d() * speed), (double)((float)facing.func_82599_e() * speed));
        }
        if (action == CartAssemblerBlock.CartAssemblerAction.ASSEMBLE_ACCELERATE_DIRECTIONAL) {
            Vector3i accelerationVector = ControllerRailBlock.getAccelerationVector((BlockState)((BlockState)AllBlocks.CONTROLLER_RAIL.getDefaultState().func_206870_a(ControllerRailBlock.SHAPE, state.func_177229_b(CartAssemblerBlock.RAIL_SHAPE))).func_206870_a((Property)ControllerRailBlock.BACKWARDS, state.func_177229_b((Property)CartAssemblerBlock.BACKWARDS)));
            float speed = block.getRailMaxSpeed(state, this.field_145850_b, this.field_174879_c, cart);
            cart.func_213317_d(Vector3d.func_237491_b_((Vector3i)accelerationVector).func_186678_a((double)speed));
        }
        if (action == CartAssemblerBlock.CartAssemblerAction.DISASSEMBLE_BRAKE) {
            Vector3d diff = VecHelper.getCenterOf((Vector3i)this.field_174879_c).func_178788_d(cart.func_213303_ch());
            cart.func_213293_j(diff.field_72450_a / 16.0, 0.0, diff.field_72449_c / 16.0);
        }
    }

    protected void assemble(World world, BlockPos pos, AbstractMinecartEntity cart) {
        if (!cart.func_184188_bt().isEmpty()) {
            return;
        }
        LazyOptional optional = cart.getCapability(CapabilityMinecartController.MINECART_CONTROLLER_CAPABILITY);
        if (optional.isPresent() && ((MinecartController)optional.orElse(null)).isCoupledThroughContraption()) {
            return;
        }
        CartMovementMode mode = CartMovementMode.values()[this.movementMode.value];
        MountedContraption contraption = new MountedContraption(mode);
        try {
            if (!contraption.assemble(world, pos)) {
                return;
            }
            this.lastException = null;
            this.sendData();
        }
        catch (AssemblyException e) {
            this.lastException = e;
            this.sendData();
            return;
        }
        boolean couplingFound = contraption.connectedCart != null;
        Direction initialOrientation = CartAssemblerBlock.getHorizontalDirection(this.func_195044_w());
        if (couplingFound) {
            cart.func_70107_b((double)((float)pos.func_177958_n() + 0.5f), (double)pos.func_177956_o(), (double)((float)pos.func_177952_p() + 0.5f));
            if (!CouplingHandler.tryToCoupleCarts(null, world, cart.func_145782_y(), contraption.connectedCart.func_145782_y())) {
                return;
            }
        }
        contraption.removeBlocksFromWorld(world, BlockPos.field_177992_a);
        contraption.startMoving(world);
        contraption.expandBoundsAroundAxis(Direction.Axis.Y);
        if (couplingFound) {
            Vector3d diff = contraption.connectedCart.func_213303_ch().func_178788_d(cart.func_213303_ch());
            initialOrientation = Direction.func_176733_a((double)(MathHelper.func_181159_b((double)diff.field_72449_c, (double)diff.field_72450_a) * 180.0 / Math.PI));
        }
        OrientedContraptionEntity entity = OrientedContraptionEntity.create(world, contraption, initialOrientation);
        if (couplingFound) {
            entity.setCouplingId(cart.func_110124_au());
        }
        entity.func_70107_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        world.func_217376_c((Entity)entity);
        entity.func_184220_m((Entity)cart);
        if (cart instanceof FurnaceMinecartEntity) {
            CompoundNBT nbt = cart.serializeNBT();
            nbt.func_74780_a("PushZ", 0.0);
            nbt.func_74780_a("PushX", 0.0);
            cart.deserializeNBT(nbt);
        }
    }

    protected void disassemble(World world, BlockPos pos, AbstractMinecartEntity cart) {
        if (cart.func_184188_bt().isEmpty()) {
            return;
        }
        Entity entity = (Entity)cart.func_184188_bt().get(0);
        if (!(entity instanceof OrientedContraptionEntity)) {
            return;
        }
        OrientedContraptionEntity contraption = (OrientedContraptionEntity)entity;
        UUID couplingId = contraption.getCouplingId();
        if (couplingId == null) {
            contraption.yaw = CartAssemblerBlock.getHorizontalDirection(this.func_195044_w()).func_185119_l();
            this.disassembleCart(cart);
            return;
        }
        Couple<MinecartController> coupledCarts = contraption.getCoupledCartsIfPresent();
        if (coupledCarts == null) {
            return;
        }
        for (boolean current : Iterate.trueAndFalse) {
            MinecartController minecartController = coupledCarts.get(current);
            if (minecartController.cart() == cart) continue;
            BlockPos otherPos = minecartController.cart().func_233580_cy_();
            BlockState blockState = world.func_180495_p(otherPos);
            if (!AllBlocks.CART_ASSEMBLER.has(blockState)) {
                return;
            }
            if (CartAssemblerBlock.getActionForCart(blockState, minecartController.cart()).shouldDisassemble()) continue;
            return;
        }
        for (boolean current : Iterate.trueAndFalse) {
            coupledCarts.get(current).removeConnection(current);
        }
        this.disassembleCart(cart);
    }

    protected void disassembleCart(AbstractMinecartEntity cart) {
        cart.func_184226_ay();
        if (cart instanceof FurnaceMinecartEntity) {
            CompoundNBT nbt = cart.serializeNBT();
            nbt.func_74780_a("PushZ", cart.func_213322_ci().field_72450_a);
            nbt.func_74780_a("PushX", cart.func_213322_ci().field_72449_c);
            cart.deserializeNBT(nbt);
        }
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        this.movementMode = new ScrollOptionBehaviour<CartMovementMode>(CartMovementMode.class, (ITextComponent)Lang.translate("contraptions.cart_movement_mode", new Object[0]), this, this.getMovementModeSlot());
        this.movementMode.requiresWrench();
        behaviours.add(this.movementMode);
    }

    @Override
    public void write(CompoundNBT compound, boolean clientPacket) {
        AssemblyException.write(compound, this.lastException);
        super.write(compound, clientPacket);
    }

    @Override
    protected void fromTag(BlockState state, CompoundNBT compound, boolean clientPacket) {
        this.lastException = AssemblyException.read(compound);
        super.fromTag(state, compound, clientPacket);
    }

    @Override
    public AssemblyException getLastAssemblyException() {
        return this.lastException;
    }

    protected ValueBoxTransform getMovementModeSlot() {
        return new CartAssemblerValueBoxTransform();
    }

    public void resetTicksSinceMinecartUpdate() {
        this.ticksSinceMinecartUpdate = 0;
    }

    public void assembleNextTick(AbstractMinecartEntity cart) {
        if (this.cartToAssemble == null) {
            this.cartToAssemble = cart;
        }
    }

    public boolean isMinecartUpdateValid() {
        return this.ticksSinceMinecartUpdate >= 8;
    }

    public static enum CartMovementMode implements INamedIconOptions
    {
        ROTATE(AllIcons.I_CART_ROTATE),
        ROTATE_PAUSED(AllIcons.I_CART_ROTATE_PAUSED),
        ROTATION_LOCKED(AllIcons.I_CART_ROTATE_LOCKED);

        private String translationKey;
        private AllIcons icon;

        private CartMovementMode(AllIcons icon) {
            this.icon = icon;
            this.translationKey = "contraptions.cart_movement_mode." + Lang.asId(this.name());
        }

        @Override
        public AllIcons getIcon() {
            return this.icon;
        }

        @Override
        public String getTranslationKey() {
            return this.translationKey;
        }
    }

    private class CartAssemblerValueBoxTransform
    extends CenteredSideValueBoxTransform {
        public CartAssemblerValueBoxTransform() {
            super((BlockState state, Direction d) -> {
                if (d.func_176740_k().func_200128_b()) {
                    return false;
                }
                if (!state.func_235901_b_(CartAssemblerBlock.RAIL_SHAPE)) {
                    return false;
                }
                RailShape railShape = (RailShape)state.func_177229_b(CartAssemblerBlock.RAIL_SHAPE);
                return d.func_176740_k() == Direction.Axis.X == (railShape == RailShape.NORTH_SOUTH);
            });
        }

        @Override
        protected Vector3d getSouthLocation() {
            return VecHelper.voxelSpace(8.0, 8.0, 18.0);
        }
    }
}

