/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids.pipes;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.fluids.FluidPropagator;
import com.simibubi.create.content.contraptions.fluids.FluidTransportBehaviour;
import com.simibubi.create.content.contraptions.fluids.pipes.FluidPipeBlock;
import com.simibubi.create.content.contraptions.wrench.IWrenchable;
import com.simibubi.create.content.schematics.ISpecialBlockItemRequirement;
import com.simibubi.create.content.schematics.ItemRequirement;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SixWayBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.network.DebugPacketSender;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.TickPriority;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class EncasedPipeBlock
extends Block
implements IWrenchable,
ISpecialBlockItemRequirement {
    public static final Map<Direction, BooleanProperty> FACING_TO_PROPERTY_MAP = SixWayBlock.field_196491_B;

    public EncasedPipeBlock(AbstractBlock.Properties p_i48339_1_) {
        super(p_i48339_1_);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208151_D, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)BlockStateProperties.field_208153_F, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)BlockStateProperties.field_208150_C, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)BlockStateProperties.field_208149_B, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)BlockStateProperties.field_208154_G, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)BlockStateProperties.field_208152_E, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208151_D, BlockStateProperties.field_208152_E, BlockStateProperties.field_208153_F, BlockStateProperties.field_208154_G, BlockStateProperties.field_208149_B, BlockStateProperties.field_208150_C});
        super.func_206840_a(builder);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        boolean blockTypeChanged;
        boolean bl = blockTypeChanged = state.func_177230_c() != newState.func_177230_c();
        if (blockTypeChanged && !world.field_72995_K) {
            FluidPropagator.propagateChangedPipe((IWorld)world, pos, state);
        }
        if (state.hasTileEntity() && (blockTypeChanged || !newState.hasTileEntity())) {
            world.func_175713_t(pos);
        }
    }

    public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!world.field_72995_K && state != oldState) {
            world.func_205220_G_().func_205362_a(pos, (Object)this, 1, TickPriority.HIGH);
        }
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return AllBlocks.FLUID_PIPE.asStack();
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block otherBlock, BlockPos neighborPos, boolean isMoving) {
        DebugPacketSender.func_218806_a((World)world, (BlockPos)pos);
        Direction d = FluidPropagator.validateNeighbourChange(state, world, pos, otherBlock, neighborPos, isMoving);
        if (d == null) {
            return;
        }
        if (!((Boolean)state.func_177229_b((Property)FACING_TO_PROPERTY_MAP.get(d))).booleanValue()) {
            return;
        }
        world.func_205220_G_().func_205362_a(pos, (Object)this, 1, TickPriority.HIGH);
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random r) {
        FluidPropagator.propagateChangedPipe((IWorld)world, pos, state);
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return AllTileEntities.ENCASED_FLUID_PIPE.create();
    }

    @Override
    public ActionResultType onWrenched(BlockState state, ItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        context.func_195991_k().func_217379_c(2001, context.func_195995_a(), Block.func_196246_j((BlockState)state));
        BlockState equivalentPipe = EncasedPipeBlock.transferSixWayProperties(state, AllBlocks.FLUID_PIPE.getDefaultState());
        Direction firstFound = Direction.UP;
        for (Direction d : Iterate.directions) {
            if (!((Boolean)state.func_177229_b((Property)FACING_TO_PROPERTY_MAP.get(d))).booleanValue()) continue;
            firstFound = d;
            break;
        }
        FluidTransportBehaviour.cacheFlows((IWorld)world, pos);
        world.func_175656_a(pos, ((FluidPipeBlock)AllBlocks.FLUID_PIPE.get()).updateBlockState(equivalentPipe, firstFound, null, (IBlockDisplayReader)world, pos));
        FluidTransportBehaviour.loadFlows((IWorld)world, pos);
        return ActionResultType.SUCCESS;
    }

    public static BlockState transferSixWayProperties(BlockState from, BlockState to) {
        for (Direction d : Iterate.directions) {
            BooleanProperty property = FACING_TO_PROPERTY_MAP.get(d);
            to = (BlockState)to.func_206870_a((Property)property, from.func_177229_b((Property)property));
        }
        return to;
    }

    @Override
    public ItemRequirement getRequiredItems(BlockState state, TileEntity te) {
        return ItemRequirement.of(AllBlocks.FLUID_PIPE.getDefaultState(), te);
    }
}

