/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.processing.burner;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.contraptions.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.utility.Lang;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;

public class LitBlazeBurnerBlock
extends Block {
    public static final EnumProperty<FlameType> FLAME_TYPE = EnumProperty.func_177709_a((String)"flame_type", FlameType.class);

    public LitBlazeBurnerBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a(FLAME_TYPE, (Comparable)((Object)FlameType.REGULAR)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{FLAME_TYPE});
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult blockRayTraceResult) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (heldItem.getToolTypes().contains(ToolType.SHOVEL)) {
            world.func_184133_a(player, pos, SoundEvents.field_187541_bC, SoundCategory.BLOCKS, 0.5f, 2.0f);
            if (world.field_72995_K) {
                return ActionResultType.SUCCESS;
            }
            heldItem.func_222118_a(1, (LivingEntity)player, p -> p.func_213334_d(hand));
            world.func_175656_a(pos, AllBlocks.BLAZE_BURNER.getDefaultState());
            return ActionResultType.SUCCESS;
        }
        if (state.func_177229_b(FLAME_TYPE) == FlameType.REGULAR && heldItem.func_77973_b().func_206844_a((ITag)ItemTags.field_232906_Q_)) {
            world.func_184133_a(player, pos, SoundEvents.field_232823_nK_, SoundCategory.BLOCKS, 1.0f, world.field_73012_v.nextFloat() * 0.4f + 0.8f);
            if (world.field_72995_K) {
                return ActionResultType.SUCCESS;
            }
            world.func_175656_a(pos, (BlockState)this.func_176223_P().func_206870_a(FLAME_TYPE, (Comparable)((Object)FlameType.SOUL)));
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        return ((BlazeBurnerBlock)AllBlocks.BLAZE_BURNER.get()).func_220053_a(state, reader, pos, context);
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return AllItems.EMPTY_BLAZE_BURNER.asStack();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random random) {
        world.func_217404_b((IParticleData)ParticleTypes.field_197594_E, true, (double)pos.func_177958_n() + 0.5 + random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), (double)pos.func_177956_o() + random.nextDouble() + random.nextDouble(), (double)pos.func_177952_p() + 0.5 + random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), 0.0, 0.07, 0.0);
        if (random.nextInt(10) == 0) {
            world.func_184134_a((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), SoundEvents.field_219605_aC, SoundCategory.BLOCKS, 0.25f + random.nextFloat() * 0.25f, random.nextFloat() * 0.7f + 0.6f, false);
        }
        if (state.func_177229_b(FLAME_TYPE) == FlameType.SOUL) {
            if (random.nextInt(8) == 0) {
                world.func_195594_a((IParticleData)ParticleTypes.field_239812_C_, (double)((float)pos.func_177958_n() + 0.5f) + random.nextDouble() / 4.0 * (double)(random.nextBoolean() ? 1 : -1), (double)((float)pos.func_177956_o() + 0.3f) + random.nextDouble() / 2.0, (double)((float)pos.func_177952_p() + 0.5f) + random.nextDouble() / 4.0 * (double)(random.nextBoolean() ? 1 : -1), 0.0, random.nextDouble() * 0.04 + 0.04, 0.0);
            }
            return;
        }
        if (random.nextInt(5) == 0) {
            for (int i = 0; i < random.nextInt(1) + 1; ++i) {
                world.func_195594_a((IParticleData)ParticleTypes.field_197595_F, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), (double)(random.nextFloat() / 2.0f), 5.0E-5, (double)(random.nextFloat() / 2.0f));
            }
        }
    }

    public boolean func_149740_M(BlockState p_149740_1_) {
        return true;
    }

    public int func_180641_l(BlockState state, World p_180641_2_, BlockPos p_180641_3_) {
        return state.func_177229_b(FLAME_TYPE) == FlameType.REGULAR ? 1 : 2;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        return ((BlazeBurnerBlock)AllBlocks.BLAZE_BURNER.get()).func_220071_b(state, reader, pos, context);
    }

    public boolean func_196266_a(BlockState state, IBlockReader reader, BlockPos pos, PathType type) {
        return false;
    }

    public static int getLight(BlockState state) {
        if (state.func_177229_b(FLAME_TYPE) == FlameType.SOUL) {
            return 9;
        }
        return 12;
    }

    public static enum FlameType implements IStringSerializable
    {
        REGULAR,
        SOUL;


        public String func_176610_l() {
            return Lang.asId(this.name());
        }
    }
}

