/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.weapons;

import com.simibubi.create.AllEnchantments;
import com.simibubi.create.AllEntityTypes;
import com.simibubi.create.Create;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.curiosities.armor.BackTankUtil;
import com.simibubi.create.content.curiosities.weapons.PotatoCannonPacket;
import com.simibubi.create.content.curiosities.weapons.PotatoCannonProjectileTypes;
import com.simibubi.create.content.curiosities.weapons.PotatoProjectileEntity;
import com.simibubi.create.content.curiosities.zapper.ShootableGadgetItemMethods;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.ShootableItem;
import net.minecraft.item.UseAction;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PotatoCannonItem
extends ShootableItem {
    public static ItemStack CLIENT_CURRENT_AMMO = ItemStack.field_190927_a;
    public static final int MAX_DAMAGE = 100;

    public PotatoCannonItem(Item.Properties p_i48487_1_) {
        super(p_i48487_1_);
    }

    public boolean func_195938_a(BlockState p_195938_1_, World p_195938_2_, BlockPos p_195938_3_, PlayerEntity p_195938_4_) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment == Enchantments.field_185309_u) {
            return true;
        }
        if (enchantment == Enchantments.field_185310_v) {
            return true;
        }
        if (enchantment == Enchantments.field_185311_w) {
            return true;
        }
        if (enchantment == Enchantments.field_185304_p) {
            return true;
        }
        if (enchantment == AllEnchantments.POTATO_RECOVERY.get()) {
            return true;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        return this.func_77659_a(context.func_195991_k(), context.func_195999_j(), context.func_221531_n()).func_188397_a();
    }

    public int getItemStackLimit(ItemStack stack) {
        return 1;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return BackTankUtil.getRGBDurabilityForDisplay(stack, this.maxUses());
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return BackTankUtil.getDurabilityForDisplay(stack, this.maxUses());
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return BackTankUtil.showDurabilityBar(stack, this.maxUses());
    }

    private int maxUses() {
        return (Integer)AllConfigs.SERVER.curiosities.maxPotatoCannonShots.get();
    }

    public boolean func_77645_m() {
        return true;
    }

    public boolean isCannon(ItemStack stack) {
        return stack.func_77973_b() instanceof PotatoCannonItem;
    }

    public int getMaxDamage(ItemStack stack) {
        return 100;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        return this.findAmmoInInventory(world, player, stack).map(itemStack -> {
            if (ShootableGadgetItemMethods.shouldSwap(player, stack, hand, this::isCannon)) {
                return ActionResult.func_226251_d_((Object)stack);
            }
            if (world.field_72995_K) {
                CreateClient.POTATO_CANNON_RENDER_HANDLER.dontAnimateItem(hand);
                return ActionResult.func_226248_a_((Object)stack);
            }
            Vector3d barrelPos = ShootableGadgetItemMethods.getGunBarrelVec(player, hand == Hand.MAIN_HAND, new Vector3d(0.75, (double)-0.15f, 1.5));
            Vector3d correction = ShootableGadgetItemMethods.getGunBarrelVec(player, hand == Hand.MAIN_HAND, new Vector3d((double)-0.05f, 0.0, 0.0)).func_178788_d(player.func_213303_ch().func_72441_c(0.0, (double)player.func_70047_e(), 0.0));
            PotatoCannonProjectileTypes projectileType = PotatoCannonProjectileTypes.getProjectileTypeOf(itemStack).orElse(PotatoCannonProjectileTypes.FALLBACK);
            Vector3d lookVec = player.func_70040_Z();
            Vector3d motion = lookVec.func_178787_e(correction).func_72432_b().func_186678_a((double)projectileType.getVelocityMultiplier());
            float soundPitch = projectileType.getSoundPitch() + (Create.RANDOM.nextFloat() - 0.5f) / 4.0f;
            boolean spray = projectileType.getSplit() > 1;
            Vector3d sprayBase = VecHelper.rotate(new Vector3d(0.0, 0.1, 0.0), 360.0f * Create.RANDOM.nextFloat(), Direction.Axis.Z);
            float sprayChange = 360.0f / (float)projectileType.getSplit();
            for (int i = 0; i < projectileType.getSplit(); ++i) {
                PotatoProjectileEntity projectile = AllEntityTypes.POTATO_PROJECTILE.create(world);
                projectile.setItem((ItemStack)itemStack);
                projectile.setEnchantmentEffectsFromCannon(stack);
                Vector3d splitMotion = motion;
                if (spray) {
                    float imperfection = 40.0f * (Create.RANDOM.nextFloat() - 0.5f);
                    Vector3d sprayOffset = VecHelper.rotate(sprayBase, (float)i * sprayChange + imperfection, Direction.Axis.Z);
                    splitMotion = splitMotion.func_178787_e(VecHelper.lookAt(sprayOffset, motion));
                }
                if (i != 0) {
                    projectile.recoveryChance = 0.0f;
                }
                projectile.func_70107_b(barrelPos.field_72450_a, barrelPos.field_72448_b, barrelPos.field_72449_c);
                projectile.func_213317_d(splitMotion);
                projectile.func_212361_a((Entity)player);
                world.func_217376_c((Entity)projectile);
            }
            if (!player.func_184812_l_()) {
                itemStack.func_190918_g(1);
                if (itemStack.func_190926_b()) {
                    player.field_71071_by.func_184437_d(itemStack);
                }
            }
            if (!BackTankUtil.canAbsorbDamage((LivingEntity)player, this.maxUses())) {
                stack.func_222118_a(1, (LivingEntity)player, p -> p.func_213334_d(hand));
            }
            Integer cooldown = this.findAmmoInInventory(world, player, stack).flatMap(PotatoCannonProjectileTypes::getProjectileTypeOf).map(PotatoCannonProjectileTypes::getReloadTicks).orElse(10);
            ShootableGadgetItemMethods.applyCooldown(player, stack, hand, this::isCannon, cooldown);
            ShootableGadgetItemMethods.sendPackets(player, b -> new PotatoCannonPacket(barrelPos, lookVec.func_72432_b(), (ItemStack)itemStack, hand, soundPitch, (boolean)b));
            return ActionResult.func_226248_a_((Object)stack);
        }).orElse(ActionResult.func_226250_c_((Object)stack));
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || newStack.func_77973_b() != oldStack.func_77973_b();
    }

    private Optional<ItemStack> findAmmoInInventory(World world, PlayerEntity player, ItemStack held) {
        ItemStack findAmmo = player.func_213356_f(held);
        return PotatoCannonProjectileTypes.getProjectileTypeOf(findAmmo).map($ -> findAmmo);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Optional<ItemStack> getAmmoforPreview(ItemStack cannon) {
        if (AnimationTickHolder.getTicks() % 3 != 0) {
            return Optional.of(CLIENT_CURRENT_AMMO).filter(stack -> !stack.func_190926_b());
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        CLIENT_CURRENT_AMMO = ItemStack.field_190927_a;
        if (player == null) {
            return Optional.empty();
        }
        ItemStack findAmmo = player.func_213356_f(cannon);
        Optional<ItemStack> found = PotatoCannonProjectileTypes.getProjectileTypeOf(findAmmo).map($ -> findAmmo);
        found.ifPresent(stack -> {
            CLIENT_CURRENT_AMMO = stack;
        });
        return found;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        int power = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack);
        int punch = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)stack);
        float additionalDamageMult = 1.0f + (float)power * 0.2f;
        float additionalKnockback = (float)punch * 0.5f;
        PotatoCannonItem.getAmmoforPreview(stack).ifPresent(ammo -> {
            String _attack = "potato_cannon.ammo.attack_damage";
            String _reload = "potato_cannon.ammo.reload_ticks";
            String _knockback = "potato_cannon.ammo.knockback";
            tooltip.add((ITextComponent)new StringTextComponent(""));
            tooltip.add((ITextComponent)new TranslationTextComponent(ammo.func_77977_a()).func_230529_a_((ITextComponent)new StringTextComponent(":")).func_240699_a_(TextFormatting.GRAY));
            PotatoCannonProjectileTypes type = PotatoCannonProjectileTypes.getProjectileTypeOf(ammo).get();
            StringTextComponent spacing = new StringTextComponent(" ");
            TextFormatting green = TextFormatting.GREEN;
            TextFormatting darkGreen = TextFormatting.DARK_GREEN;
            float damageF = (float)type.getDamage() * additionalDamageMult;
            StringTextComponent damage = new StringTextComponent(damageF == (float)MathHelper.func_76141_d((float)damageF) ? "" + MathHelper.func_76141_d((float)damageF) : "" + damageF);
            StringTextComponent reloadTicks = new StringTextComponent("" + type.getReloadTicks());
            StringTextComponent knockback = new StringTextComponent("" + (type.getKnockback() + additionalKnockback));
            damage = damage.func_240699_a_(additionalDamageMult > 1.0f ? green : darkGreen);
            knockback = knockback.func_240699_a_(additionalKnockback > 0.0f ? green : darkGreen);
            reloadTicks = reloadTicks.func_240699_a_(darkGreen);
            tooltip.add((ITextComponent)spacing.func_230531_f_().func_230529_a_((ITextComponent)Lang.translate(_attack, damage).func_240699_a_(darkGreen)));
            tooltip.add((ITextComponent)spacing.func_230531_f_().func_230529_a_((ITextComponent)Lang.translate(_reload, reloadTicks).func_240699_a_(darkGreen)));
            tooltip.add((ITextComponent)spacing.func_230531_f_().func_230529_a_((ITextComponent)Lang.translate(_knockback, knockback).func_240699_a_(darkGreen)));
        });
        super.func_77624_a(stack, world, tooltip, flag);
    }

    public Predicate<ItemStack> func_220004_b() {
        return stack -> PotatoCannonProjectileTypes.getProjectileTypeOf(stack).isPresent();
    }

    public int func_77619_b() {
        return 1;
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return true;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.NONE;
    }

    public int func_230305_d_() {
        return 15;
    }
}

