/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.weapons;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Pair;
import com.simibubi.create.AllItems;
import com.simibubi.create.Create;
import com.simibubi.create.content.curiosities.weapons.PotatoProjectileRenderMode;
import com.simibubi.create.foundation.utility.WorldAttached;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.entity.monster.ZombieVillagerEntity;
import net.minecraft.entity.passive.FoxEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Food;
import net.minecraft.item.Foods;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.EntityTeleportEvent;
import net.minecraftforge.registries.IRegistryDelegate;

public class PotatoCannonProjectileTypes {
    private static final GameProfile ZOMBIE_CONVERTER_NAME = new GameProfile(UUID.fromString("be12d3dc-27d3-4992-8c97-66be53fd49c5"), "Converter");
    private static final WorldAttached<FakePlayer> ZOMBIE_CONVERTERS = new WorldAttached(w -> new FakePlayer((ServerWorld)w, ZOMBIE_CONVERTER_NAME));
    public static final Map<ResourceLocation, PotatoCannonProjectileTypes> ALL = new HashMap<ResourceLocation, PotatoCannonProjectileTypes>();
    public static final Map<IRegistryDelegate<Item>, PotatoCannonProjectileTypes> ITEM_MAP = new HashMap<IRegistryDelegate<Item>, PotatoCannonProjectileTypes>();
    public static final PotatoCannonProjectileTypes FALLBACK = PotatoCannonProjectileTypes.create("fallback").damage(0).register();
    public static final PotatoCannonProjectileTypes POTATO = PotatoCannonProjectileTypes.create("potato").damage(5).reloadTicks(15).velocity(1.25f).knockback(1.5f).renderTumbling().onBlockHit(PotatoCannonProjectileTypes.plantCrop((IRegistryDelegate<? extends Block>)Blocks.field_150469_bN.delegate)).registerAndAssign(new IItemProvider[]{Items.field_151174_bG});
    public static final PotatoCannonProjectileTypes BAKED_POTATO = PotatoCannonProjectileTypes.create("baked_potato").damage(5).reloadTicks(15).velocity(1.25f).knockback(0.5f).renderTumbling().preEntityHit(PotatoCannonProjectileTypes.setFire(3)).registerAndAssign(new IItemProvider[]{Items.field_151168_bH});
    public static final PotatoCannonProjectileTypes CARROT = PotatoCannonProjectileTypes.create("carrot").damage(4).reloadTicks(12).velocity(1.45f).knockback(0.3f).renderTowardMotion(140, 1.0f).soundPitch(1.5f).onBlockHit(PotatoCannonProjectileTypes.plantCrop((IRegistryDelegate<? extends Block>)Blocks.field_150459_bM.delegate)).registerAndAssign(new IItemProvider[]{Items.field_151172_bF});
    public static final PotatoCannonProjectileTypes GOLDEN_CARROT = PotatoCannonProjectileTypes.create("golden_carrot").damage(12).reloadTicks(15).velocity(1.45f).knockback(0.5f).renderTowardMotion(140, 2.0f).soundPitch(1.5f).registerAndAssign(new IItemProvider[]{Items.field_151150_bK});
    public static final PotatoCannonProjectileTypes SWEET_BERRIES = PotatoCannonProjectileTypes.create("sweet_berry").damage(3).reloadTicks(10).knockback(0.1f).velocity(1.05f).renderTumbling().splitInto(3).soundPitch(1.25f).registerAndAssign(new IItemProvider[]{Items.field_222112_pR});
    public static final PotatoCannonProjectileTypes CHOCOLATE_BERRIES = PotatoCannonProjectileTypes.create("chocolate_berry").damage(4).reloadTicks(10).knockback(0.2f).velocity(1.05f).renderTumbling().splitInto(3).soundPitch(1.25f).registerAndAssign((IItemProvider)AllItems.CHOCOLATE_BERRIES.get());
    public static final PotatoCannonProjectileTypes POISON_POTATO = PotatoCannonProjectileTypes.create("poison_potato").damage(5).reloadTicks(15).knockback(0.05f).velocity(1.25f).renderTumbling().onEntityHit(PotatoCannonProjectileTypes.potion(Effects.field_76436_u, 1, 160, true)).registerAndAssign(new IItemProvider[]{Items.field_151170_bI});
    public static final PotatoCannonProjectileTypes CHORUS_FRUIT = PotatoCannonProjectileTypes.create("chorus_fruit").damage(3).reloadTicks(15).velocity(1.2f).knockback(0.05f).renderTumbling().onEntityHit(PotatoCannonProjectileTypes.chorusTeleport(20.0)).registerAndAssign(new IItemProvider[]{Items.field_185161_cS});
    public static final PotatoCannonProjectileTypes APPLE = PotatoCannonProjectileTypes.create("apple").damage(5).reloadTicks(10).velocity(1.45f).knockback(0.5f).renderTumbling().soundPitch(1.1f).registerAndAssign(new IItemProvider[]{Items.field_151034_e});
    public static final PotatoCannonProjectileTypes HONEYED_APPLE = PotatoCannonProjectileTypes.create("honeyed_apple").damage(6).reloadTicks(15).velocity(1.35f).knockback(0.1f).renderTumbling().soundPitch(1.1f).onEntityHit(PotatoCannonProjectileTypes.potion(Effects.field_76421_d, 2, 160, true)).registerAndAssign((IItemProvider)AllItems.HONEYED_APPLE.get());
    public static final PotatoCannonProjectileTypes GOLDEN_APPLE = PotatoCannonProjectileTypes.create("golden_apple").damage(1).reloadTicks(100).velocity(1.45f).knockback(0.05f).renderTumbling().soundPitch(1.1f).onEntityHit((EntityRayTraceResult ray) -> {
        Entity entity = ray.func_216348_a();
        World world = entity.field_70170_p;
        if (!(entity instanceof ZombieVillagerEntity) || !((ZombieVillagerEntity)entity).func_70644_a(Effects.field_76437_t)) {
            return PotatoCannonProjectileTypes.foodEffects(Foods.field_221445_u, false).test((EntityRayTraceResult)ray);
        }
        if (world.field_72995_K) {
            return false;
        }
        FakePlayer dummy = ZOMBIE_CONVERTERS.get((IWorld)world);
        dummy.func_184611_a(Hand.MAIN_HAND, new ItemStack((IItemProvider)Items.field_151153_ao, 1));
        ((ZombieVillagerEntity)entity).func_230254_b_((PlayerEntity)dummy, Hand.MAIN_HAND);
        return true;
    }).registerAndAssign(new IItemProvider[]{Items.field_151153_ao});
    public static final PotatoCannonProjectileTypes ENCHANTED_GOLDEN_APPLE = PotatoCannonProjectileTypes.create("enchanted_golden_apple").damage(1).reloadTicks(100).velocity(1.45f).knockback(0.05f).renderTumbling().soundPitch(1.1f).onEntityHit(PotatoCannonProjectileTypes.foodEffects(Foods.field_221444_t, false)).registerAndAssign(new IItemProvider[]{Items.field_196100_at});
    public static final PotatoCannonProjectileTypes BEETROOT = PotatoCannonProjectileTypes.create("beetroot").damage(2).reloadTicks(5).velocity(1.6f).knockback(0.1f).renderTowardMotion(140, 2.0f).soundPitch(1.6f).registerAndAssign(new IItemProvider[]{Items.field_185164_cV});
    public static final PotatoCannonProjectileTypes MELON_SLICE = PotatoCannonProjectileTypes.create("melon_slice").damage(3).reloadTicks(8).knockback(0.1f).velocity(1.45f).renderTumbling().soundPitch(1.5f).registerAndAssign(new IItemProvider[]{Items.field_151127_ba});
    public static final PotatoCannonProjectileTypes GLISTENING_MELON = PotatoCannonProjectileTypes.create("glistening_melon").damage(5).reloadTicks(8).knockback(0.1f).velocity(1.45f).renderTumbling().soundPitch(1.5f).onEntityHit(PotatoCannonProjectileTypes.potion(Effects.field_188423_x, 1, 100, true)).registerAndAssign(new IItemProvider[]{Items.field_151060_bw});
    public static final PotatoCannonProjectileTypes MELON_BLOCK = PotatoCannonProjectileTypes.create("melon_block").damage(8).reloadTicks(20).knockback(2.0f).velocity(0.95f).renderTumbling().soundPitch(0.9f).onBlockHit(PotatoCannonProjectileTypes.placeBlockOnGround((IRegistryDelegate<? extends Block>)Blocks.field_150440_ba.delegate)).registerAndAssign(new IItemProvider[]{Blocks.field_150440_ba});
    public static final PotatoCannonProjectileTypes PUMPKIN_BLOCK = PotatoCannonProjectileTypes.create("pumpkin_block").damage(6).reloadTicks(15).knockback(2.0f).velocity(0.95f).renderTumbling().soundPitch(0.9f).onBlockHit(PotatoCannonProjectileTypes.placeBlockOnGround((IRegistryDelegate<? extends Block>)Blocks.field_150423_aK.delegate)).registerAndAssign(new IItemProvider[]{Blocks.field_150423_aK});
    public static final PotatoCannonProjectileTypes PUMPKIN_PIE = PotatoCannonProjectileTypes.create("pumpkin_pie").damage(7).reloadTicks(15).knockback(0.05f).velocity(1.1f).renderTumbling().sticky().soundPitch(1.1f).registerAndAssign(new IItemProvider[]{Items.field_151158_bO});
    public static final PotatoCannonProjectileTypes CAKE = PotatoCannonProjectileTypes.create("cake").damage(8).reloadTicks(15).knockback(0.1f).velocity(1.1f).renderTumbling().sticky().soundPitch(1.0f).registerAndAssign(new IItemProvider[]{Items.field_222070_lD});
    public static final PotatoCannonProjectileTypes BLAZE_CAKE = PotatoCannonProjectileTypes.create("blaze_cake").damage(15).reloadTicks(20).knockback(0.3f).velocity(1.1f).renderTumbling().sticky().preEntityHit(PotatoCannonProjectileTypes.setFire(12)).soundPitch(1.0f).registerAndAssign((IItemProvider)AllItems.BLAZE_CAKE.get());
    private float gravityMultiplier = 1.0f;
    private float velocityMultiplier = 1.0f;
    private float drag = 0.99f;
    private float knockback = 1.0f;
    private int reloadTicks = 10;
    private int damage = 1;
    private int split = 1;
    private float fwoompPitch = 1.0f;
    private boolean sticky = false;
    private PotatoProjectileRenderMode renderMode = new PotatoProjectileRenderMode.Billboard();
    private Predicate<EntityRayTraceResult> preEntityHit = e -> false;
    private Predicate<EntityRayTraceResult> onEntityHit = e -> false;
    private BiPredicate<IWorld, BlockRayTraceResult> onBlockHit = (w, ray) -> false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerType(ResourceLocation resLoc, PotatoCannonProjectileTypes type) {
        Map<ResourceLocation, PotatoCannonProjectileTypes> map = ALL;
        synchronized (map) {
            ALL.put(resLoc, type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assignType(IRegistryDelegate<Item> item, PotatoCannonProjectileTypes type) {
        Map<IRegistryDelegate<Item>, PotatoCannonProjectileTypes> map = ITEM_MAP;
        synchronized (map) {
            ITEM_MAP.put(item, type);
        }
    }

    public static Optional<PotatoCannonProjectileTypes> getProjectileTypeOf(ItemStack item) {
        if (item.func_190926_b()) {
            return Optional.empty();
        }
        return Optional.ofNullable(ITEM_MAP.get(item.func_77973_b().delegate));
    }

    public static void register() {
    }

    private static Builder create(String name) {
        return new Builder(Create.asResource(name));
    }

    public float getGravityMultiplier() {
        return this.gravityMultiplier;
    }

    public float getDrag() {
        return this.drag;
    }

    public int getSplit() {
        return this.split;
    }

    public float getVelocityMultiplier() {
        return this.velocityMultiplier;
    }

    public float getKnockback() {
        return this.knockback;
    }

    public int getReloadTicks() {
        return this.reloadTicks;
    }

    public float getSoundPitch() {
        return this.fwoompPitch;
    }

    public PotatoProjectileRenderMode getRenderMode() {
        return this.renderMode;
    }

    public int getDamage() {
        return this.damage;
    }

    public boolean isSticky() {
        return this.sticky;
    }

    public boolean preEntityHit(EntityRayTraceResult ray) {
        return this.preEntityHit.test(ray);
    }

    public boolean onEntityHit(EntityRayTraceResult ray) {
        return this.onEntityHit.test(ray);
    }

    public boolean onBlockHit(IWorld world, BlockRayTraceResult ray) {
        return this.onBlockHit.test(world, ray);
    }

    private static Predicate<EntityRayTraceResult> setFire(int seconds) {
        return ray -> {
            ray.func_216348_a().func_70015_d(seconds);
            return false;
        };
    }

    private static Predicate<EntityRayTraceResult> potion(Effect effect, int level, int ticks, boolean recoverable) {
        return ray -> {
            Entity entity = ray.func_216348_a();
            if (entity.field_70170_p.field_72995_K) {
                return true;
            }
            if (entity instanceof LivingEntity) {
                PotatoCannonProjectileTypes.applyEffect((LivingEntity)entity, new EffectInstance(effect, ticks, level - 1));
            }
            return !recoverable;
        };
    }

    private static Predicate<EntityRayTraceResult> foodEffects(Food food, boolean recoverable) {
        return ray -> {
            Entity entity = ray.func_216348_a();
            if (entity.field_70170_p.field_72995_K) {
                return true;
            }
            if (entity instanceof LivingEntity) {
                for (Pair effect : food.func_221464_f()) {
                    if (!(Create.RANDOM.nextFloat() < ((Float)effect.getSecond()).floatValue())) continue;
                    PotatoCannonProjectileTypes.applyEffect((LivingEntity)entity, new EffectInstance((EffectInstance)effect.getFirst()));
                }
            }
            return !recoverable;
        };
    }

    public static void applyEffect(LivingEntity entity, EffectInstance effect) {
        if (effect.func_188419_a().func_76403_b()) {
            effect.func_188419_a().func_180793_a(null, null, entity, effect.func_76459_b(), 1.0);
        } else {
            entity.func_195064_c(effect);
        }
    }

    private static BiPredicate<IWorld, BlockRayTraceResult> plantCrop(IRegistryDelegate<? extends Block> cropBlock) {
        return (world, ray) -> {
            if (world.func_201670_d()) {
                return true;
            }
            BlockPos hitPos = ray.func_216350_a();
            if (!world.isAreaLoaded(hitPos, 1)) {
                return true;
            }
            Direction face = ray.func_216354_b();
            BlockPos placePos = hitPos.func_177972_a(face);
            if (!world.func_180495_p(placePos).func_185904_a().func_76222_j()) {
                return false;
            }
            if (!(cropBlock.get() instanceof IPlantable)) {
                return false;
            }
            BlockState blockState = world.func_180495_p(hitPos);
            if (!blockState.canSustainPlant((IBlockReader)world, hitPos, face, (IPlantable)cropBlock.get())) {
                return false;
            }
            world.func_180501_a(placePos, ((Block)cropBlock.get()).func_176223_P(), 3);
            return true;
        };
    }

    private static BiPredicate<IWorld, BlockRayTraceResult> placeBlockOnGround(IRegistryDelegate<? extends Block> block) {
        return (world, ray) -> {
            if (world.func_201670_d()) {
                return true;
            }
            BlockPos hitPos = ray.func_216350_a();
            if (!world.isAreaLoaded(hitPos, 1)) {
                return true;
            }
            Direction face = ray.func_216354_b();
            BlockPos placePos = hitPos.func_177972_a(face);
            if (!world.func_180495_p(placePos).func_185904_a().func_76222_j()) {
                return false;
            }
            if (face == Direction.UP) {
                world.func_180501_a(placePos, ((Block)block.get()).func_176223_P(), 3);
            } else if (world instanceof World) {
                double y = ray.func_216347_e().field_72448_b - 0.5;
                if (!world.func_175623_d(placePos.func_177984_a())) {
                    y = Math.min(y, (double)placePos.func_177956_o());
                }
                if (!world.func_175623_d(placePos.func_177977_b())) {
                    y = Math.max(y, (double)placePos.func_177956_o());
                }
                FallingBlockEntity falling = new FallingBlockEntity((World)world, (double)placePos.func_177958_n() + 0.5, y, (double)placePos.func_177952_p() + 0.5, ((Block)block.get()).func_176223_P());
                falling.field_145812_b = 1;
                world.func_217376_c((Entity)falling);
            }
            return true;
        };
    }

    private static Predicate<EntityRayTraceResult> chorusTeleport(double teleportDiameter) {
        return ray -> {
            Entity entity = ray.func_216348_a();
            World world = entity.func_130014_f_();
            if (world.field_72995_K) {
                return true;
            }
            if (!(entity instanceof LivingEntity)) {
                return false;
            }
            LivingEntity livingEntity = (LivingEntity)entity;
            double entityX = livingEntity.func_226277_ct_();
            double entityY = livingEntity.func_226278_cu_();
            double entityZ = livingEntity.func_226281_cx_();
            for (int teleportTry = 0; teleportTry < 16; ++teleportTry) {
                double teleportZ;
                double teleportY;
                double teleportX = entityX + (livingEntity.func_70681_au().nextDouble() - 0.5) * teleportDiameter;
                EntityTeleportEvent.ChorusFruit event = ForgeEventFactory.onChorusFruitTeleport((LivingEntity)livingEntity, (double)teleportX, (double)(teleportY = MathHelper.func_151237_a((double)(entityY + (double)(livingEntity.func_70681_au().nextInt((int)teleportDiameter) - (int)(teleportDiameter / 2.0))), (double)0.0, (double)(world.func_234938_ad_() - 1))), (double)(teleportZ = entityZ + (livingEntity.func_70681_au().nextDouble() - 0.5) * teleportDiameter));
                if (event.isCanceled()) {
                    return false;
                }
                if (!livingEntity.func_213373_a(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true)) continue;
                if (livingEntity.func_184218_aH()) {
                    livingEntity.func_184210_p();
                }
                SoundEvent soundevent = livingEntity instanceof FoxEntity ? SoundEvents.field_232710_ez_ : SoundEvents.field_187544_ad;
                world.func_184148_a(null, entityX, entityY, entityZ, soundevent, SoundCategory.PLAYERS, 1.0f, 1.0f);
                livingEntity.func_184185_a(soundevent, 1.0f, 1.0f);
                livingEntity.func_213317_d(Vector3d.field_186680_a);
                return true;
            }
            return false;
        };
    }

    public static class Builder {
        protected ResourceLocation loc;
        protected PotatoCannonProjectileTypes result = new PotatoCannonProjectileTypes();

        public Builder(ResourceLocation loc) {
            this.loc = loc;
        }

        public Builder damage(int damage) {
            this.result.damage = damage;
            return this;
        }

        public Builder gravity(float modifier) {
            this.result.gravityMultiplier = modifier;
            return this;
        }

        public Builder knockback(float knockback) {
            this.result.knockback = knockback;
            return this;
        }

        public Builder drag(float drag) {
            this.result.drag = drag;
            return this;
        }

        public Builder reloadTicks(int reload) {
            this.result.reloadTicks = reload;
            return this;
        }

        public Builder splitInto(int split) {
            this.result.split = split;
            return this;
        }

        public Builder soundPitch(float pitch) {
            this.result.fwoompPitch = pitch;
            return this;
        }

        public Builder velocity(float velocity) {
            this.result.velocityMultiplier = velocity;
            return this;
        }

        public Builder renderTumbling() {
            this.result.renderMode = new PotatoProjectileRenderMode.Tumble();
            return this;
        }

        public Builder renderBillboard() {
            this.result.renderMode = new PotatoProjectileRenderMode.Billboard();
            return this;
        }

        public Builder renderTowardMotion(int spriteAngle, float spin) {
            this.result.renderMode = new PotatoProjectileRenderMode.TowardMotion(spriteAngle, spin);
            return this;
        }

        public Builder sticky() {
            this.result.sticky = true;
            return this;
        }

        public Builder preEntityHit(Predicate<EntityRayTraceResult> callback) {
            this.result.preEntityHit = callback;
            return this;
        }

        public Builder onEntityHit(Predicate<EntityRayTraceResult> callback) {
            this.result.onEntityHit = callback;
            return this;
        }

        public Builder onBlockHit(BiPredicate<IWorld, BlockRayTraceResult> callback) {
            this.result.onBlockHit = callback;
            return this;
        }

        public PotatoCannonProjectileTypes register() {
            PotatoCannonProjectileTypes.registerType(this.loc, this.result);
            return this.result;
        }

        public PotatoCannonProjectileTypes registerAndAssign(IItemProvider ... items) {
            PotatoCannonProjectileTypes.registerType(this.loc, this.result);
            for (IItemProvider provider : items) {
                PotatoCannonProjectileTypes.assignType((IRegistryDelegate<Item>)provider.func_199767_j().delegate, this.result);
            }
            return this.result;
        }
    }
}

