/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.chute;

import com.simibubi.create.content.logistics.block.chute.AbstractChuteBlock;
import com.simibubi.create.content.logistics.block.chute.ChuteTileEntity;
import com.simibubi.create.content.logistics.block.chute.SmartChuteBlock;
import com.simibubi.create.content.logistics.block.chute.SmartChuteFilterSlotPositioning;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringBehaviour;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;

public class SmartChuteTileEntity
extends ChuteTileEntity {
    FilteringBehaviour filtering;

    public SmartChuteTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    @Override
    protected boolean canAcceptItem(ItemStack stack) {
        return super.canAcceptItem(stack) && this.canCollectItemsFromBelow() && this.filtering.test(stack);
    }

    @Override
    protected int getExtractionAmount() {
        return this.filtering.isCountVisible() && !this.filtering.anyAmount() ? this.filtering.getAmount() : 64;
    }

    @Override
    protected ItemHelper.ExtractionCountMode getExtractionMode() {
        return this.filtering.isCountVisible() && !this.filtering.anyAmount() ? ItemHelper.ExtractionCountMode.EXACTLY : ItemHelper.ExtractionCountMode.UPTO;
    }

    @Override
    protected boolean canCollectItemsFromBelow() {
        BlockState blockState = this.func_195044_w();
        return blockState.func_235901_b_((Property)SmartChuteBlock.POWERED) && (Boolean)blockState.func_177229_b((Property)SmartChuteBlock.POWERED) == false;
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        this.filtering = new FilteringBehaviour(this, new SmartChuteFilterSlotPositioning()).showCountWhen(this::isExtracting);
        behaviours.add(this.filtering);
        super.addBehaviours(behaviours);
    }

    private boolean isExtracting() {
        boolean up = this.getItemMotion() < 0.0f;
        BlockPos chutePos = this.field_174879_c.func_177972_a(up ? Direction.UP : Direction.DOWN);
        BlockState blockState = this.field_145850_b.func_180495_p(chutePos);
        return !AbstractChuteBlock.isChute(blockState) && !blockState.func_185904_a().func_76222_j();
    }
}

