/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.depot;

import com.jozufozu.flywheel.util.transform.MatrixTransformStack;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.content.contraptions.relays.belt.BeltHelper;
import com.simibubi.create.content.contraptions.relays.belt.transport.TransportedItemStack;
import com.simibubi.create.content.logistics.block.depot.DepotBehaviour;
import com.simibubi.create.content.logistics.block.depot.DepotTileEntity;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.renderer.SafeTileEntityRenderer;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;

public class DepotRenderer
extends SafeTileEntityRenderer<DepotTileEntity> {
    public DepotRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    @Override
    protected void renderSafe(DepotTileEntity te, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay) {
        DepotRenderer.renderItemsOf(te, partialTicks, ms, buffer, light, overlay, te.depotBehaviour);
    }

    public static void renderItemsOf(SmartTileEntity te, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay, DepotBehaviour depotBehaviour) {
        TransportedItemStack transported = depotBehaviour.heldItem;
        MatrixTransformStack msr = MatrixTransformStack.of((MatrixStack)ms);
        Vector3d itemPosition = VecHelper.getCenterOf((Vector3i)te.func_174877_v());
        ms.func_227860_a_();
        ms.func_227861_a_(0.5, 0.9375, 0.5);
        if (transported != null) {
            depotBehaviour.incoming.add(transported);
        }
        for (TransportedItemStack tis : depotBehaviour.incoming) {
            ms.func_227860_a_();
            msr.nudge(0);
            float offset = MathHelper.func_219799_g((float)partialTicks, (float)tis.prevBeltPosition, (float)tis.beltPosition);
            float sideOffset = MathHelper.func_219799_g((float)partialTicks, (float)tis.prevSideOffset, (float)tis.sideOffset);
            if (tis.insertedFrom.func_176740_k().func_176722_c()) {
                boolean alongX;
                Vector3d offsetVec = Vector3d.func_237491_b_((Vector3i)tis.insertedFrom.func_176734_d().func_176730_m()).func_186678_a((double)(0.5f - offset));
                ms.func_227861_a_(offsetVec.field_72450_a, offsetVec.field_72448_b, offsetVec.field_72449_c);
                boolean bl = alongX = tis.insertedFrom.func_176746_e().func_176740_k() == Direction.Axis.X;
                if (!alongX) {
                    sideOffset *= -1.0f;
                }
                ms.func_227861_a_(alongX ? (double)sideOffset : 0.0, 0.0, alongX ? 0.0 : (double)sideOffset);
            }
            ItemStack itemStack = tis.stack;
            int angle = tis.angle;
            Random r = new Random(0L);
            DepotRenderer.renderItem(ms, buffer, light, overlay, itemStack, angle, r, itemPosition);
            ms.func_227865_b_();
        }
        if (transported != null) {
            depotBehaviour.incoming.remove(transported);
        }
        for (int i = 0; i < depotBehaviour.processingOutputBuffer.getSlots(); ++i) {
            ItemStack stack = depotBehaviour.processingOutputBuffer.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            ms.func_227860_a_();
            msr.nudge(i);
            boolean renderUpright = BeltHelper.isItemUpright(stack);
            msr.rotateY((double)(45.0f * (float)i));
            ms.func_227861_a_((double)0.35f, 0.0, 0.0);
            if (renderUpright) {
                msr.rotateY((double)(-(45.0f * (float)i)));
            }
            Random r = new Random(i + 1);
            int angle = (int)(360.0f * r.nextFloat());
            DepotRenderer.renderItem(ms, buffer, light, overlay, stack, renderUpright ? angle + 90 : angle, r, itemPosition);
            ms.func_227865_b_();
        }
        ms.func_227865_b_();
    }

    public static void renderItem(MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay, ItemStack itemStack, int angle, Random r, Vector3d itemPosition) {
        ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
        MatrixTransformStack msr = MatrixTransformStack.of((MatrixStack)ms);
        int count = MathHelper.func_151239_c((int)itemStack.func_190916_E()) / 2;
        boolean renderUpright = BeltHelper.isItemUpright(itemStack);
        boolean blockItem = itemRenderer.func_184393_a(itemStack, null, null).func_177556_c();
        ms.func_227860_a_();
        msr.rotateY((double)angle);
        if (renderUpright) {
            Entity renderViewEntity = Minecraft.func_71410_x().field_175622_Z;
            if (renderViewEntity != null) {
                Vector3d positionVec = renderViewEntity.func_213303_ch();
                Vector3d vectorForOffset = itemPosition;
                Vector3d diff = vectorForOffset.func_178788_d(positionVec);
                float yRot = (float)(-MathHelper.func_181159_b((double)diff.field_72449_c, (double)diff.field_72450_a));
                ms.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_((float)((double)yRot - 1.5707963267948966)));
            }
            ms.func_227861_a_(0.0, 0.09375, -0.0625);
        }
        for (int i = 0; i <= count; ++i) {
            ms.func_227860_a_();
            if (blockItem) {
                ms.func_227861_a_((double)(r.nextFloat() * 0.0625f * (float)i), 0.0, (double)(r.nextFloat() * 0.0625f * (float)i));
            }
            ms.func_227862_a_(0.5f, 0.5f, 0.5f);
            if (!blockItem && !renderUpright) {
                ms.func_227861_a_(0.0, -0.1875, 0.0);
                msr.rotateX(90.0);
            }
            itemRenderer.func_229110_a_(itemStack, ItemCameraTransforms.TransformType.FIXED, light, overlay, ms, buffer);
            ms.func_227865_b_();
            if (!renderUpright) {
                if (!blockItem) {
                    msr.rotateY(10.0);
                }
                ms.func_227861_a_(0.0, blockItem ? 0.015625 : 0.0625, 0.0);
                continue;
            }
            ms.func_227861_a_(0.0, 0.0, -0.0625);
        }
        ms.func_227865_b_();
    }
}

