/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.redstone;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.utility.Couple;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ICommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.world.server.ServerWorld;

public class NixieTubeTileEntity
extends SmartTileEntity {
    private static final Couple<String> EMPTY = Couple.create("", "");
    private boolean hasCustomText = false;
    private int redstoneStrength = 0;
    private JsonElement rawCustomText;
    private int customTextIndex;
    private ITextComponent parsedCustomText;
    private Couple<String> displayedStrings;

    public NixieTubeTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b instanceof ServerWorld && this.hasCustomText) {
            Couple<String> currentStrings = this.displayedStrings;
            this.parsedCustomText = this.parseCustomText();
            this.updateDisplayedStrings();
            if (currentStrings == null || !currentStrings.equals(this.displayedStrings)) {
                this.sendData();
            }
        }
    }

    @Override
    public void initialize() {
        if (this.field_145850_b.field_72995_K) {
            this.updateDisplayedStrings();
        }
    }

    public boolean reactsToRedstone() {
        return !this.hasCustomText;
    }

    public Couple<String> getDisplayedStrings() {
        if (this.displayedStrings == null) {
            return EMPTY;
        }
        return this.displayedStrings;
    }

    public void updateRedstoneStrength(int signalStrength) {
        this.clearCustomText();
        this.redstoneStrength = signalStrength;
        this.notifyUpdate();
    }

    public void displayCustomNameOf(ItemStack stack, int nixiePositionInRow) {
        CompoundNBT compoundnbt = stack.func_179543_a("display");
        if (compoundnbt != null && compoundnbt.func_150297_b("Name", 8)) {
            this.hasCustomText = true;
            this.rawCustomText = this.getJsonFromString(compoundnbt.func_74779_i("Name"));
            this.customTextIndex = nixiePositionInRow;
            this.parsedCustomText = this.parseCustomText();
            this.notifyUpdate();
        }
    }

    public void updateDisplayedStrings() {
        if (!this.hasCustomText) {
            this.displayedStrings = Couple.create(this.redstoneStrength < 10 ? "0" : "1", String.valueOf(this.redstoneStrength % 10));
        } else {
            String fullText = this.parsedCustomText.getString();
            int index = this.customTextIndex * 2;
            this.displayedStrings = Couple.create(this.charOrEmpty(fullText, index), this.charOrEmpty(fullText, index + 1));
        }
    }

    public void clearCustomText() {
        this.hasCustomText = false;
        this.rawCustomText = null;
        this.customTextIndex = 0;
        this.parsedCustomText = null;
    }

    @Override
    protected void fromTag(BlockState state, CompoundNBT nbt, boolean clientPacket) {
        super.fromTag(state, nbt, clientPacket);
        if (nbt.func_150297_b("RawCustomText", 8)) {
            ITextComponent deserializedComponent;
            this.rawCustomText = this.getJsonFromString(nbt.func_74779_i("RawCustomText"));
            if (this.rawCustomText != null && !this.rawCustomText.isJsonNull() && (deserializedComponent = this.parseCustomText()) != null) {
                try {
                    this.parsedCustomText = ITextComponent.Serializer.func_240643_a_((String)nbt.func_74779_i("CustomText"));
                }
                catch (JsonParseException jsonParseException) {
                    // empty catch block
                }
                if (this.parsedCustomText == null) {
                    this.parsedCustomText = deserializedComponent;
                }
                this.hasCustomText = true;
                this.customTextIndex = nbt.func_74762_e("CustomTextIndex");
            }
        }
        if (!this.hasCustomText) {
            this.clearCustomText();
            this.redstoneStrength = nbt.func_74762_e("RedstoneStrength");
        }
        if (clientPacket) {
            this.updateDisplayedStrings();
        }
    }

    @Override
    protected void write(CompoundNBT nbt, boolean clientPacket) {
        super.write(nbt, clientPacket);
        if (this.hasCustomText) {
            nbt.func_74778_a("RawCustomText", this.rawCustomText.toString());
            nbt.func_74768_a("CustomTextIndex", this.customTextIndex);
            nbt.func_74778_a("CustomText", ITextComponent.Serializer.func_150696_a((ITextComponent)this.parsedCustomText));
        } else {
            nbt.func_74768_a("RedstoneStrength", this.redstoneStrength);
        }
    }

    private JsonElement getJsonFromString(String string) {
        try {
            return new JsonParser().parse(string);
        }
        catch (JsonParseException e) {
            return null;
        }
    }

    private String charOrEmpty(String string, int index) {
        return string.length() <= index ? " " : string.substring(index, index + 1);
    }

    protected ITextComponent parseCustomText() {
        try {
            return this.parseDynamicComponent((ITextComponent)ITextComponent.Serializer.func_240641_a_((JsonElement)this.rawCustomText));
        }
        catch (JsonParseException e) {
            return null;
        }
    }

    protected ITextComponent parseDynamicComponent(ITextComponent customText) {
        if (this.field_145850_b instanceof ServerWorld) {
            try {
                return TextComponentUtils.func_240645_a_((CommandSource)this.getCommandSource(null), (ITextComponent)customText, null, (int)0);
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }
        return customText;
    }

    public CommandSource getCommandSource(@Nullable ServerPlayerEntity p_195539_1_) {
        String s = p_195539_1_ == null ? "Nixie Tube" : p_195539_1_.func_200200_C_().getString();
        StringTextComponent itextcomponent = p_195539_1_ == null ? new StringTextComponent("Nixie Tube") : p_195539_1_.func_145748_c_();
        return new CommandSource(ICommandSource.field_213139_a_, Vector3d.func_237489_a_((Vector3i)this.field_174879_c), Vector2f.field_189974_a, (ServerWorld)this.field_145850_b, 2, s, (ITextComponent)itextcomponent, this.field_145850_b.func_73046_m(), (Entity)p_195539_1_);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
    }
}

