/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.events;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.AllFluids;
import com.simibubi.create.AllItems;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.contraptions.KineticDebugger;
import com.simibubi.create.content.contraptions.base.IRotate;
import com.simibubi.create.content.contraptions.components.fan.AirCurrent;
import com.simibubi.create.content.contraptions.components.flywheel.engine.EngineBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.ContraptionHandler;
import com.simibubi.create.content.contraptions.components.structureMovement.chassis.ChassisRangeDisplay;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionRenderDispatcher;
import com.simibubi.create.content.contraptions.components.structureMovement.train.CouplingHandlerClient;
import com.simibubi.create.content.contraptions.components.structureMovement.train.CouplingPhysics;
import com.simibubi.create.content.contraptions.components.structureMovement.train.CouplingRenderer;
import com.simibubi.create.content.contraptions.components.structureMovement.train.capability.CapabilityMinecartController;
import com.simibubi.create.content.contraptions.components.turntable.TurntableHandler;
import com.simibubi.create.content.contraptions.goggles.GoggleOverlayRenderer;
import com.simibubi.create.content.contraptions.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.contraptions.itemAssembly.SequencedAssemblyRecipe;
import com.simibubi.create.content.contraptions.relays.belt.item.BeltConnectorHandler;
import com.simibubi.create.content.curiosities.armor.CopperArmorItem;
import com.simibubi.create.content.curiosities.armor.CopperBacktankArmorLayer;
import com.simibubi.create.content.curiosities.tools.BlueprintOverlayRenderer;
import com.simibubi.create.content.curiosities.tools.ExtendoGripRenderHandler;
import com.simibubi.create.content.curiosities.zapper.ZapperItem;
import com.simibubi.create.content.curiosities.zapper.terrainzapper.WorldshaperRenderHandler;
import com.simibubi.create.content.logistics.block.depot.EjectorTargetHandler;
import com.simibubi.create.content.logistics.block.mechanicalArm.ArmInteractionPointHandler;
import com.simibubi.create.content.logistics.item.LinkedControllerClientHandler;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.config.ui.BaseConfigScreen;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.networking.LeftClickPacket;
import com.simibubi.create.foundation.ponder.PonderTooltipHandler;
import com.simibubi.create.foundation.renderState.SuperRenderTypeBuffer;
import com.simibubi.create.foundation.sound.SoundScapes;
import com.simibubi.create.foundation.tileEntity.behaviour.edgeInteraction.EdgeInteractionRenderer;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringRenderer;
import com.simibubi.create.foundation.tileEntity.behaviour.linked.LinkRenderer;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.ScrollValueHandler;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.ScrollValueRenderer;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.ServerSpeedProvider;
import com.simibubi.create.foundation.utility.placement.PlacementHelpers;
import com.simibubi.create.foundation.utility.worldWrappers.WrappedClientWorld;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ClientEvents {
    private static final String itemPrefix = "item.create";
    private static final String blockPrefix = "block.create";

    @SubscribeEvent
    public static void onTick(TickEvent.ClientTickEvent event) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (!ClientEvents.isGameActive()) {
            return;
        }
        if (event.phase == TickEvent.Phase.START) {
            LinkedControllerClientHandler.tick();
            AirCurrent.tickClientPlayerSounds();
            return;
        }
        SoundScapes.tick();
        AnimationTickHolder.tick();
        ScrollValueHandler.tick();
        CreateClient.SCHEMATIC_SENDER.tick();
        CreateClient.SCHEMATIC_AND_QUILL_HANDLER.tick();
        CreateClient.SCHEMATIC_HANDLER.tick();
        CreateClient.ZAPPER_RENDER_HANDLER.tick();
        CreateClient.POTATO_CANNON_RENDER_HANDLER.tick();
        CreateClient.SOUL_PULSE_EFFECT_HANDLER.tick((World)world);
        ContraptionHandler.tick((World)world);
        CapabilityMinecartController.tick((World)world);
        CouplingPhysics.tick((World)world);
        PonderTooltipHandler.tick();
        ServerSpeedProvider.clientTick();
        BeltConnectorHandler.tick();
        FilteringRenderer.tick();
        LinkRenderer.tick();
        ScrollValueRenderer.tick();
        ChassisRangeDisplay.tick();
        EdgeInteractionRenderer.tick();
        WorldshaperRenderHandler.tick();
        CouplingHandlerClient.tick();
        CouplingRenderer.tickDebugModeRenders();
        KineticDebugger.tick();
        ExtendoGripRenderHandler.tick();
        ArmInteractionPointHandler.tick();
        EjectorTargetHandler.tick();
        PlacementHelpers.tick();
        CreateClient.OUTLINER.tickOutlines();
        CreateClient.GHOST_BLOCKS.tickGhosts();
        ContraptionRenderDispatcher.tick((World)world);
        BlueprintOverlayRenderer.tick();
    }

    @SubscribeEvent
    public static void onJoin(ClientPlayerNetworkEvent.LoggedInEvent event) {
        CreateClient.checkGraphicsFanciness();
    }

    @SubscribeEvent
    public static void onLoadWorld(WorldEvent.Load event) {
        IWorld world = event.getWorld();
        if (world.func_201670_d() && world instanceof ClientWorld && !(world instanceof WrappedClientWorld)) {
            CreateClient.invalidateRenderers();
            AnimationTickHolder.reset();
        }
        IHaveGoggleInformation.numberFormat.update();
    }

    @SubscribeEvent
    public static void onUnloadWorld(WorldEvent.Unload event) {
        if (event.getWorld().func_201670_d()) {
            CreateClient.invalidateRenderers();
            CreateClient.SOUL_PULSE_EFFECT_HANDLER.refresh();
            AnimationTickHolder.reset();
        }
    }

    @SubscribeEvent
    public static void onRenderWorld(RenderWorldLastEvent event) {
        Vector3d cameraPos = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c();
        float pt = AnimationTickHolder.getPartialTicks();
        MatrixStack ms = event.getMatrixStack();
        ms.func_227860_a_();
        ms.func_227861_a_(-cameraPos.func_82615_a(), -cameraPos.func_82617_b(), -cameraPos.func_82616_c());
        SuperRenderTypeBuffer buffer = SuperRenderTypeBuffer.getInstance();
        CouplingRenderer.renderAll(ms, buffer);
        CreateClient.SCHEMATIC_HANDLER.render(ms, buffer);
        CreateClient.GHOST_BLOCKS.renderAll(ms, buffer);
        CreateClient.OUTLINER.renderOutlines(ms, buffer, pt);
        buffer.draw();
        RenderSystem.enableCull();
        ms.func_227865_b_();
    }

    @SubscribeEvent
    public static void onRenderOverlay(RenderGameOverlayEvent.Post event) {
        MatrixStack ms = event.getMatrixStack();
        IRenderTypeBuffer.Impl buffers = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        int light = 0xF000F0;
        int overlay = OverlayTexture.field_229196_a_;
        float pt = event.getPartialTicks();
        if (event.getType() == RenderGameOverlayEvent.ElementType.AIR) {
            CopperBacktankArmorLayer.renderRemainingAirOverlay(ms, buffers, light, overlay, pt);
        }
        if (event.getType() != RenderGameOverlayEvent.ElementType.HOTBAR) {
            return;
        }
        ClientEvents.onRenderHotbar(ms, (IRenderTypeBuffer)buffers, light, overlay, pt);
    }

    public static void onRenderHotbar(MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay, float partialTicks) {
        CreateClient.SCHEMATIC_HANDLER.renderOverlay(ms, buffer, light, overlay, partialTicks);
        LinkedControllerClientHandler.renderOverlay(ms, buffer, light, overlay, partialTicks);
        BlueprintOverlayRenderer.renderOverlay(ms, buffer, light, overlay, partialTicks);
        GoggleOverlayRenderer.renderOverlay(ms, buffer, light, overlay, partialTicks);
    }

    @SubscribeEvent
    public static void getItemTooltipColor(RenderTooltipEvent.Color event) {
        PonderTooltipHandler.handleTooltipColor(event);
    }

    @SubscribeEvent
    public static void addToItemTooltip(ItemTooltipEvent event) {
        List<ITextComponent> kineticStats;
        BlockItem item;
        if (!((Boolean)AllConfigs.CLIENT.tooltips.get()).booleanValue()) {
            return;
        }
        if (event.getPlayer() == null) {
            return;
        }
        ItemStack stack = event.getItemStack();
        String translationKey = stack.func_77973_b().func_77667_c(stack);
        if ((translationKey.startsWith(itemPrefix) || translationKey.startsWith(blockPrefix)) && TooltipHelper.hasTooltip(stack, event.getPlayer())) {
            List itemTooltip = event.getToolTip();
            ArrayList<ITextComponent> toolTip = new ArrayList<ITextComponent>();
            toolTip.add((ITextComponent)itemTooltip.remove(0));
            TooltipHelper.getTooltip(stack).addInformation(toolTip);
            itemTooltip.addAll(0, toolTip);
        }
        if (stack.func_77973_b() instanceof BlockItem && ((item = (BlockItem)stack.func_77973_b()).func_179223_d() instanceof IRotate || item.func_179223_d() instanceof EngineBlock) && !(kineticStats = ItemDescription.getKineticStats(item.func_179223_d())).isEmpty()) {
            event.getToolTip().add(new StringTextComponent(""));
            event.getToolTip().addAll(kineticStats);
        }
        PonderTooltipHandler.addToTooltip(event.getToolTip(), stack);
        SequencedAssemblyRecipe.addToTooltip(event.getToolTip(), stack);
    }

    @SubscribeEvent
    public static void onRenderTick(TickEvent.RenderTickEvent event) {
        if (!ClientEvents.isGameActive()) {
            return;
        }
        TurntableHandler.gameRenderTick();
    }

    protected static boolean isGameActive() {
        return Minecraft.func_71410_x().field_71441_e != null && Minecraft.func_71410_x().field_71439_g != null;
    }

    @SubscribeEvent
    public static void getFogDensity(EntityViewRenderEvent.FogDensity event) {
        ActiveRenderInfo info = event.getInfo();
        FluidState fluidState = info.func_216771_k();
        if (fluidState.func_206888_e()) {
            return;
        }
        Fluid fluid = fluidState.func_206886_c();
        if (fluid.func_207187_a((Fluid)AllFluids.CHOCOLATE.get())) {
            event.setDensity(5.0f);
            event.setCanceled(true);
            return;
        }
        if (fluid.func_207187_a((Fluid)AllFluids.HONEY.get())) {
            event.setDensity(1.5f);
            event.setCanceled(true);
            return;
        }
        if (FluidHelper.isWater(fluid) && ((CopperArmorItem)((Object)AllItems.DIVING_HELMET.get())).isWornBy(Minecraft.func_71410_x().field_175622_Z)) {
            event.setDensity(0.01f);
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public static void getFogColor(EntityViewRenderEvent.FogColors event) {
        ActiveRenderInfo info = event.getInfo();
        FluidState fluidState = info.func_216771_k();
        if (fluidState.func_206888_e()) {
            return;
        }
        Fluid fluid = fluidState.func_206886_c();
        if (fluid.func_207187_a((Fluid)AllFluids.CHOCOLATE.get())) {
            event.setRed(0.3828125f);
            event.setGreen(0.125f);
            event.setBlue(0.125f);
        }
        if (fluid.func_207187_a((Fluid)AllFluids.HONEY.get())) {
            event.setRed(0.9140625f);
            event.setGreen(0.6796875f);
            event.setBlue(0.18359375f);
        }
    }

    @SubscribeEvent
    public static void leftClickEmpty(PlayerInteractEvent.LeftClickEmpty event) {
        ItemStack stack = event.getItemStack();
        if (stack.func_77973_b() instanceof ZapperItem) {
            AllPackets.channel.sendToServer((Object)new LeftClickPacket());
        }
    }

    public static void loadCompleted(FMLLoadCompleteEvent event) {
        ModContainer createContainer = (ModContainer)ModList.get().getModContainerById("create").orElseThrow(() -> new IllegalStateException("Create Mod Container missing after loadCompleted"));
        createContainer.registerExtensionPoint(ExtensionPoint.CONFIGGUIFACTORY, () -> (mc, previousScreen) -> BaseConfigScreen.forCreate(previousScreen));
    }
}

