/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.gui.mainMenu;

import com.jozufozu.flywheel.util.transform.MatrixTransformStack;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.Create;
import com.simibubi.create.foundation.config.ui.BaseConfigScreen;
import com.simibubi.create.foundation.gui.AbstractSimiScreen;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.BoxElement;
import com.simibubi.create.foundation.gui.GuiGameElement;
import com.simibubi.create.foundation.gui.RenderElement;
import com.simibubi.create.foundation.gui.ScreenOpener;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.ponder.content.PonderTagIndexScreen;
import com.simibubi.create.foundation.utility.Color;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.ConfirmOpenLinkScreen;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.RenderSkybox;
import net.minecraft.client.renderer.RenderSkyboxCube;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class CreateMainMenuScreen
extends AbstractSimiScreen {
    protected final Screen parent;
    protected boolean returnOnClose;
    public static final RenderSkyboxCube PANORAMA_RESOURCES = new RenderSkyboxCube(Create.asResource("textures/gui/title/background/panorama"));
    public static final ResourceLocation PANORAMA_OVERLAY_TEXTURES = new ResourceLocation("textures/gui/title/background/panorama_overlay.png");
    private RenderSkybox vanillaPanorama = new RenderSkybox(MainMenuScreen.field_213098_a);
    public static RenderSkybox panorama = new RenderSkybox(PANORAMA_RESOURCES);
    private long firstRenderTime;
    private Button gettingStarted;

    public CreateMainMenuScreen(Screen parent) {
        this.parent = parent;
        this.returnOnClose = true;
        if (parent instanceof MainMenuScreen) {
            this.vanillaPanorama = (RenderSkybox)ObfuscationReflectionHelper.getPrivateValue(MainMenuScreen.class, (Object)((MainMenuScreen)parent), (String)"field_209101_K");
        }
    }

    @Override
    public void func_230430_a_(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        if (this.firstRenderTime == 0L) {
            this.firstRenderTime = Util.func_211177_b();
        }
        super.func_230430_a_(ms, mouseX, mouseY, partialTicks);
    }

    @Override
    protected void renderWindow(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        float f = (float)(Util.func_211177_b() - this.firstRenderTime) / 1000.0f;
        float alpha = MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f);
        float elapsedPartials = this.field_230706_i_.func_193989_ak();
        if (this.parent instanceof MainMenuScreen) {
            if (alpha < 1.0f) {
                this.vanillaPanorama.func_217623_a(elapsedPartials, 1.0f);
            }
            panorama.func_217623_a(elapsedPartials, alpha);
            this.field_230706_i_.func_110434_K().func_110577_a(PANORAMA_OVERLAY_TEXTURES);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            CreateMainMenuScreen.func_238466_a_((MatrixStack)ms, (int)0, (int)0, (int)this.field_230708_k_, (int)this.field_230709_l_, (float)0.0f, (float)0.0f, (int)16, (int)128, (int)16, (int)128);
        }
        RenderSystem.enableDepthTest();
        for (int side : Iterate.positiveAndNegative) {
            ms.func_227860_a_();
            ms.func_227861_a_((double)(this.field_230708_k_ / 2), 60.0, 200.0);
            ms.func_227862_a_((float)(24 * side), (float)(24 * side), 32.0f);
            ms.func_227861_a_(-1.75 * (double)(alpha * alpha / 2.0f + 0.5f), 0.25, 0.0);
            MatrixTransformStack.of((MatrixStack)ms).rotateX(45.0);
            GuiGameElement.of(AllBlocks.LARGE_COGWHEEL.getDefaultState()).rotateBlock(0.0, (float)Util.func_211177_b() / 32.0f * (float)side, 0.0).render(ms);
            ms.func_227861_a_(-1.0, 0.0, -1.0);
            GuiGameElement.of(AllBlocks.COGWHEEL.getDefaultState()).rotateBlock(0.0, (float)Util.func_211177_b() / -16.0f * (float)side + 22.5f, 0.0).render(ms);
            ms.func_227865_b_();
        }
        ms.func_227860_a_();
        ms.func_227861_a_((double)(this.field_230708_k_ / 2 - 32), 32.0, -10.0);
        ms.func_227860_a_();
        ms.func_227862_a_(0.25f, 0.25f, 0.25f);
        AllGuiTextures.LOGO.draw(ms, 0, 0);
        ms.func_227865_b_();
        ((RenderElement)((RenderElement)((RenderElement)((BoxElement)new BoxElement().withBackground(-2013265920)).flatBorder(new Color(0x1000000))).at(-32.0f, 56.0f, 100.0f)).withBounds(128, 11)).render(ms);
        ms.func_227865_b_();
        ms.func_227860_a_();
        ms.func_227861_a_(0.0, 0.0, 200.0);
        CreateMainMenuScreen.func_238472_a_((MatrixStack)ms, (FontRenderer)this.field_230712_o_, (ITextComponent)new StringTextComponent("Create").func_240699_a_(TextFormatting.BOLD).func_230529_a_((ITextComponent)new StringTextComponent(" v0.3.2d").func_240701_a_(new TextFormatting[]{TextFormatting.BOLD, TextFormatting.WHITE})), (int)(this.field_230708_k_ / 2), (int)89, (int)-1787033);
        ms.func_227865_b_();
        RenderSystem.disableDepthTest();
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        this.returnOnClose = true;
        this.addButtons();
    }

    private void addButtons() {
        this.field_230710_m_.clear();
        int yStart = this.field_230709_l_ / 4 + (this.parent instanceof MainMenuScreen ? 40 : 40);
        int center = this.field_230708_k_ / 2;
        int bHeight = 20;
        int bShortWidth = 98;
        int bLongWidth = 200;
        this.func_230480_a_((Widget)new Button(center - 100, yStart + 92, bLongWidth, bHeight, (ITextComponent)Lang.translate("menu.return", new Object[0]), $ -> this.func_231175_as__()));
        this.func_230480_a_((Widget)new Button(center - 100, yStart + 24 + -16, bLongWidth, bHeight, (ITextComponent)Lang.translate("menu.configure", new Object[0]), $ -> this.linkTo(BaseConfigScreen.forCreate(this))));
        this.gettingStarted = new Button(center + 2, yStart + 48 + -16, bShortWidth, bHeight, (ITextComponent)Lang.translate("menu.ponder_index", new Object[0]), $ -> this.linkTo(new PonderTagIndexScreen()));
        this.gettingStarted.field_230693_o_ = !(this.parent instanceof MainMenuScreen);
        this.func_230480_a_((Widget)this.gettingStarted);
        String projectLink = "https://www.curseforge.com/minecraft/mc-mods/create";
        String issueTrackerLink = "https://github.com/Creators-of-Create/Create/issues";
        String supportLink = "https://github.com/Creators-of-Create/Create/wiki/Supporting-the-Project";
        this.func_230480_a_((Widget)new Button(center - 100, yStart + 48 + -16, bShortWidth, bHeight, (ITextComponent)Lang.translate("menu.project_page", new Object[0]), $ -> this.linkTo(projectLink)));
        this.func_230480_a_((Widget)new Button(center + 2, yStart + 68, bShortWidth, bHeight, (ITextComponent)Lang.translate("menu.report_bugs", new Object[0]), $ -> this.linkTo(issueTrackerLink)));
        this.func_230480_a_((Widget)new Button(center - 100, yStart + 68, bShortWidth, bHeight, (ITextComponent)Lang.translate("menu.support", new Object[0]), $ -> this.linkTo(supportLink)));
    }

    @Override
    protected void renderWindowForeground(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        super.renderWindowForeground(ms, mouseX, mouseY, partialTicks);
        this.field_230710_m_.forEach(w -> w.func_230430_a_(ms, mouseX, mouseY, partialTicks));
        if (this.parent instanceof MainMenuScreen) {
            if (mouseX < this.gettingStarted.field_230690_l_ || mouseX > this.gettingStarted.field_230690_l_ + 98) {
                return;
            }
            if (mouseY < this.gettingStarted.field_230691_m_ || mouseY > this.gettingStarted.field_230691_m_ + 20) {
                return;
            }
            this.func_243308_b(ms, TooltipHelper.cutTextComponent((ITextComponent)Lang.translate("menu.only_ingame", new Object[0]), TextFormatting.GRAY, TextFormatting.GRAY), mouseX, mouseY);
        }
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
    }

    private void linkTo(Screen screen) {
        this.returnOnClose = false;
        ScreenOpener.open(screen);
    }

    private void linkTo(String url) {
        this.returnOnClose = false;
        ScreenOpener.open((Screen)new ConfirmOpenLinkScreen(p_213069_2_ -> {
            if (p_213069_2_) {
                Util.func_110647_a().func_195640_a(url);
            }
            this.field_230706_i_.func_147108_a((Screen)this);
        }, url, true));
    }

    @Override
    public boolean func_231177_au__() {
        return true;
    }

    public void func_231175_as__() {
        super.func_231175_as__();
        ScreenOpener.open(this.parent);
    }
}

