/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.elements;

import com.jozufozu.flywheel.util.transform.MatrixTransformStack;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mojang.blaze3d.vertex.MatrixApplyingVertexBuilder;
import com.simibubi.create.CreateClient;
import com.simibubi.create.foundation.ponder.PonderScene;
import com.simibubi.create.foundation.ponder.PonderWorld;
import com.simibubi.create.foundation.ponder.Selection;
import com.simibubi.create.foundation.ponder.elements.AnimatedSceneElement;
import com.simibubi.create.foundation.render.Compartment;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.render.SuperByteBufferCache;
import com.simibubi.create.foundation.render.TileEntityRenderHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.Pair;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.FluidState;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class WorldSectionElement
extends AnimatedSceneElement {
    public static final Compartment<Pair<Integer, Integer>> DOC_WORLD_SECTION = new Compartment();
    List<TileEntity> renderedTileEntities;
    List<TileEntity> tickableTileEntities;
    Selection section;
    boolean redraw;
    Vector3d prevAnimatedOffset = Vector3d.field_186680_a;
    Vector3d animatedOffset = Vector3d.field_186680_a;
    Vector3d prevAnimatedRotation = Vector3d.field_186680_a;
    Vector3d animatedRotation = Vector3d.field_186680_a;
    Vector3d centerOfRotation = Vector3d.field_186680_a;
    Vector3d stabilizationAnchor = null;
    BlockPos selectedBlock;

    public WorldSectionElement() {
    }

    public WorldSectionElement(Selection section) {
        this.section = section.copy();
        this.centerOfRotation = section.getCenter();
    }

    public void mergeOnto(WorldSectionElement other) {
        this.setVisible(false);
        if (other.isEmpty()) {
            other.set(this.section);
        } else {
            other.add(this.section);
        }
    }

    public void set(Selection selection) {
        this.applyNewSelection(selection.copy());
    }

    public void add(Selection toAdd) {
        this.applyNewSelection(this.section.add(toAdd));
    }

    public void erase(Selection toErase) {
        this.applyNewSelection(this.section.substract(toErase));
    }

    private void applyNewSelection(Selection selection) {
        this.section = selection;
        this.queueRedraw();
    }

    public void setCenterOfRotation(Vector3d center) {
        this.centerOfRotation = center;
    }

    public void stabilizeRotation(Vector3d anchor) {
        this.stabilizationAnchor = anchor;
    }

    @Override
    public void reset(PonderScene scene) {
        super.reset(scene);
        this.resetAnimatedTransform();
        this.resetSelectedBlock();
    }

    public void selectBlock(BlockPos pos) {
        this.selectedBlock = pos;
    }

    public void resetSelectedBlock() {
        this.selectedBlock = null;
    }

    public void resetAnimatedTransform() {
        this.prevAnimatedOffset = Vector3d.field_186680_a;
        this.animatedOffset = Vector3d.field_186680_a;
        this.prevAnimatedRotation = Vector3d.field_186680_a;
        this.animatedRotation = Vector3d.field_186680_a;
    }

    public void queueRedraw() {
        this.redraw = true;
    }

    public boolean isEmpty() {
        return this.section == null;
    }

    public void setEmpty() {
        this.section = null;
    }

    public void setAnimatedRotation(Vector3d eulerAngles, boolean force) {
        this.animatedRotation = eulerAngles;
        if (force) {
            this.prevAnimatedRotation = this.animatedRotation;
        }
    }

    public Vector3d getAnimatedRotation() {
        return this.animatedRotation;
    }

    public void setAnimatedOffset(Vector3d offset, boolean force) {
        this.animatedOffset = offset;
        if (force) {
            this.prevAnimatedOffset = this.animatedOffset;
        }
    }

    public Vector3d getAnimatedOffset() {
        return this.animatedOffset;
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && !this.isEmpty();
    }

    public Pair<Vector3d, BlockPos> rayTrace(PonderWorld world, Vector3d source, Vector3d target) {
        world.setMask(this.section);
        Vector3d transformedTarget = this.reverseTransformVec(target);
        BlockRayTraceResult rayTraceBlocks = world.func_217299_a(new RayTraceContext(this.reverseTransformVec(source), transformedTarget, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, null));
        world.clearMask();
        if (rayTraceBlocks == null) {
            return null;
        }
        if (rayTraceBlocks.func_216347_e() == null) {
            return null;
        }
        double t = rayTraceBlocks.func_216347_e().func_178788_d(transformedTarget).func_189985_c() / source.func_178788_d(target).func_189985_c();
        Vector3d actualHit = VecHelper.lerp((float)t, target, source);
        return Pair.of(actualHit, rayTraceBlocks.func_216350_a());
    }

    private Vector3d reverseTransformVec(Vector3d in) {
        float pt = AnimationTickHolder.getPartialTicks();
        in = in.func_178788_d(VecHelper.lerp(pt, this.prevAnimatedOffset, this.animatedOffset));
        if (!this.animatedRotation.equals((Object)Vector3d.field_186680_a) || !this.prevAnimatedRotation.equals((Object)Vector3d.field_186680_a)) {
            if (this.centerOfRotation == null) {
                this.centerOfRotation = this.section.getCenter();
            }
            double rotX = MathHelper.func_219803_d((double)pt, (double)this.prevAnimatedRotation.field_72450_a, (double)this.animatedRotation.field_72450_a);
            double rotZ = MathHelper.func_219803_d((double)pt, (double)this.prevAnimatedRotation.field_72449_c, (double)this.animatedRotation.field_72449_c);
            double rotY = MathHelper.func_219803_d((double)pt, (double)this.prevAnimatedRotation.field_72448_b, (double)this.animatedRotation.field_72448_b);
            in = in.func_178788_d(this.centerOfRotation);
            in = VecHelper.rotate(in, -rotX, Direction.Axis.X);
            in = VecHelper.rotate(in, -rotZ, Direction.Axis.Z);
            in = VecHelper.rotate(in, -rotY, Direction.Axis.Y);
            in = in.func_178787_e(this.centerOfRotation);
            if (this.stabilizationAnchor != null) {
                in = in.func_178788_d(this.stabilizationAnchor);
                in = VecHelper.rotate(in, rotX, Direction.Axis.X);
                in = VecHelper.rotate(in, rotZ, Direction.Axis.Z);
                in = VecHelper.rotate(in, rotY, Direction.Axis.Y);
                in = in.func_178787_e(this.stabilizationAnchor);
            }
        }
        return in;
    }

    public void transformMS(MatrixStack ms, float pt) {
        MatrixTransformStack.of((MatrixStack)ms).translate(VecHelper.lerp(pt, this.prevAnimatedOffset, this.animatedOffset));
        if (!this.animatedRotation.equals((Object)Vector3d.field_186680_a) || !this.prevAnimatedRotation.equals((Object)Vector3d.field_186680_a)) {
            if (this.centerOfRotation == null) {
                this.centerOfRotation = this.section.getCenter();
            }
            double rotX = MathHelper.func_219803_d((double)pt, (double)this.prevAnimatedRotation.field_72450_a, (double)this.animatedRotation.field_72450_a);
            double rotZ = MathHelper.func_219803_d((double)pt, (double)this.prevAnimatedRotation.field_72449_c, (double)this.animatedRotation.field_72449_c);
            double rotY = MathHelper.func_219803_d((double)pt, (double)this.prevAnimatedRotation.field_72448_b, (double)this.animatedRotation.field_72448_b);
            MatrixTransformStack.of((MatrixStack)ms).translate(this.centerOfRotation).rotateX(rotX).rotateZ(rotZ).rotateY(rotY).translateBack(this.centerOfRotation);
            if (this.stabilizationAnchor != null) {
                MatrixTransformStack.of((MatrixStack)ms).translate(this.stabilizationAnchor).rotateX(-rotX).rotateZ(-rotZ).rotateY(-rotY).translateBack(this.stabilizationAnchor);
            }
        }
    }

    @Override
    public void tick(PonderScene scene) {
        this.prevAnimatedOffset = this.animatedOffset;
        this.prevAnimatedRotation = this.animatedRotation;
        if (!this.isVisible()) {
            return;
        }
        this.loadTEsIfMissing(scene.getWorld());
        this.renderedTileEntities.removeIf(te -> scene.getWorld().func_175625_s(te.func_174877_v()) != te);
        this.tickableTileEntities.removeIf(te -> scene.getWorld().func_175625_s(te.func_174877_v()) != te);
        this.tickableTileEntities.forEach(te -> {
            if (te instanceof ITickableTileEntity) {
                ((ITickableTileEntity)te).func_73660_a();
            }
        });
    }

    @Override
    public void whileSkipping(PonderScene scene) {
        if (this.redraw) {
            this.renderedTileEntities = null;
            this.tickableTileEntities = null;
        }
        this.redraw = false;
    }

    protected void loadTEsIfMissing(PonderWorld world) {
        if (this.renderedTileEntities != null) {
            return;
        }
        this.tickableTileEntities = new ArrayList<TileEntity>();
        this.renderedTileEntities = new ArrayList<TileEntity>();
        this.section.forEach(pos -> {
            TileEntity tileEntity = world.func_175625_s((BlockPos)pos);
            if (tileEntity == null) {
                return;
            }
            this.tickableTileEntities.add(tileEntity);
            this.renderedTileEntities.add(tileEntity);
            tileEntity.func_145836_u();
        });
    }

    @Override
    protected void renderLayer(PonderWorld world, IRenderTypeBuffer buffer, RenderType type, MatrixStack ms, float fade, float pt) {
        this.transformMS(ms, pt);
        this.renderStructure(world, ms, buffer, type, fade);
    }

    @Override
    public void renderFirst(PonderWorld world, IRenderTypeBuffer buffer, MatrixStack ms, float fade, float pt) {
        int light = -1;
        if (fade != 1.0f) {
            light = (int)MathHelper.func_219799_g((float)fade, (float)5.0f, (float)14.0f);
        }
        if (this.redraw) {
            this.renderedTileEntities = null;
            this.tickableTileEntities = null;
        }
        this.transformMS(ms, pt);
        world.pushFakeLight(light);
        this.renderTileEntities(world, ms, buffer, pt);
        world.popLight();
        Map<BlockPos, Integer> blockBreakingProgressions = world.getBlockBreakingProgressions();
        MatrixStack overlayMS = null;
        for (Map.Entry<BlockPos, Integer> entry : blockBreakingProgressions.entrySet()) {
            BlockPos pos = entry.getKey();
            if (!this.section.test(pos)) continue;
            if (overlayMS == null) {
                overlayMS = new MatrixStack();
                world.scene.getTransform().apply(overlayMS, pt, true);
                this.transformMS(overlayMS, pt);
            }
            ms.func_227860_a_();
            ms.func_227861_a_((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            MatrixApplyingVertexBuilder builder = new MatrixApplyingVertexBuilder(buffer.getBuffer((RenderType)ModelBakery.field_229320_k_.get(entry.getValue())), overlayMS.func_227866_c_().func_227870_a_(), overlayMS.func_227866_c_().func_227872_b_());
            Minecraft.func_71410_x().func_175602_ab().renderModel(world.func_180495_p(pos), pos, (IBlockDisplayReader)world, ms, (IVertexBuilder)builder, true, world.field_73012_v, (IModelData)EmptyModelData.INSTANCE);
            ms.func_227865_b_();
        }
    }

    protected void renderStructure(PonderWorld world, MatrixStack ms, IRenderTypeBuffer buffer, RenderType type, float fade) {
        SuperByteBuffer contraptionBuffer;
        SuperByteBufferCache bufferCache = CreateClient.BUFFER_CACHE;
        int code = this.hashCode() ^ ((Object)((Object)world)).hashCode();
        Pair<Integer, Integer> key = Pair.of(code, RenderType.func_228661_n_().indexOf(type));
        if (this.redraw) {
            bufferCache.invalidate(DOC_WORLD_SECTION, key);
        }
        if ((contraptionBuffer = bufferCache.get(DOC_WORLD_SECTION, key, () -> this.buildStructureBuffer(world, type))).isEmpty()) {
            return;
        }
        int light = this.lightCoordsFromFade(fade);
        contraptionBuffer.light(light).renderInto(ms, buffer.getBuffer(type));
    }

    @Override
    protected void renderLast(PonderWorld world, IRenderTypeBuffer buffer, MatrixStack ms, float fade, float pt) {
        this.redraw = false;
        if (this.selectedBlock == null) {
            return;
        }
        BlockState blockState = world.func_180495_p(this.selectedBlock);
        if (blockState.func_196958_f()) {
            return;
        }
        VoxelShape shape = blockState.func_215700_a((IBlockReader)world, this.selectedBlock, ISelectionContext.func_216374_a((Entity)Minecraft.func_71410_x().field_71439_g));
        if (shape.func_197766_b()) {
            return;
        }
        ms.func_227860_a_();
        this.transformMS(ms, pt);
        RenderSystem.disableTexture();
        WorldRenderer.func_228430_a_((MatrixStack)ms, (IVertexBuilder)buffer.getBuffer(RenderType.func_228659_m_()), (AxisAlignedBB)shape.func_197752_a().func_186670_a(this.selectedBlock), (float)1.0f, (float)1.0f, (float)1.0f, (float)0.6f);
        ms.func_227865_b_();
    }

    private void renderTileEntities(PonderWorld world, MatrixStack ms, IRenderTypeBuffer buffer, float pt) {
        this.loadTEsIfMissing(world);
        TileEntityRenderHelper.renderTileEntities(world, this.renderedTileEntities, ms, buffer, pt);
    }

    private SuperByteBuffer buildStructureBuffer(PonderWorld world, RenderType layer) {
        ForgeHooksClient.setRenderLayer((RenderType)layer);
        MatrixStack ms = new MatrixStack();
        BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
        BlockModelRenderer blockRenderer = dispatcher.func_175019_b();
        Random random = new Random();
        BufferBuilder builder = new BufferBuilder(DefaultVertexFormats.field_176600_a.func_181719_f());
        builder.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        world.setMask(this.section);
        this.section.forEach(pos -> {
            BlockState state = world.func_180495_p((BlockPos)pos);
            FluidState ifluidstate = world.func_204610_c((BlockPos)pos);
            ms.func_227860_a_();
            ms.func_227861_a_((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            if (state.func_185901_i() != BlockRenderType.ENTITYBLOCK_ANIMATED && state.func_177230_c() != Blocks.field_150350_a && RenderTypeLookup.canRenderInLayer((BlockState)state, (RenderType)layer)) {
                TileEntity tileEntity = world.func_175625_s((BlockPos)pos);
                blockRenderer.renderModel((IBlockDisplayReader)world, dispatcher.func_184389_a(state), state, pos, ms, (IVertexBuilder)builder, true, random, 42L, OverlayTexture.field_229196_a_, (IModelData)(tileEntity != null ? tileEntity.getModelData() : EmptyModelData.INSTANCE));
            }
            if (!ifluidstate.func_206888_e() && RenderTypeLookup.canRenderInLayer((FluidState)ifluidstate, (RenderType)layer)) {
                dispatcher.func_228794_a_(pos, (IBlockDisplayReader)world, (IVertexBuilder)builder, ifluidstate);
            }
            ms.func_227865_b_();
        });
        world.clearMask();
        builder.func_178977_d();
        return new SuperByteBuffer(builder);
    }

    class WorldSectionRayTraceResult {
        Vector3d actualHitVec;
        BlockPos worldPos;

        WorldSectionRayTraceResult() {
        }
    }
}

