/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.instructions;

import com.simibubi.create.content.contraptions.components.structureMovement.glue.SuperGlueItem;
import com.simibubi.create.foundation.ponder.PonderScene;
import com.simibubi.create.foundation.ponder.Selection;
import com.simibubi.create.foundation.ponder.elements.WorldSectionElement;
import com.simibubi.create.foundation.ponder.instructions.FadeIntoSceneInstruction;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;

public class DisplayWorldSectionInstruction
extends FadeIntoSceneInstruction<WorldSectionElement> {
    private Selection initialSelection;
    private Optional<Supplier<WorldSectionElement>> mergeOnto;
    private BlockPos glue;

    public DisplayWorldSectionInstruction(int fadeInTicks, Direction fadeInFrom, Selection selection, Optional<Supplier<WorldSectionElement>> mergeOnto) {
        this(fadeInTicks, fadeInFrom, selection, mergeOnto, null);
    }

    public DisplayWorldSectionInstruction(int fadeInTicks, Direction fadeInFrom, Selection selection, Optional<Supplier<WorldSectionElement>> mergeOnto, @Nullable BlockPos glue) {
        super(fadeInTicks, fadeInFrom, new WorldSectionElement(selection));
        this.initialSelection = selection;
        this.mergeOnto = mergeOnto;
        this.glue = glue;
    }

    @Override
    protected void firstTick(PonderScene scene) {
        super.firstTick(scene);
        this.mergeOnto.ifPresent(wse -> ((WorldSectionElement)this.element).setAnimatedOffset(((WorldSectionElement)wse.get()).getAnimatedOffset(), true));
        ((WorldSectionElement)this.element).set(this.initialSelection);
        ((WorldSectionElement)this.element).setVisible(true);
    }

    @Override
    public void tick(PonderScene scene) {
        super.tick(scene);
        if (this.remainingTicks > 0) {
            return;
        }
        this.mergeOnto.ifPresent(c -> ((WorldSectionElement)this.element).mergeOnto((WorldSectionElement)c.get()));
        if (this.glue != null) {
            SuperGlueItem.spawnParticles(scene.getWorld(), this.glue, this.fadeInFrom, true);
        }
    }

    @Override
    protected Class<WorldSectionElement> getElementClass() {
        return WorldSectionElement.class;
    }
}

