/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend;

import com.jozufozu.flywheel.backend.ShaderSources;
import com.jozufozu.flywheel.backend.pipeline.SourceFile;
import com.jozufozu.flywheel.backend.pipeline.error.ErrorReporter;
import com.jozufozu.flywheel.backend.pipeline.span.Span;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;

public class FileResolution {
    private final List<Span> foundSpans = new ArrayList<Span>();
    private final ResourceLocation fileLoc;
    private SourceFile file;

    public FileResolution(ResourceLocation fileLoc) {
        this.fileLoc = fileLoc;
    }

    public ResourceLocation getFileLoc() {
        return this.fileLoc;
    }

    @Nullable
    public SourceFile getFile() {
        return this.file;
    }

    public void addSpan(Span span) {
        this.foundSpans.add(span);
    }

    public void resolve(ShaderSources sources) {
        try {
            this.file = sources.source(this.fileLoc);
        }
        catch (RuntimeException error) {
            ErrorReporter.generateSpanError(this.foundSpans.get(0), "could not find source");
        }
    }
}

