/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.pipeline;

import com.jozufozu.flywheel.backend.gl.shader.GlShader;
import com.jozufozu.flywheel.backend.gl.shader.ShaderType;
import com.jozufozu.flywheel.backend.pipeline.GLSLVersion;
import com.jozufozu.flywheel.backend.pipeline.Includer;
import com.jozufozu.flywheel.backend.pipeline.SourceFile;
import com.jozufozu.flywheel.backend.pipeline.Template;
import java.util.List;
import net.minecraft.util.ResourceLocation;

public class ShaderBuilder {
    public final ResourceLocation name;
    public final Template template;
    private SourceFile mainFile;
    private GLSLVersion version;
    private StringBuilder source;
    private StringBuilder defines;
    private CharSequence footer;

    public ShaderBuilder(ResourceLocation name, Template template) {
        this.name = name;
        this.template = template;
    }

    public ShaderBuilder setVersion(GLSLVersion version) {
        this.version = version;
        return this;
    }

    public ShaderBuilder setDefines(List<String> defs) {
        this.defines = new StringBuilder();
        for (String def : defs) {
            this.defines.append("#define ").append(def).append('\n');
        }
        return this;
    }

    public ShaderBuilder setFooter(CharSequence footer) {
        this.footer = footer;
        return this;
    }

    public ShaderBuilder setMainSource(SourceFile file) {
        if (this.mainFile == file) {
            return this;
        }
        this.mainFile = file;
        this.source = new StringBuilder();
        for (SourceFile includeFile : Includer.recurseIncludes(file)) {
            this.source.append(includeFile.getElidedSource());
        }
        this.source.append(file.getElidedSource());
        return this;
    }

    public GlShader compile(ResourceLocation name, ShaderType type) {
        StringBuilder finalSource = new StringBuilder();
        finalSource.append("#version ").append((Object)this.version).append('\n').append("#define ").append(type.define).append('\n').append(this.defines != null ? this.defines : "").append((CharSequence)this.source).append(this.template.footer(type, this.mainFile));
        return new GlShader(name, type, (CharSequence)finalSource);
    }
}

