/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.pipeline;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.jozufozu.flywheel.backend.ShaderSources;
import com.jozufozu.flywheel.backend.pipeline.parse.Import;
import com.jozufozu.flywheel.backend.pipeline.parse.ShaderFunction;
import com.jozufozu.flywheel.backend.pipeline.parse.ShaderStruct;
import com.jozufozu.flywheel.backend.pipeline.span.CharPos;
import com.jozufozu.flywheel.backend.pipeline.span.ErrorSpan;
import com.jozufozu.flywheel.backend.pipeline.span.Span;
import com.jozufozu.flywheel.backend.pipeline.span.StringSpan;
import com.jozufozu.flywheel.util.StringUtil;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.util.ResourceLocation;

public class SourceFile {
    private static final Pattern includePattern = Pattern.compile("#use \"(.*)\"");
    private static final Pattern newLine = Pattern.compile("(\\r\\n|\\r|\\n)");
    public static final Pattern functionDeclaration = Pattern.compile("(\\w+)\\s+(\\w+)\\s*\\(([\\w,\\s]*)\\)\\s*\\{");
    public final ResourceLocation name;
    private final ShaderSources parent;
    private final String source;
    private final CharSequence elided;
    private final ImmutableList<String> lines;
    private final IntList lineStarts;
    private final ImmutableMap<String, ShaderFunction> functions;
    private final ImmutableMap<String, ShaderStruct> structs;
    private final ImmutableList<Import> imports;
    private final List<Span> elisions = new ArrayList<Span>();

    public SourceFile(ShaderSources parent, ResourceLocation name, String source) {
        this.parent = parent;
        this.name = name;
        this.source = source;
        this.lineStarts = this.createLineStarts();
        this.lines = this.createLineList(this.lineStarts);
        this.imports = this.parseImports();
        this.functions = this.parseFunctions();
        this.structs = this.parseStructs();
        this.elided = this.createElidedSource();
    }

    public String getSource() {
        return this.source;
    }

    public CharSequence getElidedSource() {
        return this.elided;
    }

    public ShaderSources getParent() {
        return this.parent;
    }

    public ImmutableMap<String, ShaderFunction> getFunctions() {
        return this.functions;
    }

    public ImmutableMap<String, ShaderStruct> getStructs() {
        return this.structs;
    }

    public ImmutableList<Import> getIncludes() {
        return this.imports;
    }

    public CharPos getCharPos(int charPos) {
        int ls;
        int lineNo;
        for (lineNo = 0; lineNo < this.lineStarts.size() && charPos >= (ls = this.lineStarts.getInt(lineNo)); ++lineNo) {
        }
        int lineStart = this.lineStarts.getInt(--lineNo);
        return new CharPos(charPos, lineNo, charPos - lineStart);
    }

    public String printSource() {
        StringBuilder builder = new StringBuilder();
        builder.append("Source for shader '").append(this.name).append("':\n");
        int i = 1;
        for (String s : this.lines) {
            builder.append(String.format("%1$4s: ", i++)).append(s).append('\n');
        }
        return builder.toString();
    }

    private CharSequence createElidedSource() {
        StringBuilder out = new StringBuilder();
        int lastEnd = 0;
        for (Span elision : this.elisions) {
            out.append(this.source, lastEnd, elision.getStartPos());
            lastEnd = elision.getEndPos();
        }
        out.append(this.source, lastEnd, this.source.length());
        return out;
    }

    private IntList createLineStarts() {
        IntArrayList l = new IntArrayList();
        l.add(0);
        Matcher matcher = newLine.matcher(this.source);
        while (matcher.find()) {
            l.add(matcher.end());
        }
        return l;
    }

    private ImmutableList<String> createLineList(IntList lines) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 1; i < lines.size(); ++i) {
            int start = lines.getInt(i - 1);
            int end = lines.getInt(i);
            builder.add((Object)StringUtil.trimEnd(this.source.substring(start, end)));
        }
        return builder.build();
    }

    private ImmutableMap<String, ShaderFunction> parseFunctions() {
        Matcher matcher = functionDeclaration.matcher(this.source);
        HashMap<String, ShaderFunction> functions = new HashMap<String, ShaderFunction>();
        while (matcher.find()) {
            Span body;
            Span self;
            Span type = Span.fromMatcher(this, matcher, 1);
            Span name = Span.fromMatcher(this, matcher, 2);
            Span args = Span.fromMatcher(this, matcher, 3);
            int blockStart = matcher.end();
            int blockEnd = this.findEndOfBlock(blockStart);
            if (blockEnd > blockStart) {
                self = new StringSpan(this, matcher.start(), blockEnd + 1);
                body = new StringSpan(this, blockStart, blockEnd);
            } else {
                self = new ErrorSpan(this, matcher.start(), matcher.end());
                body = new ErrorSpan(this, blockStart);
            }
            ShaderFunction function = new ShaderFunction(self, type, name, args, body);
            functions.put(name.get(), function);
        }
        return ImmutableMap.copyOf(functions);
    }

    private ImmutableMap<String, ShaderStruct> parseStructs() {
        Matcher matcher = ShaderStruct.struct.matcher(this.source);
        ImmutableMap.Builder structs = ImmutableMap.builder();
        while (matcher.find()) {
            Span self = Span.fromMatcher(this, matcher);
            Span name = Span.fromMatcher(this, matcher, 1);
            Span body = Span.fromMatcher(this, matcher, 2);
            ShaderStruct shaderStruct = new ShaderStruct(self, name, body);
            structs.put((Object)name.get(), (Object)shaderStruct);
        }
        return structs.build();
    }

    private ImmutableList<Import> parseImports() {
        Matcher uses = includePattern.matcher(this.source);
        ArrayList<Import> imports = new ArrayList<Import>();
        while (uses.find()) {
            Span use = Span.fromMatcher(this, uses);
            Span file = Span.fromMatcher(this, uses, 1);
            imports.add(new Import(this.parent, use, file));
            this.elisions.add(use);
        }
        return ImmutableList.copyOf(imports);
    }

    private int findEndOfBlock(int start) {
        int blockDepth = 0;
        for (int i = start + 1; i < this.source.length(); ++i) {
            char ch = this.source.charAt(i);
            if (ch == '{') {
                ++blockDepth;
            } else if (ch == '}') {
                --blockDepth;
            }
            if (blockDepth >= 0) continue;
            return i;
        }
        return -1;
    }

    public int getLineCount() {
        return this.lines.size();
    }

    public CharSequence getLine(int lineNo) {
        return (CharSequence)this.lines.get(lineNo);
    }
}

