/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.pipeline.parse;

import com.jozufozu.flywheel.backend.FileResolution;
import com.jozufozu.flywheel.backend.ShaderSources;
import com.jozufozu.flywheel.backend.pipeline.SourceFile;
import com.jozufozu.flywheel.backend.pipeline.error.ErrorReporter;
import com.jozufozu.flywheel.backend.pipeline.parse.AbstractShaderElement;
import com.jozufozu.flywheel.backend.pipeline.span.Span;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;

public class Import
extends AbstractShaderElement {
    public static final List<Import> IMPORTS = new ArrayList<Import>();
    private final Span file;
    private final FileResolution resolution;
    private final ResourceLocation fileLoc;

    public Import(ShaderSources parent, Span self, Span file) {
        super(self);
        this.file = file;
        this.fileLoc = this.toRL(file);
        this.resolution = parent.resolveFile(this.fileLoc);
        this.resolution.addSpan(file);
        IMPORTS.add(this);
    }

    private ResourceLocation toRL(Span file) {
        try {
            return new ResourceLocation(file.get());
        }
        catch (RuntimeException error) {
            ErrorReporter.generateSpanError(file, "malformed source name");
            return new ResourceLocation("");
        }
    }

    @Nullable
    public SourceFile getFile() {
        return this.resolution.getFile();
    }

    public ResourceLocation getFileLoc() {
        return this.resolution.getFileLoc();
    }
}

