/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.pipeline.parse;

import com.google.common.collect.ImmutableList;
import com.jozufozu.flywheel.backend.pipeline.parse.AbstractShaderElement;
import com.jozufozu.flywheel.backend.pipeline.parse.Variable;
import com.jozufozu.flywheel.backend.pipeline.span.Span;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class ShaderFunction
extends AbstractShaderElement {
    public static final Pattern argument = Pattern.compile("(\\w+)\\s+(\\w+)");
    public static final Pattern assignment = Pattern.compile("(\\w+)\\s*=");
    private final Span type;
    private final Span name;
    private final Span args;
    private final Span body;
    private final ImmutableList<Variable> parameters;

    public ShaderFunction(Span self, Span type, Span name, Span args, Span body) {
        super(self);
        this.type = type;
        this.name = name;
        this.args = args;
        this.body = body;
        this.parameters = this.parseArguments();
    }

    public String call(String ... args) {
        return this.name + "(" + String.join((CharSequence)", ", args) + ")";
    }

    public ImmutableList<Variable> getParameters() {
        return this.parameters;
    }

    public String returnType() {
        return this.type.get();
    }

    protected ImmutableList<Variable> parseArguments() {
        if (this.args.isErr() || this.args.isEmpty()) {
            return ImmutableList.of();
        }
        Matcher arguments = argument.matcher(this.args.get());
        ImmutableList.Builder builder = ImmutableList.builder();
        while (arguments.find()) {
            Span self = Span.fromMatcher(this.args, arguments);
            Span type = Span.fromMatcher(this.args, arguments, 1);
            Span name = Span.fromMatcher(this.args, arguments, 2);
            builder.add((Object)new Variable(self, type, name));
        }
        return builder.build();
    }

    public String toString() {
        String p = this.parameters.stream().map(Variable::typeName).map(Span::get).collect(Collectors.joining(","));
        return this.type + " " + this.name + "(" + p + ")";
    }
}

