/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.backend.ResourceUtil;
import com.jozufozu.flywheel.backend.ShaderSources;
import com.jozufozu.flywheel.backend.gl.shader.ShaderType;
import com.jozufozu.flywheel.backend.loading.Shader;
import com.jozufozu.flywheel.backend.loading.ShaderLoadingException;
import java.util.EnumMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.util.ResourceLocation;

public class Builtins {
    private static final String declaration = "#flwbuiltins";
    private static final Pattern builtinPattern = Pattern.compile("#flwbuiltins");
    private final Map<ShaderType, String> builtinSources = new EnumMap<ShaderType, String>(ShaderType.class);

    public static Builder builder() {
        return new Builder();
    }

    public void injectBuiltins(Shader shader) {
        Matcher matcher = builtinPattern.matcher(shader.getSource());
        if (!matcher.find()) {
            throw new ShaderLoadingException(String.format("%s is missing %s, cannot use in World Context", shader.type.name, declaration));
        }
        shader.setSource(matcher.replaceFirst(this.builtinSources.get((Object)shader.type)));
    }

    public Builtins(ShaderSources sources, Builder builder) {
        try {
            builder.builtins.forEach((type, resourceLocation) -> this.builtinSources.put((ShaderType)((Object)type), sources.getShaderSource((ResourceLocation)resourceLocation)));
        }
        catch (ShaderLoadingException e) {
            sources.notifyError();
            Backend.log.error(String.format("Could not find builtin: %s", e.getMessage()));
        }
    }

    public static class Builder {
        private final Map<ShaderType, ResourceLocation> builtins = new EnumMap<ShaderType, ResourceLocation>(ShaderType.class);

        public Builder withBuiltin(ShaderType shaderType, ResourceLocation folder, String file) {
            return this.withBuiltin(shaderType, ResourceUtil.subPath(folder, file));
        }

        public Builder withBuiltin(ShaderType shaderType, ResourceLocation file) {
            this.builtins.put(shaderType, file);
            return this;
        }

        public Builtins build(ShaderSources sources) {
            return new Builtins(sources, this);
        }
    }
}

