/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.model;

import com.jozufozu.flywheel.backend.gl.attrib.VertexFormat;
import com.jozufozu.flywheel.backend.gl.buffer.VecBuffer;
import com.jozufozu.flywheel.core.model.IModel;
import com.jozufozu.flywheel.util.BufferBuilderReader;
import com.jozufozu.flywheel.util.VirtualEmptyModelData;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Arrays;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.client.model.data.IModelData;

public class BlockModel
implements IModel {
    private static final MatrixStack IDENTITY = new MatrixStack();
    private final BufferBuilderReader reader;
    private final VertexFormat modelFormat;
    private static final Direction[] dirs;

    public BlockModel(VertexFormat modelFormat, BlockState state) {
        this(modelFormat, Minecraft.func_71410_x().func_175602_ab().func_184389_a(state), state);
    }

    public BlockModel(VertexFormat modelFormat, IBakedModel model, BlockState referenceState) {
        this(modelFormat, model, referenceState, IDENTITY);
    }

    public BlockModel(VertexFormat modelFormat, IBakedModel model, BlockState referenceState, MatrixStack ms) {
        this.modelFormat = modelFormat;
        this.reader = new BufferBuilderReader(BlockModel.getBufferBuilder(model, referenceState, ms));
    }

    @Override
    public VertexFormat format() {
        return this.modelFormat;
    }

    @Override
    public int vertexCount() {
        return this.reader.getVertexCount();
    }

    @Override
    public void buffer(VecBuffer buffer) {
        int vertexCount = this.vertexCount();
        for (int i = 0; i < vertexCount; ++i) {
            buffer.putVec3(this.reader.getX(i), this.reader.getY(i), this.reader.getZ(i));
            buffer.putVec3(this.reader.getNX(i), this.reader.getNY(i), this.reader.getNZ(i));
            buffer.putVec2(this.reader.getU(i), this.reader.getV(i));
        }
    }

    public static BufferBuilder getBufferBuilder(IBakedModel model, BlockState referenceState, MatrixStack ms) {
        Minecraft mc = Minecraft.func_71410_x();
        BlockRendererDispatcher dispatcher = mc.func_175602_ab();
        BlockModelRenderer blockRenderer = dispatcher.func_175019_b();
        BufferBuilder builder = new BufferBuilder(512);
        builder.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        blockRenderer.renderModel((IBlockDisplayReader)mc.field_71441_e, model, referenceState, BlockPos.field_177992_a.func_177981_b(255), ms, (IVertexBuilder)builder, true, mc.field_71441_e.field_73012_v, 42L, OverlayTexture.field_229196_a_, (IModelData)VirtualEmptyModelData.INSTANCE);
        builder.func_178977_d();
        return builder;
    }

    static {
        Direction[] directions = Direction.values();
        dirs = Arrays.copyOf(directions, directions.length + 1);
    }
}

