/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.shader;

import com.google.common.collect.ImmutableList;
import com.jozufozu.flywheel.backend.gl.GlObject;
import com.jozufozu.flywheel.backend.gl.shader.GlProgram;
import com.jozufozu.flywheel.core.shader.IMultiProgram;
import com.jozufozu.flywheel.core.shader.spec.IGameStateCondition;
import com.jozufozu.flywheel.util.Pair;
import java.util.ArrayList;
import java.util.List;

public class GameStateProgram<P extends GlProgram>
implements IMultiProgram<P> {
    private final List<Pair<IGameStateCondition, P>> variants;
    private final P fallback;

    protected GameStateProgram(List<Pair<IGameStateCondition, P>> variants, P fallback) {
        this.variants = variants;
        this.fallback = fallback;
    }

    @Override
    public P get() {
        for (Pair<IGameStateCondition, P> variant : this.variants) {
            if (!variant.getFirst().isMet()) continue;
            return (P)((GlProgram)variant.getSecond());
        }
        return this.fallback;
    }

    @Override
    public void delete() {
        for (Pair<IGameStateCondition, P> variant : this.variants) {
            ((GlProgram)variant.getSecond()).delete();
        }
        ((GlObject)this.fallback).delete();
    }

    public static <P extends GlProgram> Builder<P> builder(P fallback) {
        return new Builder<P>(fallback);
    }

    public static class Builder<P extends GlProgram> {
        private final P fallback;
        private final List<Pair<IGameStateCondition, P>> variants = new ArrayList<Pair<IGameStateCondition, P>>();

        public Builder(P fallback) {
            this.fallback = fallback;
        }

        public Builder<P> withVariant(IGameStateCondition condition, P program) {
            this.variants.add(Pair.of(condition, program));
            return this;
        }

        public IMultiProgram<P> build() {
            return new GameStateProgram<P>(ImmutableList.copyOf(this.variants), this.fallback);
        }
    }
}

