/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.mixin;

import com.jozufozu.flywheel.backend.Backend;
import net.minecraft.client.multiplayer.ClientChunkProvider;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.chunk.AbstractChunkProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ClientChunkProvider.class})
public abstract class FastChunkProviderMixin
extends AbstractChunkProvider {
    @Shadow
    @Final
    private ClientWorld field_73235_d;
    @Unique
    private int lastX;
    @Unique
    private int lastZ;
    @Unique
    private IChunk lastChunk;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"getChunk"}, at={@At(value="HEAD")}, cancellable=true)
    public void returnCachedChunk(int x, int z, ChunkStatus status, boolean create, CallbackInfoReturnable<IChunk> cir) {
        if (Backend.getInstance().chunkCachingEnabled && status.func_209003_a(ChunkStatus.field_222617_m)) {
            ClientWorld clientWorld = this.field_73235_d;
            synchronized (clientWorld) {
                if (this.lastChunk != null && x == this.lastX && z == this.lastZ) {
                    cir.setReturnValue((Object)this.lastChunk);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"getChunk"}, at={@At(value="RETURN")})
    public void cacheChunk(int x, int z, ChunkStatus status, boolean create, CallbackInfoReturnable<IChunk> cir) {
        if (Backend.getInstance().chunkCachingEnabled && status.func_209003_a(ChunkStatus.field_222617_m)) {
            ClientWorld clientWorld = this.field_73235_d;
            synchronized (clientWorld) {
                this.lastChunk = (IChunk)cir.getReturnValue();
                this.lastX = x;
                this.lastZ = z;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"drop"}, at={@At(value="HEAD")})
    public void invalidateOnDrop(int x, int z, CallbackInfo ci) {
        if (Backend.getInstance().chunkCachingEnabled) {
            ClientWorld clientWorld = this.field_73235_d;
            synchronized (clientWorld) {
                if (x == this.lastX && z == this.lastZ) {
                    this.lastChunk = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"replaceWithPacketData"}, at={@At(value="HEAD")})
    public void invalidateOnPacket(int x, int z, BiomeContainer p_228313_3_, PacketBuffer p_228313_4_, CompoundNBT p_228313_5_, int p_228313_6_, boolean p_228313_7_, CallbackInfoReturnable<Chunk> cir) {
        if (Backend.getInstance().chunkCachingEnabled) {
            ClientWorld clientWorld = this.field_73235_d;
            synchronized (clientWorld) {
                if (x == this.lastX && z == this.lastZ) {
                    this.lastChunk = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Redirect(method={"isTickingChunk"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientChunkProvider;hasChunk(II)Z"))
    public boolean redirectTicking(ClientChunkProvider clientChunkProvider, int x, int z) {
        if (Backend.getInstance().chunkCachingEnabled) {
            ClientWorld clientWorld = this.field_73235_d;
            synchronized (clientWorld) {
                if (this.lastChunk != null && x == this.lastX && z == this.lastZ) {
                    return true;
                }
            }
        }
        return clientChunkProvider.func_73149_a(x, z);
    }
}

