/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.util;

import com.mojang.blaze3d.systems.RenderSystem;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import org.lwjgl.system.MemoryUtil;

public class StreamUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readToString(InputStream is) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        ByteBuffer bytebuffer = null;
        try {
            bytebuffer = StreamUtil.readToBuffer(is);
            int i = bytebuffer.position();
            ((Buffer)bytebuffer).rewind();
            String string = MemoryUtil.memASCII((ByteBuffer)bytebuffer, (int)i);
            return string;
        }
        catch (IOException iOException) {
        }
        finally {
            if (bytebuffer != null) {
                MemoryUtil.memFree((Buffer)bytebuffer);
            }
        }
        return null;
    }

    public static ByteBuffer readToBuffer(InputStream is) throws IOException {
        ByteBuffer bytebuffer;
        if (is instanceof FileInputStream) {
            FileInputStream fileinputstream = (FileInputStream)is;
            FileChannel filechannel = fileinputstream.getChannel();
            bytebuffer = MemoryUtil.memAlloc((int)((int)filechannel.size() + 1));
            while (filechannel.read(bytebuffer) != -1) {
            }
        } else {
            bytebuffer = MemoryUtil.memAlloc((int)8192);
            ReadableByteChannel readablebytechannel = Channels.newChannel(is);
            while (readablebytechannel.read(bytebuffer) != -1) {
                if (bytebuffer.remaining() != 0) continue;
                bytebuffer = MemoryUtil.memRealloc((ByteBuffer)bytebuffer, (int)(bytebuffer.capacity() * 2));
            }
        }
        return bytebuffer;
    }
}

