/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.client.entity.model;

import com.blackgear.cavesandcliffs.common.entities.passive.axolotl.AxolotlEntity;
import com.google.common.collect.ImmutableList;
import java.util.Map;
import net.minecraft.client.renderer.entity.model.AgeableModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AxolotlModel<T extends AxolotlEntity>
extends AgeableModel<T> {
    private final ModelRenderer tail;
    private final ModelRenderer leftHindLeg;
    private final ModelRenderer rightHindLeg;
    private final ModelRenderer leftFrontLeg;
    private final ModelRenderer rightFrontLeg;
    private final ModelRenderer body;
    private final ModelRenderer head;
    private final ModelRenderer topGills;
    private final ModelRenderer leftGills;
    private final ModelRenderer rightGills;

    public AxolotlModel() {
        super(true, 8.0f, 3.35f);
        this.field_78089_u = 64;
        this.field_78090_t = 64;
        this.body = new ModelRenderer((Model)this);
        this.body.func_78793_a(0.0f, 20.0f, 5.0f);
        this.body.func_78784_a(0, 11).func_228303_a_(-4.0f, -2.0f, -9.0f, 8.0f, 4.0f, 10.0f, 0.0f, false);
        this.body.func_78784_a(2, 17).func_228303_a_(0.0f, -3.0f, -8.0f, 0.0f, 5.0f, 9.0f, 0.0f, false);
        this.head = new ModelRenderer((Model)this);
        this.head.func_78793_a(0.0f, 0.0f, -9.0f);
        this.head.func_78784_a(0, 1).func_228303_a_(-4.0f, -3.0f, -5.0f, 8.0f, 5.0f, 5.0f, 0.0f, false);
        this.topGills = new ModelRenderer((Model)this);
        this.topGills.func_78793_a(0.0f, -3.0f, -1.0f);
        this.topGills.func_78784_a(3, 37).func_228303_a_(-4.0f, -3.0f, 0.0f, 8.0f, 3.0f, 0.0f, 0.001f, false);
        this.leftGills = new ModelRenderer((Model)this);
        this.leftGills.func_78793_a(-4.0f, 0.0f, -1.0f);
        this.leftGills.func_78784_a(0, 40).func_228303_a_(-3.0f, -5.0f, 0.0f, 3.0f, 7.0f, 0.0f, 0.001f, false);
        this.rightGills = new ModelRenderer((Model)this);
        this.rightGills.func_78793_a(4.0f, 0.0f, -1.0f);
        this.rightGills.func_78784_a(11, 40).func_228303_a_(0.0f, -5.0f, 0.0f, 3.0f, 7.0f, 0.0f, 0.001f, false);
        this.rightHindLeg = new ModelRenderer((Model)this);
        this.rightHindLeg.func_78793_a(-3.5f, 1.0f, -1.0f);
        this.rightHindLeg.func_78784_a(2, 13).func_228303_a_(-1.0f, 0.0f, 0.0f, 3.0f, 5.0f, 0.0f, 0.001f, false);
        this.leftHindLeg = new ModelRenderer((Model)this);
        this.leftHindLeg.func_78793_a(3.5f, 1.0f, -1.0f);
        this.leftHindLeg.func_78784_a(2, 13).func_228303_a_(-2.0f, 0.0f, 0.0f, 3.0f, 5.0f, 0.0f, 0.001f, false);
        this.rightFrontLeg = new ModelRenderer((Model)this);
        this.rightFrontLeg.func_78793_a(-3.5f, 1.0f, -8.0f);
        this.rightFrontLeg.func_78784_a(2, 13).func_228303_a_(-1.0f, 0.0f, 0.0f, 3.0f, 5.0f, 0.0f, 0.001f, false);
        this.leftFrontLeg = new ModelRenderer((Model)this);
        this.leftFrontLeg.func_78793_a(3.5f, 1.0f, -8.0f);
        this.leftFrontLeg.func_78784_a(2, 13).func_228303_a_(-2.0f, 0.0f, 0.0f, 3.0f, 5.0f, 0.0f, 0.001f, false);
        this.tail = new ModelRenderer((Model)this);
        this.tail.func_78793_a(0.0f, 0.0f, 1.0f);
        this.tail.func_78784_a(2, 19).func_228303_a_(0.0f, -3.0f, 0.0f, 0.0f, 5.0f, 12.0f, 0.0f, false);
        this.body.func_78792_a(this.head);
        this.body.func_78792_a(this.rightHindLeg);
        this.body.func_78792_a(this.leftHindLeg);
        this.body.func_78792_a(this.rightFrontLeg);
        this.body.func_78792_a(this.leftFrontLeg);
        this.body.func_78792_a(this.tail);
        this.head.func_78792_a(this.topGills);
        this.head.func_78792_a(this.leftGills);
        this.head.func_78792_a(this.rightGills);
    }

    protected Iterable<ModelRenderer> func_225602_a_() {
        return ImmutableList.of();
    }

    protected Iterable<ModelRenderer> func_225600_b_() {
        return ImmutableList.of((Object)this.body);
    }

    public void setRotationAngles(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.resetAngles(entityIn, netHeadYaw, headPitch);
        if (((AxolotlEntity)entityIn).isPlayingDead()) {
            this.setPlayingDeadAngles(netHeadYaw);
        } else {
            boolean bl;
            boolean bl2 = bl = Entity.func_213296_b((Vector3d)entityIn.func_213322_ci()) > 1.0E-7 || ((AxolotlEntity)entityIn).field_70125_A != ((AxolotlEntity)entityIn).field_70127_C || ((AxolotlEntity)entityIn).field_70177_z != ((AxolotlEntity)entityIn).field_70126_B || ((AxolotlEntity)entityIn).field_70142_S != entityIn.func_226277_ct_() || ((AxolotlEntity)entityIn).field_70136_U != entityIn.func_226281_cx_();
            if (entityIn.func_203005_aq()) {
                if (bl) {
                    this.setMovingInWaterAngles(ageInTicks, headPitch);
                } else {
                    this.setStandingInWaterAngles(ageInTicks);
                }
            } else if (entityIn.func_233570_aj_()) {
                if (bl) {
                    this.setMovingOnGroundAngles(ageInTicks, netHeadYaw);
                } else {
                    this.setStandingOnGroundAngles(ageInTicks, netHeadYaw);
                }
            }
        }
        this.updateAnglesMap(entityIn);
    }

    private void updateAnglesMap(T axolotl) {
        Map<String, Vector3f> map = ((AxolotlEntity)axolotl).getModelAngles();
        map.put("body", this.getAngles(this.body));
        map.put("head", this.getAngles(this.head));
        map.put("right_hind_leg", this.getAngles(this.rightHindLeg));
        map.put("left_hind_leg", this.getAngles(this.leftHindLeg));
        map.put("right_front_leg", this.getAngles(this.rightFrontLeg));
        map.put("left_front_leg", this.getAngles(this.leftFrontLeg));
        map.put("tail", this.getAngles(this.tail));
        map.put("top_gills", this.getAngles(this.topGills));
        map.put("left_gills", this.getAngles(this.leftGills));
        map.put("right_gills", this.getAngles(this.rightGills));
    }

    private Vector3f getAngles(ModelRenderer modelRenderer) {
        return new Vector3f(modelRenderer.field_78795_f, modelRenderer.field_78796_g, modelRenderer.field_78808_h);
    }

    private void setAngles(ModelRenderer modelRenderer, Vector3f angles) {
        this.setAngles(modelRenderer, angles.func_195899_a(), angles.func_195900_b(), angles.func_195902_c());
    }

    public void setAngles(ModelRenderer modelRenderer, float pitch, float yaw, float roll) {
        modelRenderer.field_78795_f = pitch;
        modelRenderer.field_78796_g = yaw;
        modelRenderer.field_78808_h = roll;
    }

    private void resetAngles(T axolotl, float headYaw, float headPitch) {
        this.body.field_78800_c = 0.0f;
        this.head.field_78797_d = 0.0f;
        this.body.field_78797_d = 20.0f;
        Map<String, Vector3f> map = ((AxolotlEntity)axolotl).getModelAngles();
        if (map.isEmpty()) {
            this.setAngles(this.body, headPitch * ((float)Math.PI / 180), headYaw * ((float)Math.PI / 180), 0.0f);
            this.setAngles(this.head, 0.0f, 0.0f, 0.0f);
            this.setAngles(this.leftHindLeg, 0.0f, 0.0f, 0.0f);
            this.setAngles(this.rightHindLeg, 0.0f, 0.0f, 0.0f);
            this.setAngles(this.leftFrontLeg, 0.0f, 0.0f, 0.0f);
            this.setAngles(this.rightFrontLeg, 0.0f, 0.0f, 0.0f);
            this.setAngles(this.leftGills, 0.0f, 0.0f, 0.0f);
            this.setAngles(this.rightGills, 0.0f, 0.0f, 0.0f);
            this.setAngles(this.topGills, 0.0f, 0.0f, 0.0f);
            this.setAngles(this.tail, 0.0f, 0.0f, 0.0f);
        } else {
            this.setAngles(this.body, map.get("body"));
            this.setAngles(this.head, map.get("head"));
            this.setAngles(this.leftHindLeg, map.get("left_hind_leg"));
            this.setAngles(this.rightHindLeg, map.get("right_hind_leg"));
            this.setAngles(this.leftFrontLeg, map.get("left_front_leg"));
            this.setAngles(this.rightFrontLeg, map.get("right_front_leg"));
            this.setAngles(this.leftGills, map.get("left_gills"));
            this.setAngles(this.rightGills, map.get("right_gills"));
            this.setAngles(this.topGills, map.get("top_gills"));
            this.setAngles(this.tail, map.get("tail"));
        }
    }

    private float lerpAngleDegrees(float start, float end) {
        return this.lerpAngleDegrees(0.05f, start, end);
    }

    private float lerpAngleDegrees(float delta, float start, float end) {
        return MathHelper.func_219805_h((float)delta, (float)start, (float)end);
    }

    private void setAngle(ModelRenderer modelRenderer, float pitch, float yaw, float roll) {
        this.setAngles(modelRenderer, this.lerpAngleDegrees(modelRenderer.field_78795_f, pitch), this.lerpAngleDegrees(modelRenderer.field_78796_g, yaw), this.lerpAngleDegrees(modelRenderer.field_78808_h, roll));
    }

    private void setStandingOnGroundAngles(float ageInTicks, float netHeadYaw) {
        float g = ageInTicks * 0.09f;
        float h = MathHelper.func_76126_a((float)g);
        float i = MathHelper.func_76134_b((float)g);
        float j = h * h - 2.0f * h;
        float k = i * i - 3.0f * h;
        this.head.field_78795_f = this.lerpAngleDegrees(this.head.field_78795_f, -0.09f * j);
        this.head.field_78796_g = this.lerpAngleDegrees(this.head.field_78796_g, 0.0f);
        this.head.field_78808_h = this.lerpAngleDegrees(this.head.field_78808_h, -0.2f);
        this.tail.field_78796_g = this.lerpAngleDegrees(this.tail.field_78796_g, -0.1f + 0.1f * j);
        this.topGills.field_78795_f = this.lerpAngleDegrees(this.topGills.field_78795_f, 0.6f + 0.05f * k);
        this.leftGills.field_78796_g = this.lerpAngleDegrees(this.leftGills.field_78796_g, -this.topGills.field_78795_f);
        this.rightGills.field_78796_g = this.lerpAngleDegrees(this.rightGills.field_78796_g, -this.leftGills.field_78796_g);
        this.setAngle(this.leftHindLeg, 1.1f, 1.0f, 0.0f);
        this.setAngle(this.leftFrontLeg, 0.8f, 2.3f, -0.5f);
        this.copyLegAngles();
        this.body.field_78795_f = this.lerpAngleDegrees(0.2f, this.body.field_78795_f, 0.0f);
        this.body.field_78796_g = this.lerpAngleDegrees(this.body.field_78796_g, netHeadYaw * ((float)Math.PI / 180));
        this.body.field_78808_h = this.lerpAngleDegrees(this.body.field_78808_h, 0.0f);
    }

    private void setMovingOnGroundAngles(float ageInTicks, float netHeadYaw) {
        float g = ageInTicks * 0.11f;
        float h = MathHelper.func_76134_b((float)g);
        float i = (h * h - 2.0f * h) / 5.0f;
        float j = 0.7f * h;
        this.head.field_78795_f = this.lerpAngleDegrees(this.head.field_78795_f, 0.0f);
        this.head.field_78796_g = this.lerpAngleDegrees(this.head.field_78796_g, 0.09f * h);
        this.head.field_78808_h = this.lerpAngleDegrees(this.head.field_78808_h, 0.0f);
        this.tail.field_78796_g = this.lerpAngleDegrees(this.tail.field_78796_g, this.head.field_78796_g);
        this.topGills.field_78795_f = this.lerpAngleDegrees(this.topGills.field_78795_f, 0.6f - 0.08f * (h * h + 2.0f * MathHelper.func_76126_a((float)g)));
        this.leftGills.field_78796_g = this.lerpAngleDegrees(this.leftGills.field_78796_g, -this.topGills.field_78795_f);
        this.rightGills.field_78796_g = this.lerpAngleDegrees(this.rightGills.field_78796_g, -this.leftGills.field_78796_g);
        this.setAngle(this.leftHindLeg, 0.9424779f, 1.5f - i, -0.1f);
        this.setAngle(this.leftFrontLeg, 1.0995574f, 1.5707964f - j, 0.0f);
        this.setAngle(this.rightHindLeg, this.leftHindLeg.field_78795_f, -1.0f - i, 0.0f);
        this.setAngle(this.rightFrontLeg, this.leftFrontLeg.field_78795_f, -1.5707964f - j, 0.0f);
        this.body.field_78795_f = this.lerpAngleDegrees(0.2f, this.body.field_78795_f, 0.0f);
        this.body.field_78796_g = this.lerpAngleDegrees(this.body.field_78796_g, netHeadYaw * ((float)Math.PI / 180));
        this.body.field_78808_h = this.lerpAngleDegrees(this.body.field_78808_h, 0.0f);
    }

    private void setStandingInWaterAngles(float ageInTicks) {
        float f = ageInTicks * 0.075f;
        float g = MathHelper.func_76134_b((float)f);
        float h = MathHelper.func_76126_a((float)f) * 0.15f;
        this.body.field_78795_f = this.lerpAngleDegrees(this.body.field_78795_f, -0.15f + 0.075f * g);
        ModelRenderer body = this.body;
        body.field_78797_d -= h;
        this.head.field_78795_f = this.lerpAngleDegrees(this.head.field_78795_f, -this.body.field_78795_f);
        this.topGills.field_78795_f = this.lerpAngleDegrees(this.topGills.field_78795_f, 0.2f * g);
        this.leftGills.field_78796_g = this.lerpAngleDegrees(this.leftGills.field_78796_g, -0.3f * g - 0.19f);
        this.rightGills.field_78796_g = this.lerpAngleDegrees(this.rightGills.field_78796_g, -this.leftGills.field_78796_g);
        this.setAngles(this.leftHindLeg, 2.3561945f - g * 0.11f, 0.47123894f, 1.7278761f);
        this.setAngles(this.leftFrontLeg, 0.7853982f - g * 0.2f, 2.042035f, 0.0f);
        this.copyLegAngles();
        this.tail.field_78796_g = this.lerpAngleDegrees(this.tail.field_78796_g, 0.5f * g);
        this.head.field_78796_g = this.lerpAngleDegrees(this.head.field_78796_g, 0.0f);
        this.head.field_78808_h = this.lerpAngleDegrees(this.head.field_78808_h, 0.0f);
    }

    private void setMovingInWaterAngles(float ageInTicks, float headPitch) {
        float f = ageInTicks * 0.33f;
        float g = MathHelper.func_76126_a((float)f);
        float h = MathHelper.func_76134_b((float)f);
        float i = 0.13f * g;
        this.body.field_78795_f = this.lerpAngleDegrees(0.1f, this.body.field_78795_f, headPitch * ((float)Math.PI / 180) + i);
        this.head.field_78795_f = -i * 1.8f;
        ModelRenderer body = this.body;
        body.field_78797_d -= 0.45f * h;
        this.topGills.field_78795_f = this.lerpAngleDegrees(this.topGills.field_78795_f, -0.5f * g - 0.8f);
        this.leftGills.field_78796_g = this.lerpAngleDegrees(this.leftGills.field_78796_g, 0.3f * g + 0.9f);
        this.rightGills.field_78796_g = this.lerpAngleDegrees(this.rightGills.field_78796_g, -this.leftGills.field_78796_g);
        this.tail.field_78796_g = this.lerpAngleDegrees(this.tail.field_78796_g, 0.3f * MathHelper.func_76134_b((float)(f * 0.9f)));
        this.setAngle(this.leftHindLeg, 1.8849558f, -0.4f * g, 1.5707964f);
        this.setAngle(this.leftFrontLeg, 1.8849558f, -0.2f * h - 0.1f, 1.5707964f);
        this.copyLegAngles();
        this.head.field_78796_g = this.lerpAngleDegrees(this.head.field_78796_g, 0.0f);
        this.head.field_78808_h = this.lerpAngleDegrees(this.head.field_78808_h, 0.0f);
    }

    private void setPlayingDeadAngles(float netHeadYaw) {
        this.setAngle(this.leftHindLeg, 1.4137167f, 1.0995574f, 0.7853982f);
        this.setAngle(this.leftFrontLeg, 0.7853982f, 2.042035f, 0.0f);
        this.body.field_78795_f = this.lerpAngleDegrees(this.body.field_78795_f, -0.15f);
        this.body.field_78808_h = this.lerpAngleDegrees(this.body.field_78808_h, 0.35f);
        this.copyLegAngles();
        this.body.field_78796_g = this.lerpAngleDegrees(this.body.field_78796_g, netHeadYaw * ((float)Math.PI / 180));
        this.head.field_78795_f = this.lerpAngleDegrees(this.head.field_78795_f, 0.0f);
        this.head.field_78796_g = this.lerpAngleDegrees(this.head.field_78796_g, 0.0f);
        this.head.field_78808_h = this.lerpAngleDegrees(this.head.field_78808_h, 0.0f);
        this.tail.field_78796_g = this.lerpAngleDegrees(this.tail.field_78796_g, 0.0f);
        this.setAngle(this.topGills, 0.0f, 0.0f, 0.0f);
        this.setAngle(this.leftGills, 0.0f, 0.0f, 0.0f);
        this.setAngle(this.rightGills, 0.0f, 0.0f, 0.0f);
    }

    private void copyLegAngles() {
        this.setAngles(this.rightHindLeg, this.leftHindLeg.field_78795_f, -this.leftHindLeg.field_78796_g, -this.leftHindLeg.field_78808_h);
        this.setAngles(this.rightFrontLeg, this.leftFrontLeg.field_78795_f, -this.leftFrontLeg.field_78796_g, -this.leftFrontLeg.field_78808_h);
    }
}

