/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.blocks;

import com.blackgear.cavesandcliffs.core.registries.CCBParticleTypes;
import com.blackgear.cavesandcliffs.core.registries.CCBSoundEvents;
import com.blackgear.cavesandcliffs.core.registries.api.client.CCBSoundTypes;
import com.blackgear.cavesandcliffs.core.registries.other.tags.CCBBlockTags;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public abstract class AbstractCandleBlock
extends Block {
    public static final BooleanProperty LIT = BlockStateProperties.field_208190_q;

    public AbstractCandleBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    protected abstract Iterable<Vector3d> getParticleOffsets(BlockState var1);

    public static boolean isLitCandle(BlockState state) {
        return state.func_235901_b_((Property)LIT) && (state.func_235714_a_(CCBBlockTags.CANDLES) || state.func_235714_a_(CCBBlockTags.CANDLE_CAKES)) && (Boolean)state.func_177229_b((Property)LIT) != false;
    }

    public void func_220066_a(World worldIn, BlockState state, BlockRayTraceResult hit, ProjectileEntity projectile) {
        if (!worldIn.field_72995_K && projectile.func_70027_ad() && this.isNotLit(state)) {
            AbstractCandleBlock.setLit((IWorld)worldIn, state, hit.func_216350_a(), true);
        }
    }

    protected boolean isNotLit(BlockState state) {
        return (Boolean)state.func_177229_b((Property)LIT) == false;
    }

    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (((Boolean)stateIn.func_177229_b((Property)LIT)).booleanValue()) {
            this.getParticleOffsets(stateIn).forEach(offset -> AbstractCandleBlock.spawnCandleParticles(worldIn, offset.func_72441_c((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()), rand));
        }
    }

    private static void spawnCandleParticles(World worldIn, Vector3d vec3d, Random random) {
        float rand = random.nextFloat();
        if (rand < 0.3f) {
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 0.0, 0.0, 0.0);
            if (rand < 0.17f) {
                worldIn.func_184134_a(vec3d.field_72450_a + 0.5, vec3d.field_72448_b + 0.5, vec3d.field_72449_c + 0.5, (SoundEvent)CCBSoundEvents.BLOCK_CANDLE_AMBIENT.get(), SoundCategory.BLOCKS, 1.0f + random.nextFloat(), random.nextFloat() * 0.7f + 0.3f, false);
            }
        }
        worldIn.func_195594_a((IParticleData)CCBParticleTypes.SMALL_FLAME.get(), vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 0.0, 0.0, 0.0);
    }

    public static void extinguish(BlockState state, IWorld worldIn, BlockPos pos) {
        AbstractCandleBlock.setLit(worldIn, state, pos, false);
        if (state.func_177230_c() instanceof AbstractCandleBlock) {
            ((AbstractCandleBlock)state.func_177230_c()).getParticleOffsets(state).forEach(offset -> worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, (double)pos.func_177958_n() + offset.func_82615_a(), (double)pos.func_177956_o() + offset.func_82617_b(), (double)pos.func_177952_p() + offset.func_82616_c(), 0.0, (double)0.1f, 0.0));
        }
        worldIn.func_184133_a(null, pos, (SoundEvent)CCBSoundEvents.BLOCK_CANDLE_EXTINGUISH.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    private static void setLit(IWorld worldIn, BlockState state, BlockPos pos, boolean lit) {
        worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(lit)), 11);
    }

    public SoundType func_220072_p(BlockState state) {
        return CCBSoundTypes.CANDLE;
    }
}

