/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.blocks;

import com.blackgear.cavesandcliffs.common.blocks.AbstractCandleBlock;
import com.blackgear.cavesandcliffs.common.blocks.CCBCakeBlock;
import com.blackgear.cavesandcliffs.core.registries.CCBBlocks;
import com.blackgear.cavesandcliffs.core.registries.other.tags.CCBBlockTags;
import com.blackgear.cavesandcliffs.core.registries.other.utils.BlockUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class CandleCakeBlock
extends AbstractCandleBlock {
    public static final BooleanProperty LIT = AbstractCandleBlock.LIT;
    protected static final VoxelShape CAKE_SHAPE = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0);
    protected static final VoxelShape CANDLE_SHAPE = Block.func_208617_a((double)7.0, (double)8.0, (double)7.0, (double)9.0, (double)14.0, (double)9.0);
    protected static final VoxelShape SHAPE = VoxelShapes.func_197872_a((VoxelShape)CAKE_SHAPE, (VoxelShape)CANDLE_SHAPE);
    private static final Map<Block, Block> CANDLES_TO_CANDLE_CAKES = Maps.newHashMap();
    private static final Iterable<Vector3d> PARTICLE_OFFSETS = ImmutableList.of((Object)new Vector3d(0.5, 1.0, 0.5));

    public CandleCakeBlock(Supplier<Block> candle, AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(false)));
        CANDLES_TO_CANDLE_CAKES.put(candle.get(), this);
    }

    @Override
    protected Iterable<Vector3d> getParticleOffsets(BlockState state) {
        return PARTICLE_OFFSETS;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack stack = player.func_184586_b(handIn);
        if (!stack.func_77973_b().equals(Items.field_151033_d) && !stack.func_77973_b().equals(Items.field_151059_bz)) {
            if (this.isHittingCandle(hit) && player.func_184586_b(handIn).func_190926_b() && ((Boolean)state.func_177229_b((Property)LIT)).booleanValue()) {
                CandleCakeBlock.extinguish(state, (IWorld)worldIn, pos);
                return ActionResultType.SUCCESS;
            }
            ActionResultType resultType = CCBCakeBlock.tryEat((IWorld)worldIn, pos, Blocks.field_150414_aQ.func_176223_P(), player);
            if (resultType.func_226246_a_()) {
                CandleCakeBlock.func_220075_c((BlockState)state, (World)worldIn, (BlockPos)pos);
            }
            return resultType;
        }
        return ActionResultType.PASS;
    }

    private boolean isHittingCandle(BlockRayTraceResult hitResult) {
        return hitResult.func_216347_e().field_72448_b - (double)hitResult.func_216350_a().func_177956_o() > 0.5;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{LIT});
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return new ItemStack((IItemProvider)Blocks.field_150414_aQ);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return facing == Direction.DOWN && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_185904_a().func_76220_a();
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        return CCBCakeBlock.DEFAULT_COMPARATOR_OUTPUT;
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    public static BlockState byCandle(Block candle) {
        return CANDLES_TO_CANDLE_CAKES.get(candle).func_176223_P();
    }

    public static boolean canBeLit(BlockState state) {
        return BlockUtils.isIn(state, CCBBlockTags.CANDLE_CAKES, statex -> statex.func_235901_b_((Property)LIT) && (Boolean)statex.func_177229_b((Property)LIT) == false);
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        return CCBBlocks.getLightValueLit(3).applyAsInt(state);
    }
}

