/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.blocks;

import java.util.Iterator;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.server.ServerWorld;

public interface Degradable<T extends Enum<T>> {
    public Optional<BlockState> getDegradationResult(BlockState var1);

    public float getDegradationChanceMultiplier();

    default public void tickDegradation(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        if (rand.nextFloat() < 0.05688889f) {
            this.tryDegrade(state, worldIn, pos, rand);
        }
    }

    public T getDegradationLevel();

    default public void tryDegrade(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        BlockPos withinRange;
        int distance;
        int degradationTicks = ((Enum)this.getDegradationLevel()).ordinal();
        int minAge = 0;
        int maxAge = 0;
        Iterator iterator = BlockPos.func_239583_a_((BlockPos)pos, (int)4, (int)4, (int)4).iterator();
        while (iterator.hasNext() && (distance = (withinRange = (BlockPos)iterator.next()).func_218139_n((Vector3i)pos)) <= 4) {
            BlockState blockState;
            Block block;
            if (withinRange.equals((Object)pos) || !((block = (blockState = worldIn.func_180495_p(withinRange)).func_177230_c()) instanceof Degradable)) continue;
            T enumState = ((Degradable)block).getDegradationLevel();
            if (this.getDegradationLevel().getClass() != enumState.getClass()) continue;
            int stateTicks = ((Enum)enumState).ordinal();
            if (stateTicks < degradationTicks) {
                return;
            }
            if (stateTicks > degradationTicks) {
                ++maxAge;
                continue;
            }
            ++minAge;
        }
        float ticks = (float)(maxAge + 1) / (float)(maxAge + minAge + 1);
        float chance = ticks * ticks * this.getDegradationChanceMultiplier();
        if (rand.nextFloat() < chance) {
            this.getDegradationResult(state).ifPresent(stateIn -> worldIn.func_175656_a(pos, stateIn));
        }
    }
}

