/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.blocks;

import com.blackgear.cavesandcliffs.common.blocks.Degradable;
import com.blackgear.cavesandcliffs.core.registries.CCBBlocks;
import com.blackgear.cavesandcliffs.core.registries.other.utils.BlockUtils;
import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;

public interface Oxidizable
extends Degradable<OxidizationLevel> {
    public static final Supplier<BiMap<Block, Block>> OXIDATION_LEVEL_INCREASES = Suppliers.memoize(() -> new ImmutableBiMap.Builder().put((Object)CCBBlocks.COPPER_BLOCK.get(), (Object)CCBBlocks.EXPOSED_COPPER.get()).put((Object)CCBBlocks.EXPOSED_COPPER.get(), (Object)CCBBlocks.WEATHERED_COPPER.get()).put((Object)CCBBlocks.WEATHERED_COPPER.get(), (Object)CCBBlocks.OXIDIZED_COPPER.get()).put((Object)CCBBlocks.CUT_COPPER.get(), (Object)CCBBlocks.EXPOSED_CUT_COPPER.get()).put((Object)CCBBlocks.EXPOSED_CUT_COPPER.get(), (Object)CCBBlocks.WEATHERED_CUT_COPPER.get()).put((Object)CCBBlocks.WEATHERED_CUT_COPPER.get(), (Object)CCBBlocks.OXIDIZED_CUT_COPPER.get()).put((Object)CCBBlocks.CUT_COPPER_SLAB.get(), (Object)CCBBlocks.EXPOSED_CUT_COPPER_SLAB.get()).put((Object)CCBBlocks.EXPOSED_CUT_COPPER_SLAB.get(), (Object)CCBBlocks.WEATHERED_CUT_COPPER_SLAB.get()).put((Object)CCBBlocks.WEATHERED_CUT_COPPER_SLAB.get(), (Object)CCBBlocks.OXIDIZED_CUT_COPPER_SLAB.get()).put((Object)CCBBlocks.CUT_COPPER_STAIRS.get(), (Object)CCBBlocks.EXPOSED_CUT_COPPER_STAIRS.get()).put((Object)CCBBlocks.EXPOSED_CUT_COPPER_STAIRS.get(), (Object)CCBBlocks.WEATHERED_CUT_COPPER_STAIRS.get()).put((Object)CCBBlocks.WEATHERED_CUT_COPPER_STAIRS.get(), (Object)CCBBlocks.OXIDIZED_CUT_COPPER_STAIRS.get()).build());
    public static final Supplier<BiMap<Block, Block>> OXIDATION_LEVEL_DECREASES = Suppliers.memoize(() -> OXIDATION_LEVEL_INCREASES.get().inverse());

    public static Optional<Block> getDecreasedOxidationState(Block blockIn) {
        return Optional.ofNullable(OXIDATION_LEVEL_DECREASES.get().get((Object)blockIn));
    }

    public static Block getUnaffectedOxidationBlock(Block blockIn) {
        Block block = blockIn;
        Block previousBlock = (Block)OXIDATION_LEVEL_DECREASES.get().get((Object)blockIn);
        while (previousBlock != null) {
            block = previousBlock;
            previousBlock = (Block)OXIDATION_LEVEL_DECREASES.get().get((Object)previousBlock);
        }
        return block;
    }

    public static Optional<BlockState> getDecreasedOxidationState(BlockState state) {
        return Oxidizable.getDecreasedOxidationState(state.func_177230_c()).map(block -> BlockUtils.getStateWithProperties(block, state));
    }

    public static Optional<Block> getIncreasedOxidationBlock(Block blockIn) {
        return Optional.ofNullable(OXIDATION_LEVEL_INCREASES.get().get((Object)blockIn));
    }

    public static BlockState getUnaffectedOxidationState(BlockState state) {
        return BlockUtils.getStateWithProperties(Oxidizable.getUnaffectedOxidationBlock(state.func_177230_c()), state);
    }

    @Override
    default public Optional<BlockState> getDegradationResult(BlockState state) {
        return Oxidizable.getIncreasedOxidationBlock(state.func_177230_c()).map(block -> BlockUtils.getStateWithProperties(block, state));
    }

    @Override
    default public float getDegradationChanceMultiplier() {
        return this.getDegradationLevel() == OxidizationLevel.UNAFFECTED ? 0.75f : 1.0f;
    }

    public static enum OxidizationLevel {
        UNAFFECTED,
        EXPOSED,
        WEATHERED,
        OXIDIZED;

    }
}

