/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.blocks;

import com.blackgear.cavesandcliffs.common.blocks.IBucketPickable;
import com.blackgear.cavesandcliffs.core.registries.CCBBlocks;
import com.blackgear.cavesandcliffs.core.registries.CCBItems;
import com.blackgear.cavesandcliffs.core.registries.api.client.CCBSoundTypes;
import com.blackgear.cavesandcliffs.core.registries.other.tags.CCBEntityTags;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.EntitySelectionContext;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class PowderSnowBlock
extends Block
implements IBucketPickable {
    private static final VoxelShape FALLING_COLLISION_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.9f, (double)1.0);

    public PowderSnowBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    public boolean func_200122_a(BlockState state, BlockState adjacentBlockState, Direction side) {
        return adjacentBlockState.func_203425_a((Block)this) || super.func_200122_a(state, adjacentBlockState, side);
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return VoxelShapes.func_197880_a();
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (!(entityIn instanceof LivingEntity) || ((LivingEntity)entityIn).func_213339_cH().func_203425_a((Block)CCBBlocks.POWDER_SNOW.get())) {
            entityIn.func_213295_a(state, new Vector3d((double)0.9f, 1.5, (double)0.9f));
        }
        if (entityIn.func_70027_ad()) {
            worldIn.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
        if (worldIn.field_72995_K) {
            entityIn.func_70066_B();
        } else {
            entityIn.func_70052_a(0, false);
        }
        if (!entityIn.func_175149_v() && (entityIn.field_70169_q != entityIn.func_226277_ct_() || entityIn.field_70166_s != entityIn.func_226281_cx_()) && worldIn.field_73012_v.nextBoolean()) {
            this.spawnPowderSnowParticles(worldIn, new Vector3d(entityIn.func_226277_ct_(), (double)pos.func_177956_o(), entityIn.func_226281_cx_()));
        }
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        EntitySelectionContext collision;
        Optional<Entity> fallingEntity;
        if (context instanceof EntitySelectionContext && (fallingEntity = Optional.ofNullable((collision = (EntitySelectionContext)context).getEntity())).isPresent()) {
            Entity entity = fallingEntity.get();
            if (entity.field_70143_R > 2.5f) {
                return FALLING_COLLISION_SHAPE;
            }
            boolean isFallingBlock = entity instanceof FallingBlockEntity;
            if (isFallingBlock || this.canEntityWalkOnPowderSnow(fallingEntity.get()) && context.func_216378_a(VoxelShapes.func_197868_b(), pos, false) && !context.func_225581_b_()) {
                return super.func_220071_b(state, worldIn, pos, context);
            }
        }
        return VoxelShapes.func_197880_a();
    }

    public VoxelShape func_230322_a_(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197880_a();
    }

    private void spawnPowderSnowParticles(World worldIn, Vector3d pos) {
        if (worldIn.field_72995_K) {
            Random rand = worldIn.func_201674_k();
            double getY = pos.field_72448_b + 1.0;
            for (int i = 0; i < rand.nextInt(3); ++i) {
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197613_f, pos.field_72450_a, getY, pos.field_72449_c, (double)((-1.0f + rand.nextFloat() * 2.0f) / 12.0f), (double)0.05f, (double)((-1.0f + rand.nextFloat() * 2.0f) / 12.0f));
            }
        }
    }

    private boolean canEntityWalkOnPowderSnow(Entity entityIn) {
        if (entityIn.func_200600_R().func_220341_a(CCBEntityTags.POWDER_SNOW_WALKABLE_MOBS)) {
            return true;
        }
        return entityIn instanceof LivingEntity && ((LivingEntity)entityIn).func_184582_a(EquipmentSlotType.FEET).func_77973_b() == Items.field_151021_T;
    }

    @Override
    public ItemStack pickupBlock(IWorld worldIn, BlockPos pos, BlockState state) {
        worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 11);
        if (!worldIn.func_201670_d()) {
            worldIn.func_217379_c(2001, pos, Block.func_196246_j((BlockState)state));
        }
        return new ItemStack((IItemProvider)CCBItems.POWDER_SNOW_BUCKET.get());
    }

    @Override
    public Optional<SoundEvent> getPickupSound() {
        return Optional.of(SoundEvents.field_187630_M);
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return true;
    }

    public SoundType func_220072_p(BlockState state) {
        return CCBSoundTypes.POWDER_SNOW;
    }
}

