/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.data.loot;

import com.blackgear.cavesandcliffs.core.CavesAndCliffsConfig;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;

public class RawOreLootModifier
extends LootModifier {
    public RawOreLootModifier(ILootCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        if (((Boolean)CavesAndCliffsConfig.dropRawOres.get()).booleanValue()) {
            Random random = new Random();
            ItemStack ctxTool = (ItemStack)context.func_216031_c(LootParameters.field_216289_i);
            if (generatedLoot.size() == 0) {
                return generatedLoot;
            }
            ArrayList<ItemStack> returnable = this.checkLoot(generatedLoot);
            if (generatedLoot.get(0).func_77973_b() == returnable.get(0).func_77973_b() || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)ctxTool) != 0) {
                return generatedLoot;
            }
            int enchantmentLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)ctxTool);
            ArrayList<ItemStack> rawOre = new ArrayList<ItemStack>();
            int size = RawOreLootModifier.generatedSize(generatedLoot);
            rawOre.add(new ItemStack((IItemProvider)returnable.get(0).func_77973_b(), size + random.nextInt(1 + enchantmentLevel)));
            return rawOre;
        }
        return generatedLoot;
    }

    private static int generatedSize(List<ItemStack> generatedLoot) {
        Item ore = generatedLoot.get(0).func_77973_b();
        int size = ore.getTags().contains(new ResourceLocation("forge", "ores/copper")) ? MathHelper.func_76136_a((Random)new Random(), (int)2, (int)3) : generatedLoot.size();
        return size;
    }

    private static ArrayList<ItemStack> getRawOre(String ore) {
        ArrayList<ItemStack> returnable = new ArrayList<ItemStack>();
        Item rawOre = RawOreLootModifier.getRawOreItem(ore);
        returnable.add(new ItemStack((IItemProvider)rawOre));
        return returnable;
    }

    private ArrayList<ItemStack> checkLoot(List<ItemStack> generatedLoot) {
        Item rawOre = generatedLoot.get(0).func_77973_b();
        if (rawOre.getTags().contains(new ResourceLocation("forge", "ores/iron"))) {
            return RawOreLootModifier.getRawOre("iron");
        }
        if (rawOre.getTags().contains(new ResourceLocation("forge", "ores/gold"))) {
            return RawOreLootModifier.getRawOre("gold");
        }
        if (rawOre.getTags().contains(new ResourceLocation("forge", "ores/copper"))) {
            return RawOreLootModifier.getRawOre("copper");
        }
        return (ArrayList)generatedLoot;
    }

    private static Item getRawOreItem(String ore) {
        return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("cavesandcliffs", "raw_" + ore));
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<RawOreLootModifier> {
        public RawOreLootModifier read(ResourceLocation location, JsonObject object, ILootCondition[] conditions) {
            return new RawOreLootModifier(conditions);
        }

        public JsonObject write(RawOreLootModifier instance) {
            return new JsonObject();
        }
    }
}

