/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.entities.passive.ai.brain.sensor;

import com.blackgear.cavesandcliffs.core.registries.CCBAI;
import com.google.common.collect.ImmutableSet;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.sensor.Sensor;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.EntityPredicates;
import net.minecraft.world.server.ServerWorld;

public class TemptationsSensor
extends Sensor<LivingEntity> {
    private static final EntityPredicate TEMPT_TARGETING = new EntityPredicate().func_221013_a(10.0).func_221014_c();
    private final Ingredient temptations;

    public TemptationsSensor(Ingredient temptations) {
        this.temptations = temptations;
    }

    protected void func_212872_a_(ServerWorld worldIn, LivingEntity entityIn) {
        Brain brain = entityIn.func_213375_cj();
        Stream<ServerPlayerEntity> nearbyTargetablePlayers = worldIn.func_217369_A().stream().filter(EntityPredicates.field_180132_d).filter(player -> TEMPT_TARGETING.func_221015_a(entityIn, (LivingEntity)player)).filter(player -> entityIn.func_233562_a_((Entity)player, 10.0)).filter(this::playerHoldingTemptation);
        List nearbyPlayers = nearbyTargetablePlayers.sorted(Comparator.comparingDouble(arg_0 -> ((LivingEntity)entityIn).func_70068_e(arg_0))).collect(Collectors.toList());
        if (!nearbyPlayers.isEmpty()) {
            PlayerEntity player2 = (PlayerEntity)nearbyPlayers.get(0);
            brain.func_218205_a((MemoryModuleType)CCBAI.TEMPTING_PLAYER.get(), (Object)player2);
        } else {
            brain.func_218189_b((MemoryModuleType)CCBAI.TEMPTING_PLAYER.get());
        }
    }

    private boolean playerHoldingTemptation(PlayerEntity player) {
        return this.isTemptation(player.func_184614_ca()) || this.isTemptation(player.func_184592_cb());
    }

    private boolean isTemptation(ItemStack stack) {
        return this.temptations.test(stack);
    }

    public Set<MemoryModuleType<?>> func_220974_a() {
        return ImmutableSet.of((Object)CCBAI.TEMPTING_PLAYER.get());
    }
}

