/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.entities.passive.ai.task;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.util.EntityPredicates;
import net.minecraft.world.server.ServerWorld;

public class ForgetAttackTargetTask<E extends MobEntity>
extends Task<E> {
    private final Predicate<LivingEntity> alternativeCondition;
    private final Consumer<E> forgetCallback;

    public ForgetAttackTargetTask(Predicate<LivingEntity> condition, Consumer<E> forgetCallback) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.field_234103_o_, (Object)MemoryModuleStatus.VALUE_PRESENT, (Object)MemoryModuleType.field_223021_x, (Object)MemoryModuleStatus.REGISTERED));
        this.alternativeCondition = condition;
        this.forgetCallback = forgetCallback;
    }

    public ForgetAttackTargetTask(Predicate<LivingEntity> alternativeCondition) {
        this(alternativeCondition, mob -> {});
    }

    public ForgetAttackTargetTask(Consumer<E> forgetCallback) {
        this(livingEntity -> false, forgetCallback);
    }

    public ForgetAttackTargetTask() {
        this(livingEntity -> false, mob -> {});
    }

    protected void startExecuting(ServerWorld worldIn, E entityIn, long gameTimeIn) {
        if (ForgetAttackTargetTask.cannotReachTarget(entityIn)) {
            this.forgetAttackTarget(entityIn);
        } else if (this.isAttackTargetDead(entityIn)) {
            this.forgetAttackTarget(entityIn);
        } else if (this.isAttackTargetInAnotherWorld(entityIn)) {
            this.forgetAttackTarget(entityIn);
        } else if (!EntityPredicates.field_233583_f_.test(this.getAttackTarget(entityIn))) {
            this.forgetAttackTarget(entityIn);
        } else if (this.alternativeCondition.test(this.getAttackTarget(entityIn))) {
            this.forgetAttackTarget(entityIn);
        }
    }

    private boolean isAttackTargetInAnotherWorld(E entity) {
        return this.getAttackTarget(entity).field_70170_p != ((MobEntity)entity).field_70170_p;
    }

    private LivingEntity getAttackTarget(E entity) {
        return (LivingEntity)entity.func_213375_cj().func_218207_c(MemoryModuleType.field_234103_o_).get();
    }

    private static <E extends LivingEntity> boolean cannotReachTarget(E entity) {
        Optional optional = entity.func_213375_cj().func_218207_c(MemoryModuleType.field_223021_x);
        return optional.isPresent() && entity.field_70170_p.func_82737_E() - (Long)optional.get() > 200L;
    }

    private boolean isAttackTargetDead(E entity) {
        Optional optional = entity.func_213375_cj().func_218207_c(MemoryModuleType.field_234103_o_);
        return optional.isPresent() && !((LivingEntity)optional.get()).func_70089_S();
    }

    private void forgetAttackTarget(E entity) {
        this.forgetCallback.accept(entity);
        entity.func_213375_cj().func_218189_b(MemoryModuleType.field_234103_o_);
    }
}

