/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.entities.passive.ai.task;

import com.blackgear.cavesandcliffs.core.registries.CCBAI;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.memory.WalkTarget;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityPosWrapper;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.server.ServerWorld;

public class PrepareRamNearestTargetTask<E extends CreatureEntity>
extends Task<E> {
    private final int cooldownOnFail;
    private final int minRamDistance;
    private final int maxRamDistance;
    private final float walkSpeed;
    private final EntityPredicate ramTargeting;
    private final int ramPrepareTime;
    private final Function<E, SoundEvent> getPrepareRamSound;
    private Optional<Long> reachedRamPositionTimestamp = Optional.empty();
    private Optional<RamCandidate> ramCandidate = Optional.empty();

    public PrepareRamNearestTargetTask(int cooldownOnFail, int minRamDistance, int maxRamDistance, float walkSpeed, EntityPredicate ramTargeting, int ramPrepareTime, Function<E, SoundEvent> getPrepareRamSound) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.field_220951_l, (Object)MemoryModuleStatus.REGISTERED, (Object)CCBAI.RAM_COOLDOWN_TICKS.get(), (Object)MemoryModuleStatus.VALUE_ABSENT, (Object)MemoryModuleType.field_220946_g, (Object)MemoryModuleStatus.VALUE_PRESENT, (Object)CCBAI.RAM_TARGET.get(), (Object)MemoryModuleStatus.VALUE_ABSENT), 160);
        this.cooldownOnFail = cooldownOnFail;
        this.minRamDistance = minRamDistance;
        this.maxRamDistance = maxRamDistance;
        this.walkSpeed = walkSpeed;
        this.ramTargeting = ramTargeting;
        this.ramPrepareTime = ramPrepareTime;
        this.getPrepareRamSound = getPrepareRamSound;
    }

    protected void startExecuting(ServerWorld worldIn, E entityIn, long gameTimeIn) {
        Brain brain = entityIn.func_213375_cj();
        brain.func_218207_c(MemoryModuleType.field_220946_g).flatMap(entities -> entities.stream().filter(visible -> this.ramTargeting.func_221015_a((LivingEntity)entityIn, visible)).findFirst()).ifPresent(entity -> this.chooseRamPosition((CreatureEntity)entityIn, (LivingEntity)entity));
    }

    protected void resetTask(ServerWorld worldIn, E entityIn, long gameTimeIn) {
        Brain brain = entityIn.func_213375_cj();
        if (!brain.func_218191_a((MemoryModuleType)CCBAI.RAM_TARGET.get())) {
            worldIn.func_72960_a(entityIn, (byte)59);
            brain.func_218205_a((MemoryModuleType)CCBAI.RAM_COOLDOWN_TICKS.get(), (Object)this.cooldownOnFail);
        }
    }

    protected boolean shouldContinueExecuting(ServerWorld worldIn, E entityIn, long gameTimeIn) {
        return this.ramCandidate.isPresent() && this.ramCandidate.get().getTarget().func_70089_S();
    }

    protected void updateTask(ServerWorld worldIn, E entityIn, long gameTime) {
        if (this.ramCandidate.isPresent()) {
            boolean isTargeting;
            entityIn.func_213375_cj().func_218205_a(MemoryModuleType.field_220950_k, (Object)new WalkTarget(this.ramCandidate.get().getStartPosition(), this.walkSpeed, 0));
            entityIn.func_213375_cj().func_218205_a(MemoryModuleType.field_220951_l, (Object)new EntityPosWrapper((Entity)this.ramCandidate.get().getTarget(), true));
            boolean bl = isTargeting = !this.ramCandidate.get().getTarget().func_233580_cy_().equals((Object)this.ramCandidate.get().getTargetPosition());
            if (isTargeting) {
                worldIn.func_72960_a(entityIn, (byte)59);
                entityIn.func_70661_as().func_75500_f();
                this.chooseRamPosition((CreatureEntity)entityIn, this.ramCandidate.get().target);
            } else {
                BlockPos pos = entityIn.func_233580_cy_();
                if (pos.equals((Object)this.ramCandidate.get().getStartPosition())) {
                    worldIn.func_72960_a(entityIn, (byte)58);
                    if (!this.reachedRamPositionTimestamp.isPresent()) {
                        this.reachedRamPositionTimestamp = Optional.of(gameTime);
                    }
                    if (gameTime - this.reachedRamPositionTimestamp.get() >= (long)this.ramPrepareTime) {
                        entityIn.func_213375_cj().func_218205_a((MemoryModuleType)CCBAI.RAM_TARGET.get(), (Object)this.getEdgeOfBlock(pos, this.ramCandidate.get().getTargetPosition()));
                        worldIn.func_217384_a(null, entityIn, this.getPrepareRamSound.apply(entityIn), SoundCategory.HOSTILE, 1.0f, 1.0f);
                        this.ramCandidate = Optional.empty();
                    }
                }
            }
        }
    }

    private Vector3d getEdgeOfBlock(BlockPos fromPos, BlockPos toPos) {
        double x = 0.5 * (double)MathHelper.func_219802_k((double)(fromPos.func_177958_n() - toPos.func_177958_n()));
        double z = 0.5 * (double)MathHelper.func_219802_k((double)(fromPos.func_177952_p() - toPos.func_177952_p()));
        return Vector3d.func_237492_c_((Vector3i)toPos).func_72441_c(x, 0.0, z);
    }

    private Optional<BlockPos> calculateRamminStartPosition(CreatureEntity creature, LivingEntity entityIn) {
        BlockPos pos = entityIn.func_233580_cy_();
        if (!this.isWalkableBlock(creature, pos)) {
            return Optional.empty();
        }
        ArrayList positions = Lists.newArrayList();
        BlockPos.Mutable mutable = pos.func_239590_i_();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            mutable.func_189533_g((Vector3i)pos);
            for (int distance = 0; distance < this.maxRamDistance; ++distance) {
                if (this.isWalkableBlock(creature, (BlockPos)mutable.func_189536_c(direction))) continue;
                mutable.func_189536_c(direction.func_176734_d());
                break;
            }
            if (mutable.func_218139_n((Vector3i)pos) < this.minRamDistance) continue;
            positions.add(mutable.func_185334_h());
        }
        PathNavigator navigator = creature.func_70661_as();
        Stream validPositions = positions.stream();
        BlockPos entityPos = creature.func_233580_cy_();
        return validPositions.sorted(Comparator.comparingDouble(arg_0 -> ((BlockPos)entityPos).func_177951_i(arg_0))).filter(blockPos -> {
            Path path = navigator.func_179680_a(blockPos, 0);
            return path != null && path.func_224771_h();
        }).findFirst();
    }

    private boolean isWalkableBlock(CreatureEntity entityIn, BlockPos pos) {
        return entityIn.func_70661_as().func_188555_b(pos) && entityIn.func_184643_a(WalkNodeProcessor.func_237231_a_((IBlockReader)entityIn.field_70170_p, (BlockPos.Mutable)pos.func_239590_i_())) == 0.0f;
    }

    private void chooseRamPosition(CreatureEntity creature, LivingEntity entityIn) {
        this.reachedRamPositionTimestamp = Optional.empty();
        this.ramCandidate = this.calculateRamminStartPosition(creature, entityIn).map(pos -> new RamCandidate((BlockPos)pos, entityIn.func_233580_cy_(), entityIn));
    }

    public static class RamCandidate {
        private final BlockPos startPosition;
        private final BlockPos targetPosition;
        private final LivingEntity target;

        public RamCandidate(BlockPos startPosition, BlockPos targetPosition, LivingEntity target) {
            this.startPosition = startPosition;
            this.targetPosition = targetPosition;
            this.target = target;
        }

        public BlockPos getStartPosition() {
            return this.startPosition;
        }

        public BlockPos getTargetPosition() {
            return this.targetPosition;
        }

        public LivingEntity getTarget() {
            return this.target;
        }
    }
}

