/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.entities.passive.ai.task;

import com.blackgear.cavesandcliffs.core.registries.CCBAI;
import com.blackgear.cavesandcliffs.core.registries.other.utils.EntityUtils;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.memory.WalkTarget;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.util.DamageSource;
import net.minecraft.util.RangedInteger;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.server.ServerWorld;

public class RamTargetTask<E extends CreatureEntity>
extends Task<E> {
    private final Function<E, RangedInteger> timeBetweenRams;
    private final EntityPredicate targeting;
    private final ToIntFunction<E> getDamage;
    private final float speed;
    private final ToDoubleFunction<E> getKnockbackForce;
    private Vector3d ramDirection;
    private final Function<E, SoundEvent> getImpactSound;

    public RamTargetTask(Function<E, RangedInteger> timeBetweenRams, EntityPredicate targeting, ToIntFunction<E> getDamage, float speed, ToDoubleFunction<E> getKnockbackForce, Function<E, SoundEvent> getImpactSound) {
        super((Map)ImmutableMap.of((Object)CCBAI.RAM_COOLDOWN_TICKS.get(), (Object)MemoryModuleStatus.VALUE_ABSENT, (Object)CCBAI.RAM_TARGET.get(), (Object)MemoryModuleStatus.VALUE_PRESENT), 200);
        this.timeBetweenRams = timeBetweenRams;
        this.targeting = targeting;
        this.getDamage = getDamage;
        this.speed = speed;
        this.getKnockbackForce = getKnockbackForce;
        this.getImpactSound = getImpactSound;
        this.ramDirection = Vector3d.field_186680_a;
    }

    protected boolean shouldExecute(ServerWorld worldIn, E owner) {
        return owner.func_213375_cj().func_218191_a((MemoryModuleType)CCBAI.RAM_TARGET.get());
    }

    protected boolean shouldContinueExecuting(ServerWorld worldIn, E entityIn, long gameTimeIn) {
        return entityIn.func_213375_cj().func_218191_a((MemoryModuleType)CCBAI.RAM_TARGET.get());
    }

    protected void startExecuting(ServerWorld worldIn, E entityIn, long gameTimeIn) {
        BlockPos pos = entityIn.func_233580_cy_();
        Brain brain = entityIn.func_213375_cj();
        Vector3d target = (Vector3d)brain.func_218207_c((MemoryModuleType)CCBAI.RAM_TARGET.get()).get();
        this.ramDirection = new Vector3d((double)pos.func_177958_n() - target.func_82615_a(), 0.0, (double)pos.func_177952_p() - target.func_82616_c()).func_72432_b();
        brain.func_218205_a(MemoryModuleType.field_220950_k, (Object)new WalkTarget(target, this.speed, 0));
    }

    protected void updateTask(ServerWorld worldIn, E owner, long gameTime) {
        List nearbyEntities = worldIn.func_217374_a(LivingEntity.class, this.targeting, owner, owner.func_174813_aQ());
        Brain brain = owner.func_213375_cj();
        if (!nearbyEntities.isEmpty()) {
            LivingEntity entity = (LivingEntity)nearbyEntities.get(0);
            entity.func_70097_a(DamageSource.func_76358_a(owner), (float)this.getDamage.applyAsInt(owner));
            float damage = EntityUtils.isDamageSourceBlocked(entity, DamageSource.func_76358_a(owner)) ? 0.5f : 1.0f;
            float speed = MathHelper.func_76131_a((float)(owner.func_70689_ay() * 1.65f), (float)0.2f, (float)3.0f);
            entity.func_233627_a_((float)((double)(damage * speed) * this.getKnockbackForce.applyAsDouble(owner)), this.ramDirection.func_82615_a(), this.ramDirection.func_82616_c());
            this.finishRam(worldIn, owner);
            worldIn.func_217384_a(null, owner, this.getImpactSound.apply(owner), SoundCategory.HOSTILE, 1.0f, 1.0f);
        } else {
            boolean shouldFinishRamming;
            Optional walkTarget = brain.func_218207_c(MemoryModuleType.field_220950_k);
            Optional ramTarget = brain.func_218207_c((MemoryModuleType)CCBAI.RAM_TARGET.get());
            boolean bl = shouldFinishRamming = !walkTarget.isPresent() || !ramTarget.isPresent() || ((WalkTarget)walkTarget.get()).func_220966_a().func_220609_b().func_72438_d((Vector3d)ramTarget.get()) < 0.25;
            if (shouldFinishRamming) {
                this.finishRam(worldIn, owner);
            }
        }
    }

    protected void finishRam(ServerWorld worldIn, E entityIn) {
        worldIn.func_72960_a(entityIn, (byte)59);
        entityIn.func_213375_cj().func_218205_a((MemoryModuleType)CCBAI.RAM_COOLDOWN_TICKS.get(), (Object)this.timeBetweenRams.apply(entityIn).func_233018_a_(worldIn.field_73012_v));
        entityIn.func_213375_cj().func_218189_b((MemoryModuleType)CCBAI.RAM_TARGET.get());
    }
}

