/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.entities.passive.axolotl;

import com.blackgear.cavesandcliffs.common.entities.passive.ai.task.AquaticStrollTask;
import com.blackgear.cavesandcliffs.common.entities.passive.ai.task.ForgetAttackTargetTask;
import com.blackgear.cavesandcliffs.common.entities.passive.ai.task.GoTowardsLookTargetTask;
import com.blackgear.cavesandcliffs.common.entities.passive.ai.task.PlayDeadTask;
import com.blackgear.cavesandcliffs.common.entities.passive.ai.task.PlayDeadTimerTask;
import com.blackgear.cavesandcliffs.common.entities.passive.ai.task.RangedApproachTask;
import com.blackgear.cavesandcliffs.common.entities.passive.ai.task.SeekWaterTask;
import com.blackgear.cavesandcliffs.common.entities.passive.ai.task.StrollTask;
import com.blackgear.cavesandcliffs.common.entities.passive.ai.task.TemptTask;
import com.blackgear.cavesandcliffs.common.entities.passive.ai.task.TemptationCooldownTask;
import com.blackgear.cavesandcliffs.common.entities.passive.ai.task.UpdateAttackTargetTask;
import com.blackgear.cavesandcliffs.common.entities.passive.ai.task.WalkTowardClosestAdultTask;
import com.blackgear.cavesandcliffs.common.entities.passive.axolotl.AxolotlEntity;
import com.blackgear.cavesandcliffs.core.registries.CCBAI;
import com.blackgear.cavesandcliffs.core.registries.CCBEntityTypes;
import com.blackgear.cavesandcliffs.core.registries.other.tags.CCBItemTags;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.schedule.Activity;
import net.minecraft.entity.ai.brain.task.AnimalBreedTask;
import net.minecraft.entity.ai.brain.task.AttackTargetTask;
import net.minecraft.entity.ai.brain.task.DummyTask;
import net.minecraft.entity.ai.brain.task.FirstShuffledTask;
import net.minecraft.entity.ai.brain.task.LookAtEntityTask;
import net.minecraft.entity.ai.brain.task.LookTask;
import net.minecraft.entity.ai.brain.task.MultiTask;
import net.minecraft.entity.ai.brain.task.PredicateTask;
import net.minecraft.entity.ai.brain.task.RunSometimesTask;
import net.minecraft.entity.ai.brain.task.SupplementedTask;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.entity.ai.brain.task.WalkToTargetTask;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.RangedInteger;

public class AxolotlTasks {
    private static final RangedInteger WALK_TOWARD_ADULT_RANGE = RangedInteger.func_233017_a_((int)5, (int)16);

    protected static Brain<?> makeBrain(Brain<AxolotlEntity> brain) {
        AxolotlTasks.initCoreActivity(brain);
        AxolotlTasks.initIdleActivity(brain);
        AxolotlTasks.initFightActivity(brain);
        AxolotlTasks.initPlayDeadActivity(brain);
        brain.func_218199_a((Set)ImmutableSet.of((Object)Activity.field_221365_a));
        brain.func_218200_b(Activity.field_221366_b);
        brain.func_233714_e_();
        return brain;
    }

    private static void initPlayDeadActivity(Brain<AxolotlEntity> brain) {
        brain.func_233701_a_((Activity)CCBAI.PLAY_DEAD.get(), ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new PlayDeadTask())), (Object)Pair.of((Object)1, (Object)new PredicateTask(AxolotlTasks::hasBreedTarget, (MemoryModuleType)CCBAI.PLAY_DEAD_TICKS.get()))), (Set)ImmutableSet.of((Object)Pair.of((Object)CCBAI.PLAY_DEAD_TICKS.get(), (Object)MemoryModuleStatus.VALUE_PRESENT)), (Set)ImmutableSet.of((Object)CCBAI.PLAY_DEAD_TICKS.get()));
    }

    private static void initFightActivity(Brain<AxolotlEntity> brain) {
        brain.func_233699_a_(Activity.field_234621_k_, 0, ImmutableList.of(new ForgetAttackTargetTask<AxolotlEntity>(AxolotlEntity::appreciatePlayer), (Object)((Object)new RangedApproachTask(AxolotlTasks::getSpeedModifierChasing)), (Object)new AttackTargetTask(20), (Object)new PredicateTask(AxolotlTasks::hasBreedTarget, MemoryModuleType.field_234103_o_)), MemoryModuleType.field_234103_o_);
    }

    private static void initCoreActivity(Brain<AxolotlEntity> brain) {
        brain.func_233698_a_(Activity.field_221365_a, 0, ImmutableList.of((Object)new LookTask(45, 90), (Object)new WalkToTargetTask(), (Object)((Object)new PlayDeadTimerTask()), new TemptationCooldownTask((MemoryModuleType<Integer>)((MemoryModuleType)CCBAI.TEMPTATION_COOLDOWN_TICKS.get()))));
    }

    private static void initIdleActivity(Brain<AxolotlEntity> brain) {
        brain.func_218208_a(Activity.field_221366_b, ImmutableList.of((Object)Pair.of((Object)0, (Object)new RunSometimesTask((Task)new LookAtEntityTask(EntityType.field_200729_aH, 6.0f), RangedInteger.func_233017_a_((int)30, (int)60))), (Object)Pair.of((Object)1, (Object)new AnimalBreedTask((EntityType)CCBEntityTypes.AXOLOTL.get(), 0.2f)), (Object)Pair.of((Object)2, (Object)new FirstShuffledTask((List)ImmutableList.of((Object)Pair.of((Object)((Object)new TemptTask(AxolotlTasks::getSpeedModifier)), (Object)1), (Object)Pair.of(new WalkTowardClosestAdultTask(WALK_TOWARD_ADULT_RANGE, AxolotlTasks::getSpeedModifierFollowingAdult), (Object)1)))), (Object)Pair.of((Object)3, new UpdateAttackTargetTask<AxolotlEntity>(AxolotlTasks::getAttackTarget)), (Object)Pair.of((Object)3, (Object)((Object)new SeekWaterTask(6, 0.15f))), (Object)Pair.of((Object)4, (Object)new MultiTask((Map)ImmutableMap.of((Object)MemoryModuleType.field_220950_k, (Object)MemoryModuleStatus.VALUE_ABSENT), (Set)ImmutableSet.of(), MultiTask.Ordering.ORDERED, MultiTask.RunType.TRY_ALL, (List)ImmutableList.of((Object)Pair.of((Object)((Object)new AquaticStrollTask(0.5f)), (Object)2), (Object)Pair.of((Object)((Object)new StrollTask(0.15f)), (Object)2), (Object)Pair.of((Object)((Object)new GoTowardsLookTargetTask(AxolotlTasks::getSpeedModifier, 3)), (Object)3), (Object)Pair.of((Object)new SupplementedTask(Entity::func_203005_aq, (Task)new DummyTask(30, 60)), (Object)5), (Object)Pair.of((Object)new SupplementedTask(Entity::func_233570_aj_, (Task)new DummyTask(200, 400)), (Object)5))))));
    }

    public static void updateActivity(AxolotlEntity axolotl) {
        Brain<AxolotlEntity> brain = axolotl.func_213375_cj();
        Activity activity = brain.func_233716_f_().orElse(null);
        if (activity != CCBAI.PLAY_DEAD.get()) {
            brain.func_233706_a_((List)ImmutableList.of((Object)CCBAI.PLAY_DEAD.get(), (Object)Activity.field_234621_k_, (Object)Activity.field_221366_b));
            if (activity == Activity.field_234621_k_ && brain.func_233716_f_().orElse(null) != Activity.field_234621_k_) {
                brain.func_233696_a_((MemoryModuleType)CCBAI.HAS_HUNTING_COOLDOWN.get(), (Object)true, 2400L);
            }
        }
    }

    private static float getSpeedModifierChasing(LivingEntity entity) {
        return entity.func_203005_aq() ? 0.6f : 0.15f;
    }

    private static float getSpeedModifierFollowingAdult(LivingEntity entity) {
        return entity.func_203005_aq() ? 0.6f : 0.15f;
    }

    private static float getSpeedModifier(LivingEntity entity) {
        return entity.func_203005_aq() ? 0.5f : 0.15f;
    }

    private static Optional<? extends LivingEntity> getAttackTarget(AxolotlEntity axolotl) {
        return AxolotlTasks.hasBreedTarget(axolotl) ? Optional.empty() : axolotl.func_213375_cj().func_218207_c((MemoryModuleType)CCBAI.NEAREST_ATTACKABLE.get());
    }

    private static boolean hasBreedTarget(AxolotlEntity axolotl) {
        return axolotl.func_213375_cj().func_218191_a(MemoryModuleType.field_220953_n);
    }

    public static Ingredient getTemptations() {
        return Ingredient.func_199805_a(CCBItemTags.AXOLOTL_TEMPT_ITEMS);
    }
}

