/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.entities.passive.goat;

import com.blackgear.cavesandcliffs.common.entities.passive.ai.task.AnimalPanicTask;
import com.blackgear.cavesandcliffs.common.entities.passive.ai.task.LongJumpMidJumpTask;
import com.blackgear.cavesandcliffs.common.entities.passive.ai.task.LongJumpToRandomPosTask;
import com.blackgear.cavesandcliffs.common.entities.passive.ai.task.PrepareRamNearestTargetTask;
import com.blackgear.cavesandcliffs.common.entities.passive.ai.task.RamTargetTask;
import com.blackgear.cavesandcliffs.common.entities.passive.ai.task.TemptTask;
import com.blackgear.cavesandcliffs.common.entities.passive.ai.task.TemptationCooldownTask;
import com.blackgear.cavesandcliffs.common.entities.passive.goat.GoatEntity;
import com.blackgear.cavesandcliffs.core.registries.CCBAI;
import com.blackgear.cavesandcliffs.core.registries.CCBEntityTypes;
import com.blackgear.cavesandcliffs.core.registries.CCBSoundEvents;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.schedule.Activity;
import net.minecraft.entity.ai.brain.task.AnimalBreedTask;
import net.minecraft.entity.ai.brain.task.ChildFollowNearestAdultTask;
import net.minecraft.entity.ai.brain.task.DummyTask;
import net.minecraft.entity.ai.brain.task.FirstShuffledTask;
import net.minecraft.entity.ai.brain.task.LookAtEntityTask;
import net.minecraft.entity.ai.brain.task.LookTask;
import net.minecraft.entity.ai.brain.task.RunSometimesTask;
import net.minecraft.entity.ai.brain.task.SwimTask;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.entity.ai.brain.task.WalkRandomlyTask;
import net.minecraft.entity.ai.brain.task.WalkToTargetTask;
import net.minecraft.entity.ai.brain.task.WalkTowardsLookTargetTask;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RangedInteger;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.Difficulty;

public class GoatTasks {
    private static final RangedInteger ADULT_FOLLOW_RANGE = RangedInteger.func_233017_a_((int)5, (int)16);
    private static final RangedInteger TIMES_BETWEEN_LONG_JUMPS = RangedInteger.func_233017_a_((int)600, (int)1200);
    private static final RangedInteger TIMES_BETWEEN_RAMS = RangedInteger.func_233017_a_((int)600, (int)6000);
    private static final RangedInteger SCREAMING_GOAT_TIMES_BETWEEN_RAMS = RangedInteger.func_233017_a_((int)100, (int)300);
    private static final EntityPredicate RAM_TARGET_CONDITIONS = new EntityPredicate().func_221012_a(entityIn -> !entityIn.func_200600_R().equals(CCBEntityTypes.GOAT.get()) && (entityIn.field_70170_p.func_175659_aa() != Difficulty.PEACEFUL || !entityIn.func_200600_R().equals(EntityType.field_200729_aH)));

    protected static void initMemories(GoatEntity goat) {
        goat.func_213375_cj().func_218205_a((MemoryModuleType)CCBAI.LONG_JUMP_COOLDOWN_TICKS.get(), (Object)TIMES_BETWEEN_LONG_JUMPS.func_233018_a_(goat.field_70170_p.field_73012_v));
        goat.func_213375_cj().func_218205_a((MemoryModuleType)CCBAI.RAM_COOLDOWN_TICKS.get(), (Object)TIMES_BETWEEN_RAMS.func_233018_a_(goat.field_70170_p.field_73012_v));
    }

    protected static Brain<?> makeBrain(Brain<GoatEntity> brain) {
        GoatTasks.initCoreActivity(brain);
        GoatTasks.initIdleActivity(brain);
        GoatTasks.initLongJumpActivity(brain);
        GoatTasks.initRamActivity(brain);
        brain.func_218199_a((Set)ImmutableSet.of((Object)Activity.field_221365_a));
        brain.func_218200_b(Activity.field_221366_b);
        brain.func_233714_e_();
        return brain;
    }

    private static void initCoreActivity(Brain<GoatEntity> brain) {
        brain.func_233698_a_(Activity.field_221365_a, 0, ImmutableList.of((Object)new SwimTask(0.8f), (Object)((Object)new AnimalPanicTask(2.0f)), (Object)new LookTask(45, 90), (Object)new WalkToTargetTask(), new TemptationCooldownTask((MemoryModuleType<Integer>)((MemoryModuleType)CCBAI.TEMPTATION_COOLDOWN_TICKS.get())), new TemptationCooldownTask((MemoryModuleType<Integer>)((MemoryModuleType)CCBAI.LONG_JUMP_COOLDOWN_TICKS.get())), new TemptationCooldownTask((MemoryModuleType<Integer>)((MemoryModuleType)CCBAI.RAM_COOLDOWN_TICKS.get()))));
    }

    private static void initIdleActivity(Brain<GoatEntity> brain) {
        brain.func_233700_a_(Activity.field_221366_b, ImmutableList.of((Object)Pair.of((Object)0, (Object)new RunSometimesTask((Task)new LookAtEntityTask(EntityType.field_200729_aH, 6.0f), RangedInteger.func_233017_a_((int)30, (int)60))), (Object)Pair.of((Object)0, (Object)new AnimalBreedTask((EntityType)CCBEntityTypes.GOAT.get(), 1.0f)), (Object)Pair.of((Object)1, (Object)((Object)new TemptTask(target -> Float.valueOf(1.25f)))), (Object)Pair.of((Object)2, (Object)new ChildFollowNearestAdultTask(ADULT_FOLLOW_RANGE, 1.25f)), (Object)Pair.of((Object)3, (Object)new FirstShuffledTask((List)ImmutableList.of((Object)Pair.of((Object)new WalkRandomlyTask(1.0f), (Object)2), (Object)Pair.of((Object)new WalkTowardsLookTargetTask(1.0f, 3), (Object)2), (Object)Pair.of((Object)new DummyTask(30, 60), (Object)1))))), (Set)ImmutableSet.of((Object)Pair.of((Object)CCBAI.RAM_TARGET.get(), (Object)MemoryModuleStatus.VALUE_ABSENT), (Object)Pair.of((Object)CCBAI.LONG_JUMP_MID_JUMP.get(), (Object)MemoryModuleStatus.VALUE_ABSENT)));
    }

    private static void initLongJumpActivity(Brain<GoatEntity> brain) {
        brain.func_233700_a_((Activity)CCBAI.LONG_JUMP.get(), ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new LongJumpMidJumpTask(TIMES_BETWEEN_LONG_JUMPS))), (Object)Pair.of((Object)1, new LongJumpToRandomPosTask<GoatEntity>(TIMES_BETWEEN_LONG_JUMPS, 5, 5, 1.5f, entityIn -> entityIn.isScreaming() ? (SoundEvent)CCBSoundEvents.ENTITY_GOAT_JUMP.get() : (SoundEvent)CCBSoundEvents.ENTITY_GOAT_JUMP.get()))), (Set)ImmutableSet.of((Object)Pair.of((Object)CCBAI.TEMPTING_PLAYER.get(), (Object)MemoryModuleStatus.VALUE_ABSENT), (Object)Pair.of((Object)MemoryModuleType.field_220953_n, (Object)MemoryModuleStatus.VALUE_ABSENT), (Object)Pair.of((Object)MemoryModuleType.field_220950_k, (Object)MemoryModuleStatus.VALUE_ABSENT), (Object)Pair.of((Object)CCBAI.LONG_JUMP_COOLDOWN_TICKS.get(), (Object)MemoryModuleStatus.VALUE_ABSENT)));
    }

    private static void initRamActivity(Brain<GoatEntity> brain) {
        brain.func_233700_a_((Activity)CCBAI.RAM.get(), ImmutableList.of((Object)Pair.of((Object)0, new RamTargetTask<GoatEntity>(goatEntity -> goatEntity.isScreaming() ? SCREAMING_GOAT_TIMES_BETWEEN_RAMS : TIMES_BETWEEN_RAMS, RAM_TARGET_CONDITIONS, entityIn -> entityIn.func_70631_g_() ? 1 : 2, 3.0f, entityIn -> entityIn.func_70631_g_() ? 1.0 : 2.5, entityIn -> entityIn.isScreaming() ? (SoundEvent)CCBSoundEvents.ENTITY_GOAT_IMPACT.get() : (SoundEvent)CCBSoundEvents.ENTITY_GOAT_IMPACT.get())), (Object)Pair.of((Object)1, new PrepareRamNearestTargetTask<GoatEntity>(TIMES_BETWEEN_RAMS.func_233016_a_(), 4, 7, 1.25f, RAM_TARGET_CONDITIONS, 20, entityIn -> entityIn.isScreaming() ? (SoundEvent)CCBSoundEvents.ENTITY_GOAT_SCREAM_PRE_RAM.get() : (SoundEvent)CCBSoundEvents.ENTITY_GOAT_PRE_RAM.get()))), (Set)ImmutableSet.of((Object)Pair.of((Object)CCBAI.TEMPTING_PLAYER.get(), (Object)MemoryModuleStatus.VALUE_ABSENT), (Object)Pair.of((Object)MemoryModuleType.field_220953_n, (Object)MemoryModuleStatus.VALUE_ABSENT), (Object)Pair.of((Object)CCBAI.RAM_COOLDOWN_TICKS.get(), (Object)MemoryModuleStatus.VALUE_ABSENT)));
    }

    public static void updateActivity(GoatEntity goat) {
        goat.func_213375_cj().func_233706_a_((List)ImmutableList.of((Object)CCBAI.RAM.get(), (Object)CCBAI.LONG_JUMP.get(), (Object)Activity.field_221366_b));
    }

    public static Ingredient getTemptations() {
        return Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151015_O});
    }
}

