/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.events;

import com.blackgear.cavesandcliffs.common.blocks.CaveVinesBlock;
import com.blackgear.cavesandcliffs.common.entities.passive.axolotl.AxolotlEntity;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SweetBerryBushBlock;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.DrownedEntity;
import net.minecraft.entity.monster.GuardianEntity;
import net.minecraft.entity.passive.FoxEntity;
import net.minecraft.entity.passive.SquidEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class EntityGoalEvents {
    @SubscribeEvent
    public void onEntityJoin(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof DrownedEntity) {
            ((DrownedEntity)entity).field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)((DrownedEntity)entity), AxolotlEntity.class, 10, true, false, AxolotlEntity.NOT_PLAYING_DEAD_SELECTOR));
        }
        if (entity instanceof GuardianEntity) {
            ((GuardianEntity)entity).field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)((GuardianEntity)entity), AxolotlEntity.class, 10, true, false, (Predicate)new GuardianTargetPredicate((GuardianEntity)entity)));
        }
        if (entity instanceof FoxEntity) {
            ((FoxEntity)entity).field_70714_bg.func_75776_a(10, (Goal)new FoxEatBerriesGoal((FoxEntity)entity, 1.2f, 12, 2));
        }
    }

    static class FoxEatBerriesGoal
    extends MoveToBlockGoal {
        private final FoxEntity foxEntity;
        protected int timer;

        public FoxEatBerriesGoal(FoxEntity foxEntity, double speedIn, int length, int maxYDifference) {
            super((CreatureEntity)foxEntity, speedIn, length, maxYDifference);
            this.foxEntity = foxEntity;
        }

        public double func_203110_f() {
            return 2.0;
        }

        public boolean func_203108_i() {
            return this.field_179493_e % 100 == 0;
        }

        protected boolean func_179488_a(IWorldReader worldIn, BlockPos pos) {
            BlockState state = worldIn.func_180495_p(pos);
            return state.func_203425_a(Blocks.field_222434_lW) && (Integer)state.func_177229_b((Property)SweetBerryBushBlock.field_220125_a) >= 2 || CaveVinesBlock.hasGlowBerries(state);
        }

        public void func_75246_d() {
            if (this.func_179487_f()) {
                if (this.timer >= 40) {
                    this.eatSweetBerry();
                } else {
                    ++this.timer;
                }
            } else if (!this.func_179487_f() && this.foxEntity.field_70170_p.field_73012_v.nextFloat() < 0.05f) {
                this.foxEntity.func_184185_a(SoundEvents.field_219628_dB, 1.0f, 1.0f);
            }
            super.func_75246_d();
        }

        protected void eatSweetBerry() {
            if (ForgeEventFactory.getMobGriefingEvent((World)this.foxEntity.field_70170_p, (Entity)this.foxEntity)) {
                BlockState state = this.foxEntity.field_70170_p.func_180495_p(this.field_179494_b);
                if (state.func_203425_a(Blocks.field_222434_lW)) {
                    this.pickSweetBerries(state);
                } else if (CaveVinesBlock.hasGlowBerries(state)) {
                    this.pickGlowBerries(state);
                }
            }
        }

        private void pickGlowBerries(BlockState state) {
            CaveVinesBlock.onBlockActivated(state, this.foxEntity.field_70170_p, this.field_179494_b);
        }

        private void pickSweetBerries(BlockState state) {
            int i = (Integer)state.func_177229_b((Property)SweetBerryBushBlock.field_220125_a);
            state.func_206870_a((Property)SweetBerryBushBlock.field_220125_a, (Comparable)Integer.valueOf(1));
            int j = 1 + this.foxEntity.field_70170_p.field_73012_v.nextInt(2) + (i == 3 ? 1 : 0);
            ItemStack itemstack = this.foxEntity.func_184582_a(EquipmentSlotType.MAINHAND);
            if (itemstack.func_190926_b()) {
                this.foxEntity.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Items.field_222112_pR));
                --j;
            }
            if (j > 0) {
                Block.func_180635_a((World)this.foxEntity.field_70170_p, (BlockPos)this.field_179494_b, (ItemStack)new ItemStack((IItemProvider)Items.field_222112_pR, j));
            }
            this.foxEntity.func_184185_a(SoundEvents.field_219693_lB, 1.0f, 1.0f);
            this.foxEntity.field_70170_p.func_180501_a(this.field_179494_b, (BlockState)state.func_206870_a((Property)SweetBerryBushBlock.field_220125_a, (Comparable)Integer.valueOf(1)), 2);
        }

        public boolean func_75250_a() {
            return !this.foxEntity.func_70608_bn() && super.func_75250_a();
        }

        public void func_75249_e() {
            this.timer = 0;
            this.foxEntity.func_213466_r(false);
            super.func_75249_e();
        }
    }

    static class GuardianTargetPredicate
    implements Predicate<LivingEntity> {
        private final GuardianEntity guardian;

        public GuardianTargetPredicate(GuardianEntity guardian) {
            this.guardian = guardian;
        }

        @Override
        public boolean test(LivingEntity entity) {
            return (entity instanceof PlayerEntity || entity instanceof SquidEntity || entity != null && AxolotlEntity.NOT_PLAYING_DEAD_SELECTOR.test(entity)) && entity.func_70068_e((Entity)this.guardian) > 9.0;
        }
    }
}

