/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.events;

import com.blackgear.cavesandcliffs.common.blocks.CandleBlock;
import com.blackgear.cavesandcliffs.common.blocks.CandleCakeBlock;
import com.blackgear.cavesandcliffs.common.blocks.Oxidizable;
import com.blackgear.cavesandcliffs.core.registries.CCBBlocks;
import com.blackgear.cavesandcliffs.core.registries.CCBSoundEvents;
import com.blackgear.cavesandcliffs.core.registries.other.tags.CCBItemTags;
import com.blackgear.cavesandcliffs.core.registries.other.utils.BlockUtils;
import com.blackgear.cavesandcliffs.core.registries.other.utils.WorldUtils;
import com.blackgear.cavesandcliffs.mixin.core.accessor.BoneMealItemInvoker;
import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CakeBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.AxeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ToolClickEvent {
    public static final Supplier<BiMap<Block, Block>> UNWAXED_TO_WAXED_BLOCKS = Suppliers.memoize(() -> new ImmutableBiMap.Builder().put((Object)CCBBlocks.COPPER_BLOCK.get(), (Object)CCBBlocks.WAXED_COPPER_BLOCK.get()).put((Object)CCBBlocks.EXPOSED_COPPER.get(), (Object)CCBBlocks.WAXED_EXPOSED_COPPER.get()).put((Object)CCBBlocks.WEATHERED_COPPER.get(), (Object)CCBBlocks.WAXED_WEATHERED_COPPER.get()).put((Object)CCBBlocks.OXIDIZED_COPPER.get(), (Object)CCBBlocks.WAXED_OXIDIZED_COPPER.get()).put((Object)CCBBlocks.CUT_COPPER.get(), (Object)CCBBlocks.WAXED_CUT_COPPER.get()).put((Object)CCBBlocks.EXPOSED_CUT_COPPER.get(), (Object)CCBBlocks.WAXED_EXPOSED_CUT_COPPER.get()).put((Object)CCBBlocks.WEATHERED_CUT_COPPER.get(), (Object)CCBBlocks.WAXED_WEATHERED_CUT_COPPER.get()).put((Object)CCBBlocks.OXIDIZED_CUT_COPPER.get(), (Object)CCBBlocks.WAXED_OXIDIZED_CUT_COPPER.get()).put((Object)CCBBlocks.CUT_COPPER_SLAB.get(), (Object)CCBBlocks.WAXED_CUT_COPPER_SLAB.get()).put((Object)CCBBlocks.EXPOSED_CUT_COPPER_SLAB.get(), (Object)CCBBlocks.WAXED_EXPOSED_CUT_COPPER_SLAB.get()).put((Object)CCBBlocks.WEATHERED_CUT_COPPER_SLAB.get(), (Object)CCBBlocks.WAXED_WEATHERED_CUT_COPPER_SLAB.get()).put((Object)CCBBlocks.OXIDIZED_CUT_COPPER_SLAB.get(), (Object)CCBBlocks.WAXED_OXIDIZED_CUT_COPPER_SLAB.get()).put((Object)CCBBlocks.CUT_COPPER_STAIRS.get(), (Object)CCBBlocks.WAXED_CUT_COPPER_STAIRS.get()).put((Object)CCBBlocks.EXPOSED_CUT_COPPER_STAIRS.get(), (Object)CCBBlocks.WAXED_EXPOSED_CUT_COPPER_STAIRS.get()).put((Object)CCBBlocks.WEATHERED_CUT_COPPER_STAIRS.get(), (Object)CCBBlocks.WAXED_WEATHERED_CUT_COPPER_STAIRS.get()).put((Object)CCBBlocks.OXIDIZED_CUT_COPPER_STAIRS.get(), (Object)CCBBlocks.WAXED_OXIDIZED_CUT_COPPER_STAIRS.get()).build());
    public static final Supplier<BiMap<Block, Block>> WAXED_TO_UNWAXED_BLOCKS = Suppliers.memoize(() -> UNWAXED_TO_WAXED_BLOCKS.get().inverse());

    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Block block;
        World world = event.getWorld();
        PlayerEntity player = event.getPlayer();
        Hand hand = event.getHand();
        ItemStack stack = player.func_184586_b(hand);
        Item item = stack.func_77973_b();
        BlockPos pos = event.getPos();
        BlockState state = world.func_180495_p(pos);
        if (item == Items.field_226635_pU_) {
            event.setCancellationResult(ToolClickEvent.getWaxedState(state).map(stateIn -> {
                if (!player.func_184812_l_()) {
                    stack.func_190918_g(1);
                }
                world.func_180501_a(pos, stateIn, 11);
                WorldUtils.syncWorldEvent(world, 3003, pos, 0);
                return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
            }).orElse(ActionResultType.PASS));
            event.setCanceled(true);
        }
        if (item == Items.field_196106_bc) {
            BlockPos facing = pos.func_177972_a(Objects.requireNonNull(event.getFace()));
            if (BoneMealItemInvoker.applyBonemeal(stack, world, pos, player)) {
                if (!world.field_72995_K) {
                    world.func_184133_a(null, pos, (SoundEvent)CCBSoundEvents.ITEM_BONEMEAL_USE.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                    event.setCancellationResult(ActionResultType.func_233537_a_((boolean)world.field_72995_K));
                }
            } else {
                boolean flag = state.func_224755_d((IBlockReader)world, pos, event.getFace());
                if (flag && BoneMealItemInvoker.growSeagrass(stack, world, facing, event.getFace())) {
                    if (!world.field_72995_K) {
                        world.func_184133_a(null, pos, (SoundEvent)CCBSoundEvents.ITEM_BONEMEAL_USE.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                    }
                    event.setCancellationResult(ActionResultType.func_233537_a_((boolean)world.field_72995_K));
                } else {
                    event.setCancellationResult(ActionResultType.PASS);
                }
            }
        }
        if (item instanceof AxeItem) {
            Optional<BlockState> decreasedOxidationState = Oxidizable.getDecreasedOxidationState(state);
            Optional<BlockState> waxedToUnwaxedState = Optional.ofNullable(WAXED_TO_UNWAXED_BLOCKS.get().get((Object)state.func_177230_c())).map(blockIn -> BlockUtils.getStateWithProperties(blockIn, state));
            Optional<Object> blockState = Optional.empty();
            if (decreasedOxidationState.isPresent()) {
                world.func_184133_a(player, pos, (SoundEvent)CCBSoundEvents.ITEM_AXE_SCRAPE.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                WorldUtils.syncWorldEvent(world, 3005, pos, 0);
                blockState = decreasedOxidationState;
            } else if (waxedToUnwaxedState.isPresent()) {
                world.func_184133_a(player, pos, (SoundEvent)CCBSoundEvents.ITEM_AXE_WAX_OFF.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                WorldUtils.syncWorldEvent(world, 3004, pos, 0);
                blockState = waxedToUnwaxedState;
            }
            if (blockState.isPresent()) {
                world.func_180501_a(pos, (BlockState)blockState.get(), 11);
                stack.func_222118_a(1, (LivingEntity)player, entityIn -> entityIn.func_213334_d(hand));
                event.setCancellationResult(ActionResultType.func_233537_a_((boolean)world.field_72995_K));
                event.setCanceled(true);
            } else {
                event.setCancellationResult(ActionResultType.PASS);
            }
        }
        if (state.func_203425_a(Blocks.field_150414_aQ) && item.func_206844_a(CCBItemTags.CANDLES) && (Integer)state.func_177229_b((Property)CakeBlock.field_176589_a) == 0 && (block = Block.func_149634_a((Item)item)) instanceof CandleBlock) {
            if (!player.func_184812_l_()) {
                stack.func_190918_g(1);
            }
            world.func_184133_a(null, pos, (SoundEvent)CCBSoundEvents.BLOCK_CAKE_ADD_CANDLE.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
            world.func_175656_a(pos, CandleCakeBlock.byCandle(block));
            event.setCancellationResult(ActionResultType.SUCCESS);
        }
    }

    public static Optional<BlockState> getWaxedState(BlockState state) {
        return Optional.ofNullable(UNWAXED_TO_WAXED_BLOCKS.get().get((Object)state.func_177230_c())).map(block -> BlockUtils.getStateWithProperties(block, state));
    }
}

