/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.gameevent;

import com.blackgear.cavesandcliffs.common.gameevent.PositionSource;
import com.blackgear.cavesandcliffs.common.gameevent.PositionSourceType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockPositionSource
implements PositionSource {
    public static final Codec<BlockPositionSource> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockPos.field_239578_a_.fieldOf("pos").xmap(Optional::of, Optional::get).forGetter(source -> source.pos)).apply((Applicative)instance, BlockPositionSource::new));
    private final Optional<BlockPos> pos;

    public BlockPositionSource(BlockPos pos) {
        this(Optional.of(pos));
    }

    public BlockPositionSource(Optional<BlockPos> pos) {
        this.pos = pos;
    }

    @Override
    public Optional<BlockPos> getPos(World worldIn) {
        return this.pos;
    }

    @Override
    public PositionSourceType<?> getType() {
        return PositionSourceType.BLOCK;
    }

    public static class Type
    implements PositionSourceType<BlockPositionSource> {
        @Override
        public BlockPositionSource readFromBuf(PacketBuffer buffer) {
            return new BlockPositionSource(Optional.of(buffer.func_179259_c()));
        }

        @Override
        public void writeToBuf(PacketBuffer buffer, PositionSource source) {
            BlockPositionSource blockSource = (BlockPositionSource)source;
            blockSource.pos.ifPresent(arg_0 -> ((PacketBuffer)buffer).func_179255_a(arg_0));
        }

        @Override
        public Codec<BlockPositionSource> getCodec() {
            return CODEC;
        }
    }
}

