/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.gameevent;

import com.blackgear.cavesandcliffs.common.gameevent.PositionSource;
import com.blackgear.cavesandcliffs.common.gameevent.PositionSourceType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityPositionSource
implements PositionSource {
    public static final Codec<EntityPositionSource> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("source_entity_id").forGetter(source -> source.sourceEntityId)).apply((Applicative)instance, EntityPositionSource::new));
    private final int sourceEntityId;
    private Optional<Entity> entity = Optional.empty();

    public EntityPositionSource(int sourceEntityId) {
        this.sourceEntityId = sourceEntityId;
    }

    @Override
    public Optional<BlockPos> getPos(World worldIn) {
        if (!this.entity.isPresent()) {
            this.entity = Optional.ofNullable(worldIn.func_73045_a(this.sourceEntityId));
        }
        return this.entity.map(Entity::func_233580_cy_);
    }

    @Override
    public PositionSourceType<?> getType() {
        return PositionSourceType.ENTITY;
    }

    public static class Type
    implements PositionSourceType<EntityPositionSource> {
        @Override
        public EntityPositionSource readFromBuf(PacketBuffer buffer) {
            return new EntityPositionSource(buffer.func_150792_a());
        }

        @Override
        public void writeToBuf(PacketBuffer buffer, PositionSource source) {
            EntityPositionSource entitySource = (EntityPositionSource)source;
            buffer.func_150787_b(entitySource.sourceEntityId);
        }

        @Override
        public Codec<EntityPositionSource> getCodec() {
            return CODEC;
        }
    }
}

