/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.gameevent;

import com.blackgear.cavesandcliffs.common.gameevent.BlockPositionSource;
import com.blackgear.cavesandcliffs.common.gameevent.EntityPositionSource;
import com.blackgear.cavesandcliffs.common.gameevent.PositionSource;
import com.blackgear.cavesandcliffs.core.registries.api.util.ModRegistry;
import com.mojang.serialization.Codec;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;

public interface PositionSourceType<T extends PositionSource> {
    public static final PositionSourceType<BlockPositionSource> BLOCK = PositionSourceType.register("block", new BlockPositionSource.Type());
    public static final PositionSourceType<EntityPositionSource> ENTITY = PositionSourceType.register("entity", new EntityPositionSource.Type());

    public T readFromBuf(PacketBuffer var1);

    public void writeToBuf(PacketBuffer var1, PositionSource var2);

    public Codec<T> getCodec();

    public static <S extends PositionSourceType<T>, T extends PositionSource> S register(String key, S sourceType) {
        return (S)((PositionSourceType)Registry.func_218325_a(ModRegistry.POSITION_SOURCE_TYPE, (String)key, sourceType));
    }

    public static PositionSource fromNetwork(PacketBuffer buffer) {
        ResourceLocation location = buffer.func_192575_l();
        return ((PositionSourceType)ModRegistry.POSITION_SOURCE_TYPE.func_241873_b(location).orElseThrow(() -> new IllegalArgumentException("Unknown position source type " + location))).readFromBuf(buffer);
    }

    public static <T extends PositionSource> void toNetwork(T source, PacketBuffer buffer) {
        buffer.func_192572_a(ModRegistry.POSITION_SOURCE_TYPE.func_177774_c(source.getType()));
        source.getType().writeToBuf(buffer, source);
    }
}

