/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.utils;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public class ExtraCodecs {
    public static final Codec<Integer> NON_NEGATIVE_INT = ExtraCodecs.intRangeWithMessage(0, Integer.MAX_VALUE, integer -> "Value must be non-negative: " + integer);
    public static final Codec<Integer> POSITIVE_INT = ExtraCodecs.intRangeWithMessage(1, Integer.MAX_VALUE, integer -> "Value must be positive: " + integer);

    public static <F, S> Codec<Either<F, S>> xor(Codec<F> first, Codec<S> second) {
        return new Xor<F, S>(first, second);
    }

    private static <N extends Number> Function<N, DataResult<N>> changeRangeWithMessage(N number, N number2, Function<N, String> function) {
        return number3 -> ((Comparable)((Object)number3)).compareTo(number) >= 0 && ((Comparable)((Object)number3)).compareTo(number2) <= 0 ? DataResult.success((Object)number3) : DataResult.error((String)((String)function.apply(number3)));
    }

    private static Codec<Integer> intRangeWithMessage(int i, int j, Function<Integer, String> function) {
        Function<Integer, DataResult<Integer>> function2 = ExtraCodecs.changeRangeWithMessage(i, j, function);
        return Codec.INT.flatXmap(function2, function2);
    }

    public static <T> Function<List<T>, DataResult<List<T>>> nonEmptyListCheck() {
        return list -> list.isEmpty() ? DataResult.error((String)"List must have contents") : DataResult.success((Object)list);
    }

    static final class Xor<F, S>
    implements Codec<Either<F, S>> {
        private final Codec<F> first;
        private final Codec<S> second;

        public Xor(Codec<F> first, Codec<S> second) {
            this.first = first;
            this.second = second;
        }

        public <T> DataResult<Pair<Either<F, S>, T>> decode(DynamicOps<T> ops, T input) {
            DataResult dataResult = this.first.decode(ops, input).map(pair -> pair.mapFirst(Either::left));
            DataResult dataResult2 = this.second.decode(ops, input).map(pair -> pair.mapFirst(Either::right));
            Optional optional = dataResult.result();
            Optional optional2 = dataResult2.result();
            if (optional.isPresent() && optional2.isPresent()) {
                return DataResult.error((String)("Both alternatives read successfully, can not pick the correct one; first: " + optional.get() + " second: " + optional2.get()), optional.get());
            }
            return optional.isPresent() ? dataResult : dataResult2;
        }

        public <T> DataResult<T> encode(Either<F, S> either, DynamicOps<T> dynamicOps, T object) {
            return (DataResult)either.map(left -> this.first.encode(left, dynamicOps, object), right -> this.second.encode(right, dynamicOps, object));
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj != null && this.getClass() == obj.getClass()) {
                Xor xor = (Xor)obj;
                return Objects.equals(this.first, xor.first) && Objects.equals(this.second, xor.second);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.first, this.second);
        }

        public String toString() {
            return "XorCodec[" + this.first + ", " + this.second + ']';
        }
    }
}

