/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.utils.math;

import com.blackgear.cavesandcliffs.common.utils.math.ConstantFloatProvider;
import com.blackgear.cavesandcliffs.common.utils.math.FloatProviderType;
import com.blackgear.cavesandcliffs.core.registries.api.util.ModRegistry;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Random;
import java.util.function.Function;

public abstract class FloatProvider {
    private static final Codec<Either<Float, FloatProvider>> FLOAT_CODEC = Codec.either((Codec)Codec.FLOAT, (Codec)ModRegistry.FLOAT_PROVIDER_TYPE.dispatch(FloatProvider::getType, FloatProviderType::codec));
    public static final Codec<FloatProvider> CODEC = FLOAT_CODEC.xmap(either -> (FloatProvider)either.map(ConstantFloatProvider::create, provider -> provider), provider -> provider.getType() == FloatProviderType.CONSTANT ? Either.left((Object)Float.valueOf(((ConstantFloatProvider)provider).getValue())) : Either.right((Object)provider));

    public static Codec<FloatProvider> createValidatedCodec(float min, float max) {
        Function<FloatProvider, DataResult> function = provider -> {
            if (provider.getMin() < min) {
                return DataResult.error((String)("Value provider too low: " + min + " [" + provider.getMin() + "-" + provider.getMax() + "]"));
            }
            return provider.getMax() > max ? DataResult.error((String)("Value provider too high: " + max + " [" + provider.getMin() + "-" + provider.getMax() + "]")) : DataResult.success((Object)provider);
        };
        return CODEC.flatXmap(function, function);
    }

    public abstract float get(Random var1);

    public abstract float getMin();

    public abstract float getMax();

    public abstract FloatProviderType<?> getType();
}

