/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.biome.provider;

import com.blackgear.cavebiomes.core.api.CaveBiomeAPI;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.RegistryLookupCodec;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.layer.Layer;
import net.minecraft.world.gen.layer.LayerUtil;

public class VerticalOverworldBiomeProvider
extends BiomeProvider {
    public static final Codec<VerticalOverworldBiomeProvider> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.LONG.fieldOf("seed").stable().forGetter(overworldProvider -> overworldProvider.seed), (App)Codec.BOOL.optionalFieldOf("legacy_biome_init_layer", (Object)false, Lifecycle.stable()).forGetter(overworldProvider -> overworldProvider.legacyBiomes), (App)Codec.BOOL.fieldOf("large_biomes").orElse((Object)false).stable().forGetter(overworldProvider -> overworldProvider.largeBiomes), (App)RegistryLookupCodec.func_244331_a((RegistryKey)Registry.field_239720_u_).forGetter(overworldProvider -> overworldProvider.lookupRegistry)).apply((Applicative)builder, builder.stable(VerticalOverworldBiomeProvider::new)));
    private final Layer genBiomes;
    private static final List<RegistryKey<Biome>> biomes = ImmutableList.of((Object)Biomes.field_76771_b, (Object)Biomes.field_76772_c, (Object)Biomes.field_76769_d, (Object)Biomes.field_76770_e, (Object)Biomes.field_76767_f, (Object)Biomes.field_76768_g, (Object)Biomes.field_76780_h, (Object)Biomes.field_76781_i, (Object)Biomes.field_76776_l, (Object)Biomes.field_76777_m, (Object)Biomes.field_76774_n, (Object)Biomes.field_76775_o, (Object[])new RegistryKey[]{Biomes.field_76789_p, Biomes.field_76788_q, Biomes.field_76787_r, Biomes.field_76786_s, Biomes.field_76785_t, Biomes.field_76784_u, Biomes.field_76783_v, Biomes.field_76782_w, Biomes.field_76792_x, Biomes.field_150574_L, Biomes.field_150575_M, Biomes.field_150576_N, Biomes.field_150577_O, Biomes.field_150583_P, Biomes.field_150582_Q, Biomes.field_150585_R, Biomes.field_150584_S, Biomes.field_150579_T, Biomes.field_150578_U, Biomes.field_150581_V, Biomes.field_150580_W, Biomes.field_150588_X, Biomes.field_150587_Y, Biomes.field_150589_Z, Biomes.field_150607_aa, Biomes.field_150608_ab, Biomes.field_203614_T, Biomes.field_203615_U, Biomes.field_203616_V, Biomes.field_203617_W, Biomes.field_203618_X, Biomes.field_203619_Y, Biomes.field_203620_Z, Biomes.field_185441_Q, Biomes.field_185442_R, Biomes.field_185443_S, Biomes.field_185444_T, Biomes.field_150590_f, Biomes.field_150599_m, Biomes.field_185445_W, Biomes.field_185446_X, Biomes.field_185447_Y, Biomes.field_185448_Z, Biomes.field_185429_aa, Biomes.field_185430_ab, Biomes.field_185431_ac, Biomes.field_185432_ad, Biomes.field_185433_ae, Biomes.field_185434_af, Biomes.field_185435_ag, Biomes.field_185436_ah, Biomes.field_185437_ai, Biomes.field_185438_aj, Biomes.field_185439_ak});
    private final long seed;
    private final boolean legacyBiomes;
    private final boolean largeBiomes;
    private final Registry<Biome> lookupRegistry;

    public VerticalOverworldBiomeProvider(long seed, boolean legacyBiomes, boolean largeBiomes, Registry<Biome> lookupRegistry) {
        super(biomes.stream().map(key -> () -> (Biome)lookupRegistry.func_243576_d(key)));
        this.seed = seed;
        this.legacyBiomes = legacyBiomes;
        this.largeBiomes = largeBiomes;
        this.lookupRegistry = lookupRegistry;
        this.genBiomes = LayerUtil.func_237215_a_((long)seed, (boolean)legacyBiomes, (int)(largeBiomes ? 6 : 4), (int)4);
        CaveBiomeAPI.initializeCaveBiomes(lookupRegistry, (long)seed);
    }

    protected Codec<? extends BiomeProvider> func_230319_a_() {
        return CODEC;
    }

    public BiomeProvider func_230320_a_(long seed) {
        return new VerticalOverworldBiomeProvider(seed, this.legacyBiomes, this.largeBiomes, this.lookupRegistry);
    }

    public Biome func_225526_b_(int x, int y, int z) {
        Biome surfaceBiomes = this.genBiomes.func_242936_a(this.lookupRegistry, x, z);
        return CaveBiomeAPI.injectCaveBiomes((Biome)surfaceBiomes, (int)x, (int)y, (int)z);
    }
}

