/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen;

import com.blackgear.cavebiomes.core.registries.CaveBiomes;
import com.blackgear.cavesandcliffs.common.world.gen.VanillaBiomeFeatures;
import com.blackgear.cavesandcliffs.core.CavesAndCliffsConfig;
import com.blackgear.cavesandcliffs.core.registries.CCBBiomes;
import com.blackgear.cavesandcliffs.core.registries.CCBEntityTypes;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.common.world.MobSpawnInfoBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class GlobalBiomeFeatures {
    @SubscribeEvent
    public void onBiomeLoad(BiomeLoadingEvent event) {
        GlobalBiomeManager manager = new GlobalBiomeManager(event);
        if (!manager.canGenerate()) {
            return;
        }
        if (manager.matches((Biome)CCBBiomes.DRIPSTONE_CAVES.get())) {
            CaveFeatures.generateDripstoneCaveFeatures(manager);
            CaveFeatures.generateCaveFeatures(manager);
        }
        if (manager.matches((Biome)CCBBiomes.LUSH_CAVES.get())) {
            CaveFeatures.generateLushCaveFeatures(manager);
            CaveFeatures.generateCaveFeatures(manager);
        }
        if (manager.matches((Biome)CaveBiomes.CAVE.get())) {
            CaveFeatures.generateCaveFeatures(manager);
        }
        if (manager.getCategory() == Biome.Category.EXTREME_HILLS) {
            manager.spawns().func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners((EntityType)CCBEntityTypes.GOAT.get(), ((Integer)CavesAndCliffsConfig.goatWeight.get()).intValue(), 4, 6));
            VanillaBiomeFeatures.addEmeraldOre(manager.generation());
        }
    }

    private static class GlobalBiomeManager {
        private final BiomeLoadingEvent event;

        public GlobalBiomeManager(BiomeLoadingEvent event) {
            this.event = event;
        }

        public Biome.Category getCategory() {
            return this.event.getCategory();
        }

        public ResourceLocation getName() {
            return this.event.getName();
        }

        public BiomeGenerationSettingsBuilder generation() {
            return this.event.getGeneration();
        }

        public MobSpawnInfoBuilder spawns() {
            return this.event.getSpawns();
        }

        public boolean matches(Biome object) {
            Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(this.getName());
            return object == biome;
        }

        public boolean matches(RegistryKey<Biome> object) {
            RegistryKey key = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)this.getName());
            return object == key;
        }

        public boolean canGenerate() {
            return (this.getCategory() != Biome.Category.NETHER || this.getCategory() != Biome.Category.THEEND) && this.getName() != null;
        }
    }

    private static class CaveFeatures {
        private CaveFeatures() {
        }

        private static void generateCaveFeatures(GlobalBiomeManager manager) {
            VanillaBiomeFeatures.addAmethystGeodes(manager.generation());
            VanillaBiomeFeatures.addCaveWaterMobs(manager.spawns());
            VanillaBiomeFeatures.addMineables(manager.generation(), manager.getCategory() == Biome.Category.OCEAN);
            VanillaBiomeFeatures.addDefaultOres(manager.generation());
            VanillaBiomeFeatures.addInfestedStone(manager.generation());
        }

        private static void generateLushCaveFeatures(GlobalBiomeManager manager) {
            VanillaBiomeFeatures.addClayOre(manager.generation());
            VanillaBiomeFeatures.addLushCavesDecoration(manager.generation());
        }

        private static void generateDripstoneCaveFeatures(GlobalBiomeManager manager) {
            VanillaBiomeFeatures.addDripstone(manager.generation());
        }
    }
}

