/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import it.unimi.dsi.fastutil.ints.IntBidirectionalIterator;
import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import java.util.List;
import java.util.Random;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.gen.INoiseGenerator;
import net.minecraft.world.gen.ImprovedNoiseGenerator;

public class OctavesNoiseGen
implements INoiseGenerator {
    private final ImprovedNoiseGenerator[] noiseLevels;
    private final DoubleList amplitudes;
    private final double lowestFreqValueFactor;
    private final double lowestFreqInputFactor;

    public OctavesNoiseGen(SharedSeedRandom random, IntStream octaves) {
        this(random, (List)octaves.boxed().collect(ImmutableList.toImmutableList()));
    }

    public OctavesNoiseGen(SharedSeedRandom random, List<Integer> octaves) {
        this(random, (IntSortedSet)new IntRBTreeSet(octaves));
    }

    public static OctavesNoiseGen create(SharedSeedRandom random, int octaves, DoubleList doubles) {
        return new OctavesNoiseGen(random, (Pair<Integer, DoubleList>)Pair.of((Object)octaves, (Object)doubles));
    }

    private static Pair<Integer, DoubleList> makeAmplitudes(IntSortedSet octaves) {
        int lastInt;
        if (octaves.isEmpty()) {
            throw new IllegalArgumentException("Need some octaves!");
        }
        int firstInt = -octaves.firstInt();
        int totalOctaves = firstInt + (lastInt = octaves.lastInt()) + 1;
        if (totalOctaves < 1) {
            throw new IllegalArgumentException("Total number of octaves need to be >= 1");
        }
        DoubleArrayList doubleList = new DoubleArrayList(new double[totalOctaves]);
        IntBidirectionalIterator intBidirectionalIterator = octaves.iterator();
        while (intBidirectionalIterator.hasNext()) {
            int nextBidirectional = intBidirectionalIterator.nextInt();
            doubleList.set(nextBidirectional + firstInt, 1.0);
        }
        return Pair.of((Object)(-firstInt), (Object)doubleList);
    }

    private OctavesNoiseGen(SharedSeedRandom random, IntSortedSet octaves) {
        this(random, OctavesNoiseGen.makeAmplitudes(octaves));
    }

    public OctavesNoiseGen(SharedSeedRandom random, Pair<Integer, DoubleList> octaves) {
        double depth;
        int value = (Integer)octaves.getFirst();
        this.amplitudes = (DoubleList)octaves.getSecond();
        ImprovedNoiseGenerator improvedNoiseGenerator = new ImprovedNoiseGenerator((Random)random);
        int size = this.amplitudes.size();
        int oppositeValue = -value;
        this.noiseLevels = new ImprovedNoiseGenerator[size];
        if (oppositeValue >= 0 && oppositeValue < size && (depth = this.amplitudes.getDouble(oppositeValue)) != 0.0) {
            this.noiseLevels[oppositeValue] = improvedNoiseGenerator;
        }
        for (int i = oppositeValue - 1; i >= 0; --i) {
            if (i < size) {
                double amplitudes = this.amplitudes.getDouble(i);
                if (amplitudes != 0.0) {
                    this.noiseLevels[i] = new ImprovedNoiseGenerator((Random)random);
                    continue;
                }
                random.func_202423_a(262);
                continue;
            }
            random.func_202423_a(262);
        }
        if (oppositeValue < size - 1) {
            long noise = (long)(improvedNoiseGenerator.func_215456_a(0.0, 0.0, 0.0, 0.0, 0.0) * 9.223372036854776E18);
            SharedSeedRandom sharedSeedRandom = new SharedSeedRandom(noise);
            for (int i = oppositeValue + 1; i < size; ++i) {
                if (i >= 0) {
                    double d2 = this.amplitudes.getDouble(i);
                    if (d2 != 0.0) {
                        this.noiseLevels[value] = new ImprovedNoiseGenerator((Random)sharedSeedRandom);
                        continue;
                    }
                    sharedSeedRandom.func_202423_a(262);
                    continue;
                }
                sharedSeedRandom.func_202423_a(262);
            }
        }
        this.lowestFreqInputFactor = Math.pow(2.0, -oppositeValue);
        this.lowestFreqValueFactor = Math.pow(2.0, size - 1) / (Math.pow(2.0, size) - 1.0);
    }

    public double getValue(double x, double y, double z) {
        return this.getValue(x, y, z, 0.0, 0.0, false);
    }

    public double getValue(double x, double y, double z, double radiusX, double radiusZ, boolean flag) {
        double precision = 0.0;
        double lowestFreqInputFactor = this.lowestFreqInputFactor;
        double lowestFreqValueFactor = this.lowestFreqValueFactor;
        for (ImprovedNoiseGenerator improvednoisegenerator : this.noiseLevels) {
            if (improvednoisegenerator != null) {
                precision += improvednoisegenerator.func_215456_a(OctavesNoiseGen.maintainPrecision(x * lowestFreqInputFactor), flag ? -improvednoisegenerator.field_76313_b : OctavesNoiseGen.maintainPrecision(y * lowestFreqInputFactor), OctavesNoiseGen.maintainPrecision(z * lowestFreqInputFactor), radiusX * lowestFreqInputFactor, radiusZ * lowestFreqInputFactor) * lowestFreqValueFactor;
            }
            lowestFreqInputFactor *= 2.0;
            lowestFreqValueFactor /= 2.0;
        }
        return precision;
    }

    @Nullable
    public ImprovedNoiseGenerator getOctave(int octaveIndex) {
        return this.noiseLevels[this.noiseLevels.length - 1 - octaveIndex];
    }

    public static double maintainPrecision(double value) {
        return value - (double)MathHelper.func_76124_d((double)(value / 3.3554432E7 + 0.5)) * 3.3554432E7;
    }

    public double func_215460_a(double x, double y, double z, double value) {
        return this.getValue(x, y, 0.0, z, value, false);
    }
}

