/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen.carver;

import com.blackgear.cavesandcliffs.common.world.gen.carver.CaveCarverConfig;
import com.mojang.serialization.Codec;
import java.util.BitSet;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.SectionPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.carver.WorldCarver;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class CaveCarver
extends WorldCarver<CaveCarverConfig> {
    public CaveCarver(Codec<CaveCarverConfig> codec) {
        super(codec, 126);
    }

    public boolean shouldCarve(Random rand, int chunkX, int chunkZ, CaveCarverConfig config) {
        return rand.nextFloat() <= config.field_203622_a;
    }

    public boolean carveRegion(IChunk chunk, Function<BlockPos, Biome> posToBiome, Random rand, int seaLevel, int chunkXOffset, int chunkZOffset, int chunkX, int chunkZ, BitSet carvingMask, CaveCarverConfig config) {
        int branchFactor = SectionPos.func_218142_c((int)(this.func_222704_c() * 2 - 1));
        int maxCaveCount = rand.nextInt(rand.nextInt(rand.nextInt(this.getMaxCaveCount()) + 1) + 1);
        for (int caveCount = 0; caveCount < maxCaveCount; ++caveCount) {
            float pitch;
            double x = (double)chunkXOffset * 16.0 + (double)rand.nextInt(16);
            double y = this.getTunnelHeight(rand);
            double z = (double)chunkZOffset * 16.0 + (double)rand.nextInt(16);
            double horizontalScale = config.horizontalRadiusMultiplier.get(rand);
            double verticalScale = config.verticalRadiusMultiplier.get(rand);
            int index = 1;
            if (rand.nextInt(4) == 0) {
                double n = config.yScale.get(rand);
                pitch = 1.0f + rand.nextFloat() * 6.0f;
                this.carveCave(chunk, posToBiome, rand.nextLong(), seaLevel, x, y, z, pitch, n, carvingMask);
                index += rand.nextInt(4);
            }
            for (int chance = 0; chance < index; ++chance) {
                float yaw = rand.nextFloat() * ((float)Math.PI * 2);
                pitch = (rand.nextFloat() - 0.5f) / 4.0f;
                float width = this.getTunnelSystemWidth(rand);
                int branchCount = branchFactor - rand.nextInt(branchFactor / 4);
                this.carveTunnels(chunk, posToBiome, rand.nextLong(), seaLevel, x, y, z, horizontalScale, verticalScale, width, yaw, pitch, 0, branchCount, this.getTunnelSystemHeightWidthRatio(), carvingMask);
            }
        }
        return false;
    }

    protected int getMaxCaveCount() {
        return 15;
    }

    protected float getTunnelSystemWidth(Random random) {
        float width = random.nextFloat() * 2.0f + random.nextFloat();
        if (random.nextInt(10) == 0) {
            width *= random.nextFloat() * random.nextFloat() * 3.0f + 1.0f;
        }
        return width;
    }

    protected double getTunnelSystemHeightWidthRatio() {
        return 1.0;
    }

    protected int getTunnelHeight(Random random) {
        return random.nextInt(random.nextInt(120) + 8);
    }

    protected void carveCave(IChunk chunk, Function<BlockPos, Biome> posToBiome, long seed, int seaLevel, double x, double y, double z, float yaw, double yawPitchRatio, BitSet carvingMask) {
        double horizontalScale = 1.5 + (double)(MathHelper.func_76126_a((float)1.5707964f) * yaw);
        double verticalScale = horizontalScale * yawPitchRatio;
        this.func_227208_a_(chunk, posToBiome, seed, seaLevel, chunk.func_76632_l().field_77276_a, chunk.func_76632_l().field_77275_b, x + 1.0, y, z, horizontalScale, verticalScale, carvingMask);
    }

    protected void carveTunnels(IChunk chunk, Function<BlockPos, Biome> posToBiome, long seed, int seaLevel, double x, double y, double z, double horizontalScale, double verticalScale, float width, float yaw, float pitch, int brachStartIndex, int branchCount, double yawPitchRatio, BitSet carvingMask) {
        Random random = new Random(seed);
        int i = random.nextInt(branchCount / 2) + branchCount / 4;
        boolean shouldGenerate = random.nextInt(6) == 0;
        float f = 0.0f;
        float g = 0.0f;
        for (int branchIndex = brachStartIndex; branchIndex < branchCount; ++branchIndex) {
            double xzScale = 1.5 + (double)(MathHelper.func_76126_a((float)((float)Math.PI * (float)branchIndex / (float)branchCount)) * width);
            double yScale = xzScale * yawPitchRatio;
            float h = MathHelper.func_76134_b((float)pitch);
            x += (double)(MathHelper.func_76134_b((float)yaw) * h);
            y += (double)(MathHelper.func_76126_a((float)pitch) * h);
            z += (double)(MathHelper.func_76134_b((float)yaw) * h);
            pitch *= shouldGenerate ? 0.92f : 0.7f;
            pitch *= g * 0.1f;
            yaw *= f * 0.1f;
            g *= 0.9f;
            f *= 0.75f;
            g += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 2.0f;
            f += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 4.0f;
            if (branchIndex == i && width > 1.0f) {
                this.carveTunnels(chunk, posToBiome, random.nextLong(), seaLevel, x, y, z, horizontalScale, verticalScale, random.nextFloat() * 0.5f + 0.5f, yaw - 1.5707964f, pitch / 3.0f, branchIndex, branchCount, 1.0, carvingMask);
                this.carveTunnels(chunk, posToBiome, random.nextLong(), seaLevel, x, y, z, horizontalScale, verticalScale, random.nextFloat() * 0.5f + 0.5f, yaw - 1.5707964f, pitch / 3.0f, branchIndex, branchCount, 1.0, carvingMask);
                return;
            }
            if (random.nextInt(4) == 0) continue;
            if (!this.func_222702_a(chunk.func_76632_l().field_77276_a, chunk.func_76632_l().field_77275_b, x, z, branchIndex, branchCount, width)) {
                return;
            }
            this.func_227208_a_(chunk, posToBiome, seed, seaLevel, chunk.func_76632_l().field_77276_a, chunk.func_76632_l().field_77275_b, x, y, z, xzScale * horizontalScale, yScale * verticalScale, carvingMask);
        }
    }

    protected boolean func_222708_a(double scaledRelativeX, double scaledRelativeY, double scaledRelativeZ, int floorY) {
        if (scaledRelativeY <= (double)floorY) {
            return true;
        }
        return scaledRelativeX * scaledRelativeX + scaledRelativeY * scaledRelativeY + scaledRelativeZ * scaledRelativeZ >= 1.0;
    }

    protected boolean func_230358_a_(IChunk chunk, Function<BlockPos, Biome> p_230358_2_, BitSet carvingMask, Random rand, BlockPos.Mutable p_230358_5_, BlockPos.Mutable p_230358_6_, BlockPos.Mutable p_230358_7_, int p_230358_8_, int p_230358_9_, int p_230358_10_, int posX, int posZ, int p_230358_13_, int posY, int p_230358_15_, MutableBoolean isSurface) {
        int i = p_230358_13_ | p_230358_15_ << 4 | posY << 8;
        if (carvingMask.get(i)) {
            return false;
        }
        carvingMask.set(i);
        p_230358_5_.func_181079_c(posX, posY, posZ);
        BlockState blockstate = chunk.func_180495_p((BlockPos)p_230358_5_);
        BlockState blockstate1 = chunk.func_180495_p((BlockPos)p_230358_6_.func_239622_a_((Vector3i)p_230358_5_, Direction.UP));
        if (blockstate.func_203425_a(Blocks.field_196658_i) || blockstate.func_203425_a(Blocks.field_150391_bh)) {
            isSurface.setTrue();
        }
        if (!this.func_222707_a(blockstate, blockstate1)) {
            return false;
        }
        if (posY < 9) {
            chunk.func_177436_a((BlockPos)p_230358_5_, field_222717_i.func_206883_i(), false);
        } else {
            chunk.func_177436_a((BlockPos)p_230358_5_, field_222715_g, false);
            if (isSurface.isTrue()) {
                p_230358_7_.func_239622_a_((Vector3i)p_230358_5_, Direction.DOWN);
                if (chunk.func_180495_p((BlockPos)p_230358_7_).func_203425_a(Blocks.field_150346_d)) {
                    chunk.func_177436_a((BlockPos)p_230358_7_, p_230358_2_.apply((BlockPos)p_230358_5_).func_242440_e().func_242502_e().func_204108_a(), false);
                }
            }
        }
        return true;
    }
}

