/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen.chunk;

import com.blackgear.cavesandcliffs.common.world.gen.chunk.BaseStoneSource;
import com.blackgear.cavesandcliffs.core.registries.api.util.HeightLimitReader;
import java.util.Arrays;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.MaxMinNoiseMixer;

public interface AquiferSampler {
    public static AquiferSampler create(ChunkPos pos, MaxMinNoiseMixer edgeDensityNoise, MaxMinNoiseMixer fluidLevelNoise, MaxMinNoiseMixer fluidTypeNoise, DimensionSettings settings, int startY, int deltaY) {
        return new Impl(pos, edgeDensityNoise, fluidLevelNoise, fluidTypeNoise, settings, startY, deltaY);
    }

    public static AquiferSampler createDisabled(final int height, final BlockState state) {
        return new AquiferSampler(){

            @Override
            public BlockState apply(BaseStoneSource source, int x, int y, int z, double weight) {
                if (weight > 0.0) {
                    return source.sample(x, y, z);
                }
                return y >= height ? Blocks.field_150350_a.func_176223_P() : state;
            }

            @Override
            public boolean needsFluidTick() {
                return false;
            }
        };
    }

    public BlockState apply(BaseStoneSource var1, int var2, int var3, int var4, double var5);

    public boolean needsFluidTick();

    public static class Impl
    implements AquiferSampler {
        private final MaxMinNoiseMixer edgeDensityNoise;
        private final MaxMinNoiseMixer fluidLevelNoise;
        private final MaxMinNoiseMixer fluidTypeNoise;
        private final DimensionSettings settings;
        private final FluidLevel[] waterLevels;
        private final long[] blockPositions;
        private boolean needsFluidTick;
        private final int startX;
        private final int startY;
        private final int startZ;
        private final int sizeX;
        private final int sizeZ;

        Impl(ChunkPos pos, MaxMinNoiseMixer edgeDensityNoise, MaxMinNoiseMixer fluidLevelNoise, MaxMinNoiseMixer fluidTypeNoise, DimensionSettings settings, int startY, int deltaY) {
            this.edgeDensityNoise = edgeDensityNoise;
            this.fluidLevelNoise = fluidLevelNoise;
            this.fluidTypeNoise = fluidTypeNoise;
            this.settings = settings;
            this.startX = this.getLocalX(pos.func_180334_c()) - 1;
            int localX = this.getLocalX(pos.func_180332_e()) + 1;
            this.sizeX = localX - this.startX + 1;
            this.startY = this.getLocalY(startY) - 1;
            int localY = this.getLocalY(startY + deltaY) + 1;
            int sizeY = localY - this.startY + 1;
            this.startZ = this.getLocalZ(pos.func_180333_d()) - 1;
            int localZ = this.getLocalZ(pos.func_180330_f()) + 1;
            this.sizeZ = localZ - this.startZ + 1;
            int status = this.sizeX * sizeY * this.sizeZ;
            this.waterLevels = new FluidLevel[status];
            this.blockPositions = new long[status];
            Arrays.fill(this.blockPositions, Long.MAX_VALUE);
        }

        private int index(int x, int y, int z) {
            int xIn = x - this.startX;
            int yIn = y - this.startY;
            int zIn = z - this.startZ;
            return (yIn * this.sizeZ + zIn) * this.sizeX + xIn;
        }

        @Override
        public BlockState apply(BaseStoneSource source, int x, int y, int z, double weight) {
            if (weight <= 0.0) {
                boolean bl2;
                double as;
                BlockState blockState2;
                if (this.shouldBeLava(y)) {
                    blockState2 = Blocks.field_150353_l.func_176223_P();
                    as = 0.0;
                    bl2 = false;
                } else {
                    int l = Math.floorDiv(x - 5, 16);
                    int m = Math.floorDiv(y + 1, 12);
                    int n = Math.floorDiv(z - 5, 16);
                    int o = Integer.MAX_VALUE;
                    int p = Integer.MAX_VALUE;
                    int q = Integer.MAX_VALUE;
                    long r = 0L;
                    long s = 0L;
                    long t = 0L;
                    int u = 0;
                    while (true) {
                        if (u > 1) {
                            FluidLevel fluidLevel = this.getWaterLevel(r);
                            FluidLevel fluidLevel1 = this.getWaterLevel(s);
                            FluidLevel fluidLevel2 = this.getWaterLevel(t);
                            double f = this.maxDistance(o, p);
                            double g = this.maxDistance(o, q);
                            double h = this.maxDistance(p, q);
                            boolean bl = bl2 = f > 0.0;
                            if (fluidLevel.fluidLevel >= y && fluidLevel.fluidType.func_203425_a(Blocks.field_150355_j) && this.shouldBeLava(y - 1)) {
                                as = 1.0;
                            } else if (f > -1.0) {
                                double aj = 1.0 + (this.edgeDensityNoise.func_237211_a_((double)x, (double)y, (double)z) + 0.05) / 4.0;
                                double ak = this.calculateDensity(y, aj, fluidLevel, fluidLevel1);
                                double al = this.calculateDensity(y, aj, fluidLevel, fluidLevel2);
                                double am = this.calculateDensity(y, aj, fluidLevel1, fluidLevel2);
                                double an = Math.max(0.0, f);
                                double ao = Math.max(0.0, g);
                                double ap = Math.max(0.0, h);
                                double aq = 2.0 * an * Math.max(ak, Math.max(al * ao, am * ap));
                                as = Math.max(0.0, aq);
                            } else {
                                as = 0.0;
                            }
                            blockState2 = y >= fluidLevel.fluidLevel ? Blocks.field_150350_a.func_176223_P() : fluidLevel.fluidType;
                            break;
                        }
                        for (int v = -1; v <= 1; ++v) {
                            for (int w = 0; w <= 1; ++w) {
                                long ad;
                                int xIn = l + u;
                                int yIn = m + v;
                                int zIn = n + w;
                                int aa = this.index(xIn, yIn, zIn);
                                long ab = this.blockPositions[aa];
                                if (ab != Long.MAX_VALUE) {
                                    ad = ab;
                                } else {
                                    SharedSeedRandom seedRandom = new SharedSeedRandom(MathHelper.func_180187_c((int)xIn, (int)(yIn * 3), (int)zIn) + 1L);
                                    this.blockPositions[aa] = ad = BlockPos.func_218276_a((int)(xIn * 16 + seedRandom.nextInt(10)), (int)(yIn * 12 + seedRandom.nextInt(9)), (int)(zIn * 16 + seedRandom.nextInt(10)));
                                }
                                int ae = BlockPos.func_218290_b((long)ad) - x;
                                int af = BlockPos.func_218274_c((long)ad) - y;
                                int ag = BlockPos.func_218282_d((long)ad) - z;
                                int ah = ae * ae + af * af + ag * ag;
                                if (o >= ah) {
                                    t = s;
                                    s = r;
                                    r = ad;
                                    q = p;
                                    p = o;
                                    o = ah;
                                    continue;
                                }
                                if (p >= ah) {
                                    t = s;
                                    s = ad;
                                    q = p;
                                    p = ah;
                                    continue;
                                }
                                if (q < ah) continue;
                                t = ad;
                                q = ah;
                            }
                        }
                        ++u;
                    }
                }
                if (weight + as <= 0.0) {
                    this.needsFluidTick = bl2;
                    return blockState2;
                }
            }
            this.needsFluidTick = false;
            return source.sample(x, y, z);
        }

        @Override
        public boolean needsFluidTick() {
            return this.needsFluidTick;
        }

        private boolean shouldBeLava(int i) {
            return i - HeightLimitReader.getBottomY() <= 9;
        }

        private double maxDistance(int a, int b) {
            return 1.0 - (double)Math.abs(b - a) / 25.0;
        }

        private double calculateDensity(int y, double noise, FluidLevel first, FluidLevel second) {
            if (y <= first.fluidLevel && y <= second.fluidLevel && first.fluidType != second.fluidType) {
                return 1.0;
            }
            int i = Math.abs(first.fluidLevel - second.fluidLevel);
            double d = 0.5 * (double)(first.fluidLevel + second.fluidLevel);
            double e = Math.abs(d - (double)y - 0.5);
            return 0.5 * (double)i * noise - e;
        }

        private int getLocalX(int x) {
            return Math.floorDiv(x, 16);
        }

        private int getLocalY(int y) {
            return Math.floorDiv(y, 12);
        }

        private int getLocalZ(int z) {
            return Math.floorDiv(z, 16);
        }

        private FluidLevel getWaterLevel(long pos) {
            FluidLevel lv2;
            int n;
            int m;
            int i = BlockPos.func_218290_b((long)pos);
            int j = BlockPos.func_218274_c((long)pos);
            int k = BlockPos.func_218282_d((long)pos);
            int l = this.getLocalX(i);
            int o = this.index(l, m = this.getLocalY(j), n = this.getLocalZ(k));
            FluidLevel lv = this.waterLevels[o];
            if (lv != null) {
                return lv;
            }
            this.waterLevels[o] = lv2 = this.getWaterLevel(i, j, k);
            return lv2;
        }

        private FluidLevel getWaterLevel(int x, int y, int z) {
            int i = this.settings.func_236119_g_();
            if (y > 45) {
                return new FluidLevel(i, Blocks.field_150355_j.func_176223_P());
            }
            double d = this.fluidLevelNoise.func_237211_a_((double)Math.floorDiv(x, 64), (double)Math.floorDiv(y, 40) / 1.4, (double)Math.floorDiv(z, 64)) * 30.0 + -10.0;
            boolean bl = false;
            if (Math.abs(d) > 8.0) {
                d *= 4.0;
            }
            int m = Math.floorDiv(y, 40) * 40 + 20;
            int n = m + MathHelper.func_76128_c((double)d);
            if (m == -20) {
                double e = this.fluidTypeNoise.func_237211_a_((double)Math.floorDiv(x, 64), (double)Math.floorDiv(y, 40) / 1.4, (double)Math.floorDiv(z, 64));
                bl = Math.abs(e) > (double)0.22f;
            }
            return new FluidLevel(Math.min(56, n), bl ? Blocks.field_150353_l.func_176223_P() : Blocks.field_150355_j.func_176223_P());
        }

        static final class FluidLevel {
            private final int fluidLevel;
            private final BlockState fluidType;

            public FluidLevel(int i, BlockState blockState) {
                this.fluidLevel = i;
                this.fluidType = blockState;
            }
        }
    }
}

